/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.transform.AttributesToMapConverter;
import org.gradle.api.internal.artifacts.transform.ComponentToOperationConverter;
import org.gradle.api.internal.artifacts.transform.SnapshotTransformInputsBuildOperationResult;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResultSerializer;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceServices;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.tasks.properties.DefaultInputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.provider.Provider;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.UncategorizedBuildOperations;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.operations.dependencies.transforms.ExecuteTransformActionBuildOperationType;
import org.gradle.operations.dependencies.transforms.IdentifyTransformExecutionProgressDetails;
import org.gradle.operations.dependencies.transforms.SnapshotTransformInputsBuildOperationType;

abstract class AbstractTransformExecution
implements UnitOfWork {
    private static final CachingDisabledReason NOT_CACHEABLE = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching not enabled.");
    private static final String INPUT_ARTIFACT_PROPERTY_NAME = "inputArtifact";
    private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
    private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
    protected static final String INPUT_ARTIFACT_PATH_PROPERTY_NAME = "inputArtifactPath";
    protected static final String DEPENDENCIES_PROPERTY_NAME = "inputArtifactDependencies";
    protected static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
    private static final SnapshotTransformInputsBuildOperationType.Details SNAPSHOT_TRANSFORM_INPUTS_DETAILS = new SnapshotTransformInputsBuildOperationType.Details(){};
    protected final Transform transform;
    protected final File inputArtifact;
    private final TransformDependencies dependencies;
    private final TransformStepSubject subject;
    private final TransformExecutionListener transformExecutionListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildOperationProgressEventEmitter progressEventEmitter;
    private final FileCollectionFactory fileCollectionFactory;
    private final Provider<FileSystemLocation> inputArtifactProvider;
    protected final InputFingerprinter inputFingerprinter;
    private final TransformWorkspaceServices workspaceServices;
    private BuildOperationContext operationContext;

    public AbstractTransformExecution(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, TransformExecutionListener transformExecutionListener, BuildOperationExecutor buildOperationExecutor, BuildOperationProgressEventEmitter progressEventEmitter, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, TransformWorkspaceServices workspaceServices) {
        this.transform = transform;
        this.inputArtifact = inputArtifact;
        this.dependencies = dependencies;
        this.inputArtifactProvider = Providers.of(new DefaultFileSystemLocation(inputArtifact));
        this.subject = subject;
        this.transformExecutionListener = transformExecutionListener;
        this.buildOperationExecutor = buildOperationExecutor;
        this.progressEventEmitter = progressEventEmitter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.inputFingerprinter = inputFingerprinter;
        this.workspaceServices = workspaceServices;
    }

    @Override
    public Optional<String> getBuildOperationWorkType() {
        return Optional.of("TRANSFORM");
    }

    @Override
    public UnitOfWork.WorkOutput execute(UnitOfWork.ExecutionRequest executionRequest) {
        this.transformExecutionListener.beforeTransformExecution(this.transform, this.subject);
        try {
            UnitOfWork.WorkOutput workOutput = this.executeWithinTransformerListener(executionRequest);
            return workOutput;
        }
        finally {
            this.transformExecutionListener.afterTransformExecution(this.transform, this.subject);
        }
    }

    private UnitOfWork.WorkOutput executeWithinTransformerListener(final UnitOfWork.ExecutionRequest executionRequest) {
        final TransformExecutionResult result2 = this.buildOperationExecutor.call(new CallableBuildOperation<TransformExecutionResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TransformExecutionResult call(BuildOperationContext context) {
                try {
                    File workspace = executionRequest.getWorkspace();
                    InputChangesInternal inputChanges = executionRequest.getInputChanges().orElse(null);
                    TransformExecutionResult result2 = AbstractTransformExecution.this.transform.transform(AbstractTransformExecution.this.inputArtifactProvider, AbstractTransformExecution.getOutputDir(workspace), AbstractTransformExecution.this.dependencies, inputChanges);
                    TransformExecutionResultSerializer resultSerializer = new TransformExecutionResultSerializer(AbstractTransformExecution.getOutputDir(workspace));
                    resultSerializer.writeToFile(AbstractTransformExecution.getResultsFile(workspace), result2);
                    TransformExecutionResult transformExecutionResult = result2;
                    return transformExecutionResult;
                }
                finally {
                    context.setResult(ExecuteTransformActionBuildOperationType.RESULT_INSTANCE);
                }
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                String displayName = AbstractTransformExecution.this.transform.getDisplayName() + " " + AbstractTransformExecution.this.inputArtifact.getName();
                return BuildOperationDescriptor.displayName(displayName).details(ExecuteTransformActionBuildOperationType.DETAILS_INSTANCE).metadata(UncategorizedBuildOperations.TRANSFORM_ACTION).progressDisplayName(displayName);
            }
        });
        return new UnitOfWork.WorkOutput(){

            @Override
            public UnitOfWork.WorkResult getDidWork() {
                return UnitOfWork.WorkResult.DID_WORK;
            }

            @Override
            public Object getOutput() {
                return result2;
            }
        };
    }

    @Override
    public Object loadAlreadyProducedOutput(File workspace) {
        TransformExecutionResultSerializer resultSerializer = new TransformExecutionResultSerializer(AbstractTransformExecution.getOutputDir(workspace));
        return resultSerializer.readResultsFile(AbstractTransformExecution.getResultsFile(workspace));
    }

    @Override
    public WorkspaceProvider getWorkspaceProvider() {
        return this.workspaceServices.getWorkspaceProvider();
    }

    @Override
    public InputFingerprinter getInputFingerprinter() {
        return this.inputFingerprinter;
    }

    private static File getOutputDir(File workspace) {
        return new File(workspace, "transformed");
    }

    private static File getResultsFile(File workspace) {
        return new File(workspace, "results.bin");
    }

    @Override
    public Optional<Duration> getTimeout() {
        return Optional.empty();
    }

    @Override
    public UnitOfWork.ExecutionBehavior getExecutionBehavior() {
        return this.transform.requiresInputChanges() ? UnitOfWork.ExecutionBehavior.INCREMENTAL : UnitOfWork.ExecutionBehavior.NON_INCREMENTAL;
    }

    @Override
    public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
        visitor.visitImplementation(this.transform.getImplementationClass());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void visitIdentityInputs(UnitOfWork.InputVisitor visitor) {
        visitor.visitInputProperty(SECONDARY_INPUTS_HASH_PROPERTY_NAME, this.transform::getSecondaryInputHash);
        visitor.visitInputProperty(INPUT_ARTIFACT_PATH_PROPERTY_NAME, () -> this.transform.getInputArtifactNormalizer() == InputNormalizer.ABSOLUTE_PATH ? this.inputArtifact.getAbsolutePath() : this.inputArtifact.getName());
        visitor.visitInputFileProperty(DEPENDENCIES_PROPERTY_NAME, InputBehavior.NON_INCREMENTAL, new UnitOfWork.InputFileValueSupplier(this.dependencies, this.transform.getInputArtifactDependenciesNormalizer(), this.transform.getInputArtifactDependenciesDirectorySensitivity(), this.transform.getInputArtifactDependenciesLineEndingNormalization(), () -> this.dependencies.getFiles().orElse(FileCollectionFactory.empty())));
    }

    protected void emitIdentifyTransformExecutionProgressDetails(TransformWorkspaceIdentity transformWorkspaceIdentity) {
        this.progressEventEmitter.emitNowIfCurrent(new DefaultIdentifyTransformExecutionProgressDetails(this.inputArtifact, transformWorkspaceIdentity, this.transform, this.subject.getInitialComponentIdentifier()));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void visitRegularInputs(UnitOfWork.InputVisitor visitor) {
        visitor.visitInputFileProperty(INPUT_ARTIFACT_PROPERTY_NAME, InputBehavior.INCREMENTAL, new UnitOfWork.InputFileValueSupplier(this.inputArtifactProvider, this.transform.getInputArtifactNormalizer(), this.transform.getInputArtifactDirectorySensitivity(), this.transform.getInputArtifactLineEndingNormalization(), () -> this.fileCollectionFactory.fixed(this.inputArtifact)));
    }

    @Override
    public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
        File outputDir = AbstractTransformExecution.getOutputDir(workspace);
        File resultsFile = AbstractTransformExecution.getResultsFile(workspace);
        visitor.visitOutputProperty(OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, UnitOfWork.OutputFileValueSupplier.fromStatic(outputDir, this.fileCollectionFactory.fixed(outputDir)));
        visitor.visitOutputProperty(RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, UnitOfWork.OutputFileValueSupplier.fromStatic(resultsFile, this.fileCollectionFactory.fixed(resultsFile)));
    }

    @Override
    public void markLegacySnapshottingInputsStarted() {
        this.operationContext = this.buildOperationExecutor.start(BuildOperationDescriptor.displayName("Snapshot transform inputs").name("Snapshot transform inputs").details(SNAPSHOT_TRANSFORM_INPUTS_DETAILS));
    }

    @Override
    public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
        if (this.operationContext != null) {
            ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
            builder.add((Object)new DefaultInputFilePropertySpec(INPUT_ARTIFACT_PROPERTY_NAME, this.transform.getInputArtifactNormalizer(), FileCollectionFactory.empty(), PropertyValue.ABSENT, InputBehavior.INCREMENTAL, this.transform.getInputArtifactDirectorySensitivity(), this.transform.getInputArtifactLineEndingNormalization()));
            builder.add((Object)new DefaultInputFilePropertySpec(DEPENDENCIES_PROPERTY_NAME, this.transform.getInputArtifactDependenciesNormalizer(), FileCollectionFactory.empty(), PropertyValue.ABSENT, InputBehavior.NON_INCREMENTAL, this.transform.getInputArtifactDependenciesDirectorySensitivity(), this.transform.getInputArtifactDependenciesLineEndingNormalization()));
            this.operationContext.setResult(new SnapshotTransformInputsBuildOperationResult(cachingState, (Set<InputFilePropertySpec>)builder.build()));
            this.operationContext = null;
        }
    }

    @Override
    public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
        return this.transform.isCacheable() ? Optional.empty() : Optional.of(NOT_CACHEABLE);
    }

    @Override
    public String getDisplayName() {
        return this.transform.getDisplayName() + ": " + this.inputArtifact;
    }

    private static class DefaultIdentifyTransformExecutionProgressDetails
    implements IdentifyTransformExecutionProgressDetails {
        private final File inputArtifact;
        private final TransformWorkspaceIdentity transformWorkspaceIdentity;
        private final Transform transform;
        private final ComponentIdentifier componentIdentifier;

        public DefaultIdentifyTransformExecutionProgressDetails(File inputArtifact, TransformWorkspaceIdentity transformWorkspaceIdentity, Transform transform, ComponentIdentifier componentIdentifier) {
            this.inputArtifact = inputArtifact;
            this.transformWorkspaceIdentity = transformWorkspaceIdentity;
            this.transform = transform;
            this.componentIdentifier = componentIdentifier;
        }

        @Override
        public String getIdentity() {
            return this.transformWorkspaceIdentity.getUniqueId();
        }

        @Override
        public Map<String, String> getFromAttributes() {
            return AttributesToMapConverter.convertToMap(this.transform.getFromAttributes());
        }

        @Override
        public Map<String, String> getToAttributes() {
            return AttributesToMapConverter.convertToMap(this.transform.getToAttributes());
        }

        @Override
        public org.gradle.operations.dependencies.variants.ComponentIdentifier getComponentId() {
            return ComponentToOperationConverter.convertComponentIdentifier(this.componentIdentifier);
        }

        @Override
        public String getArtifactName() {
            return this.inputArtifact.getName();
        }

        @Override
        public Class<?> getTransformActionClass() {
            return this.transform.getImplementationClass();
        }

        @Override
        public byte[] getSecondaryInputValueHashBytes() {
            Hasher hasher = Hashing.newHasher();
            this.transformWorkspaceIdentity.getSecondaryInputsSnapshot().appendToHasher(hasher);
            return hasher.hash().toByteArray();
        }
    }
}

