/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.TransformChain;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformStepNode;
import org.gradle.api.internal.artifacts.transform.TransformStepNodeFactory;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformedExternalArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformedProjectArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;

@ThreadSafe
public class DefaultTransformedVariantFactory
implements TransformedVariantFactory {
    private final BuildOperationExecutor buildOperationExecutor;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final TransformStepNodeFactory transformStepNodeFactory;
    private final ConcurrentMap<VariantKey, ResolvedArtifactSet> variants = new ConcurrentHashMap<VariantKey, ResolvedArtifactSet>();
    private final Factory externalFactory = this::doCreateExternal;
    private final Factory projectFactory = this::doCreateProject;

    public DefaultTransformedVariantFactory(BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory, TransformStepNodeFactory transformStepNodeFactory) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.transformStepNodeFactory = transformStepNodeFactory;
    }

    @Override
    public ResolvedArtifactSet transformedExternalArtifacts(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory) {
        return this.locateOrCreate(this.externalFactory, componentIdentifier, sourceVariant, variantDefinition, dependenciesResolverFactory);
    }

    @Override
    public ResolvedArtifactSet transformedProjectArtifacts(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory) {
        return this.locateOrCreate(this.projectFactory, componentIdentifier, sourceVariant, variantDefinition, dependenciesResolverFactory);
    }

    private ResolvedArtifactSet locateOrCreate(Factory factory, ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory) {
        ResolvedArtifactSet newResult;
        ImmutableAttributes target = variantDefinition.getTargetAttributes();
        TransformChain transformChain = variantDefinition.getTransformChain();
        VariantResolveMetadata.Identifier identifier = sourceVariant.getIdentifier();
        if (identifier == null) {
            return factory.create(componentIdentifier, sourceVariant, variantDefinition, dependenciesResolverFactory);
        }
        VariantKey variantKey = transformChain.requiresDependencies() ? new VariantWithUpstreamDependenciesKey(identifier, target, dependenciesResolverFactory) : new VariantKey(identifier, target);
        ResolvedArtifactSet result2 = (ResolvedArtifactSet)this.variants.get(variantKey);
        if (result2 == null && (result2 = this.variants.putIfAbsent(variantKey, newResult = factory.create(componentIdentifier, sourceVariant, variantDefinition, dependenciesResolverFactory))) == null) {
            result2 = newResult;
        }
        return result2;
    }

    private TransformedExternalArtifactSet doCreateExternal(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory) {
        return new TransformedExternalArtifactSet(componentIdentifier, sourceVariant.getArtifacts(), variantDefinition.getTargetAttributes(), sourceVariant.getCapabilities().getCapabilities(), variantDefinition.getTransformChain(), dependenciesResolverFactory, this.calculatedValueContainerFactory);
    }

    private TransformedProjectArtifactSet doCreateProject(ComponentIdentifier componentIdentifier, ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory) {
        ResolvedArtifactSet sourceArtifacts;
        AttributeContainerInternal sourceAttributes;
        VariantDefinition previous = variantDefinition.getPrevious();
        if (previous != null) {
            sourceAttributes = previous.getTargetAttributes();
            sourceArtifacts = this.transformedProjectArtifacts(componentIdentifier, sourceVariant, previous, dependenciesResolverFactory);
        } else {
            sourceAttributes = sourceVariant.getAttributes();
            sourceArtifacts = sourceVariant.getArtifacts();
        }
        ComponentVariantIdentifier targetComponentVariant = new ComponentVariantIdentifier(componentIdentifier, variantDefinition.getTargetAttributes(), sourceVariant.getCapabilities().getCapabilities());
        List<TransformStepNode> transformStepNodes = this.createTransformStepNodes(sourceArtifacts, sourceAttributes, targetComponentVariant, variantDefinition, dependenciesResolverFactory);
        return new TransformedProjectArtifactSet(targetComponentVariant, transformStepNodes);
    }

    private List<TransformStepNode> createTransformStepNodes(ResolvedArtifactSet sourceArtifacts, final AttributeContainer sourceAttributes, final ComponentVariantIdentifier targetComponentVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory) {
        final TransformUpstreamDependenciesResolver dependenciesResolver = dependenciesResolverFactory.create(targetComponentVariant.getComponentId(), variantDefinition.getTransformChain());
        final TransformStep transformStep = variantDefinition.getTransformStep();
        final ImmutableList.Builder builder = ImmutableList.builder();
        sourceArtifacts.visitTransformSources(new ResolvedArtifactSet.TransformSourceVisitor(){

            @Override
            public void visitArtifact(ResolvableArtifact artifact) {
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(transformStep);
                TransformStepNode.InitialTransformStepNode transformStepNode = DefaultTransformedVariantFactory.this.transformStepNodeFactory.createInitial(targetComponentVariant, sourceAttributes, transformStep, artifact, upstreamDependencies, DefaultTransformedVariantFactory.this.buildOperationExecutor, DefaultTransformedVariantFactory.this.calculatedValueContainerFactory);
                builder.add((Object)transformStepNode);
            }

            @Override
            public void visitTransform(TransformStepNode source) {
                TransformUpstreamDependencies upstreamDependencies = dependenciesResolver.dependenciesFor(transformStep);
                TransformStepNode.ChainedTransformStepNode transformStepNode = DefaultTransformedVariantFactory.this.transformStepNodeFactory.createChained(targetComponentVariant, sourceAttributes, transformStep, source, upstreamDependencies, DefaultTransformedVariantFactory.this.buildOperationExecutor, DefaultTransformedVariantFactory.this.calculatedValueContainerFactory);
                builder.add((Object)transformStepNode);
            }
        });
        return builder.build();
    }

    private static class VariantWithUpstreamDependenciesKey
    extends VariantKey {
        private final TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory;

        public VariantWithUpstreamDependenciesKey(VariantResolveMetadata.Identifier sourceVariant, ImmutableAttributes target, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory) {
            super(sourceVariant, target);
            this.dependenciesResolverFactory = dependenciesResolverFactory;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.dependenciesResolverFactory.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            VariantWithUpstreamDependenciesKey other = (VariantWithUpstreamDependenciesKey)obj;
            return this.dependenciesResolverFactory == other.dependenciesResolverFactory;
        }
    }

    private static class VariantKey {
        private final VariantResolveMetadata.Identifier sourceVariant;
        private final ImmutableAttributes target;

        public VariantKey(VariantResolveMetadata.Identifier sourceVariant, ImmutableAttributes target) {
            this.sourceVariant = sourceVariant;
            this.target = target;
        }

        public int hashCode() {
            return this.sourceVariant.hashCode() ^ this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            VariantKey other = (VariantKey)obj;
            return this.sourceVariant.equals(other.sourceVariant) && this.target.equals(other.target);
        }
    }

    private static interface Factory {
        public ResolvedArtifactSet create(ComponentIdentifier var1, ResolvedVariant var2, VariantDefinition var3, TransformUpstreamDependenciesResolverFactory var4);
    }
}

