/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.internal.artifacts.transform.AbstractTransformExecution;
import org.gradle.api.internal.artifacts.transform.ImmutableTransformWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceServices;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

class ImmutableTransformExecution
extends AbstractTransformExecution {
    private static final String INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME = "inputArtifactSnapshot";
    private final FileSystemAccess fileSystemAccess;

    public ImmutableTransformExecution(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, TransformExecutionListener transformExecutionListener, BuildOperationExecutor buildOperationExecutor, BuildOperationProgressEventEmitter progressEventEmitter, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, FileSystemAccess fileSystemAccess, TransformWorkspaceServices workspaceServices) {
        super(transform, inputArtifact, dependencies, subject, transformExecutionListener, buildOperationExecutor, progressEventEmitter, fileCollectionFactory, inputFingerprinter, workspaceServices);
        this.fileSystemAccess = fileSystemAccess;
    }

    @Override
    public void visitIdentityInputs(UnitOfWork.InputVisitor visitor) {
        super.visitIdentityInputs(visitor);
        FileSystemLocationSnapshot inputArtifactSnapshot = this.fileSystemAccess.read(this.inputArtifact.getAbsolutePath());
        visitor.visitInputProperty(INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME, inputArtifactSnapshot::getHash);
    }

    @Override
    public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
        ImmutableTransformWorkspaceIdentity transformWorkspaceIdentity = new ImmutableTransformWorkspaceIdentity(identityInputs.get("inputArtifactPath"), identityInputs.get(INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME), identityInputs.get("inputPropertiesHash"), identityFileInputs.get("inputArtifactDependencies").getHash());
        this.emitIdentifyTransformExecutionProgressDetails(transformWorkspaceIdentity);
        return transformWorkspaceIdentity;
    }
}

