/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.component.SoftwareComponentContainerInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.jvm.component.internal.DefaultJvmSoftwareComponent;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;
import org.gradle.testing.base.TestingExtension;

public abstract class JavaPlugin
implements Plugin<Project> {
    public static final String PROCESS_RESOURCES_TASK_NAME = "processResources";
    public static final String CLASSES_TASK_NAME = "classes";
    public static final String COMPILE_JAVA_TASK_NAME = "compileJava";
    public static final String PROCESS_TEST_RESOURCES_TASK_NAME = "processTestResources";
    public static final String TEST_CLASSES_TASK_NAME = "testClasses";
    public static final String COMPILE_TEST_JAVA_TASK_NAME = "compileTestJava";
    public static final String TEST_TASK_NAME = "test";
    public static final String JAR_TASK_NAME = "jar";
    public static final String JAVADOC_TASK_NAME = "javadoc";
    public static final String API_CONFIGURATION_NAME = "api";
    public static final String IMPLEMENTATION_CONFIGURATION_NAME = "implementation";
    public static final String API_ELEMENTS_CONFIGURATION_NAME = "apiElements";
    public static final String COMPILE_ONLY_CONFIGURATION_NAME = "compileOnly";
    public static final String COMPILE_ONLY_API_CONFIGURATION_NAME = "compileOnlyApi";
    public static final String RUNTIME_ONLY_CONFIGURATION_NAME = "runtimeOnly";
    public static final String RUNTIME_CLASSPATH_CONFIGURATION_NAME = "runtimeClasspath";
    public static final String RUNTIME_ELEMENTS_CONFIGURATION_NAME = "runtimeElements";
    public static final String JAVADOC_ELEMENTS_CONFIGURATION_NAME = "javadocElements";
    public static final String SOURCES_ELEMENTS_CONFIGURATION_NAME = "sourcesElements";
    public static final String COMPILE_CLASSPATH_CONFIGURATION_NAME = "compileClasspath";
    public static final String ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "annotationProcessor";
    public static final String TEST_IMPLEMENTATION_CONFIGURATION_NAME = "testImplementation";
    public static final String TEST_COMPILE_ONLY_CONFIGURATION_NAME = "testCompileOnly";
    public static final String TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "testRuntimeOnly";
    public static final String TEST_COMPILE_CLASSPATH_CONFIGURATION_NAME = "testCompileClasspath";
    public static final String TEST_ANNOTATION_PROCESSOR_CONFIGURATION_NAME = "testAnnotationProcessor";
    public static final String TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME = "testRuntimeClasspath";
    private final ObjectFactory objectFactory;

    @Inject
    public JavaPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public void apply(Project project) {
        if (project.getPluginManager().hasPlugin("java-platform")) {
            throw new IllegalStateException("The \"java\" or \"java-library\" plugin cannot be applied together with the \"java-platform\" plugin. A project is either a platform or a library but cannot be both at the same time.");
        }
        ProjectInternal projectInternal = (ProjectInternal)project;
        project.getPluginManager().apply(JavaBasePlugin.class);
        project.getPluginManager().apply("org.gradle.jvm-test-suite");
        JvmSoftwareComponentInternal component = this.objectFactory.newInstance(DefaultJvmSoftwareComponent.class, "java", "main");
        project.getComponents().add(component);
        Configuration defaultConfiguration = project.getConfigurations().getByName("default");
        defaultConfiguration.extendsFrom(component.getMainFeature().getRuntimeElementsConfiguration());
        ((SoftwareComponentContainerInternal)project.getComponents()).getMainComponent().convention(component);
        JavaPluginExtension javaExtension = project.getExtensions().getByType(JavaPluginExtension.class);
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = projectInternal.getServices().get(BuildOutputCleanupRegistry.class);
        JavaPlugin.configureSourceSets(javaExtension, buildOutputCleanupRegistry);
        JavaPlugin.configureTestTaskOrdering(project.getTasks());
        JavaPlugin.configureBuiltInTest(project, component);
        JavaPlugin.configureDiagnostics(project, component);
        JavaPlugin.configureBuild(project);
    }

    private static void configureSourceSets(JavaPluginExtension pluginExtension, BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        pluginExtension.getSourceSets().all(sourceSet -> buildOutputCleanupRegistry.registerOutputs(sourceSet.getOutput()));
    }

    private static void configureTestTaskOrdering(TaskContainer tasks) {
        NamedDomainObjectSet jarTasks = tasks.withType(Jar.class);
        tasks.withType(Test.class).configureEach(arg_0 -> JavaPlugin.lambda$configureTestTaskOrdering$1((TaskCollection)jarTasks, arg_0));
    }

    private static void configureBuiltInTest(Project project, JvmSoftwareComponentInternal component) {
        TestingExtension testing = project.getExtensions().getByType(TestingExtension.class);
        NamedDomainObjectProvider<JvmTestSuite> testSuite = testing.getSuites().register(TEST_TASK_NAME, JvmTestSuite.class, suite -> {
            SourceSet testSourceSet = suite.getSources();
            ConfigurationContainer configurations = project.getConfigurations();
            Configuration testImplementationConfiguration = configurations.getByName(testSourceSet.getImplementationConfigurationName());
            Configuration testRuntimeOnlyConfiguration = configurations.getByName(testSourceSet.getRuntimeOnlyConfigurationName());
            Configuration testCompileClasspathConfiguration = configurations.getByName(testSourceSet.getCompileClasspathConfigurationName());
            Configuration testRuntimeClasspathConfiguration = configurations.getByName(testSourceSet.getRuntimeClasspathConfigurationName());
            SourceSet mainSourceSet = component.getMainFeature().getSourceSet();
            SourceSetOutput mainSourceSetOutput = mainSourceSet.getOutput();
            SourceSetOutput testSourceSetOutput = testSourceSet.getOutput();
            testSourceSet.setCompileClasspath(project.getObjects().fileCollection().from(mainSourceSetOutput, testCompileClasspathConfiguration));
            testSourceSet.setRuntimeClasspath(project.getObjects().fileCollection().from(testSourceSetOutput, mainSourceSetOutput, testRuntimeClasspathConfiguration));
            testImplementationConfiguration.extendsFrom(configurations.getByName(mainSourceSet.getImplementationConfigurationName()));
            testRuntimeOnlyConfiguration.extendsFrom(configurations.getByName(mainSourceSet.getRuntimeOnlyConfigurationName()));
        });
        testSuite.get();
        project.getTasks().named("check", task -> task.dependsOn(testSuite));
    }

    private static void configureDiagnostics(Project project, JvmSoftwareComponentInternal component) {
        project.getTasks().withType(DependencyInsightReportTask.class).configureEach(task -> new DslObject(task).getConventionMapping().map("configuration", component.getMainFeature()::getCompileClasspathConfiguration));
    }

    private static void configureBuild(Project project) {
        project.getTasks().named("buildNeeded", task -> JavaPlugin.addDependsOnTaskInOtherProjects(task, true, "buildNeeded", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
        project.getTasks().named("buildDependents", task -> JavaPlugin.addDependsOnTaskInOtherProjects(task, false, "buildDependents", TEST_RUNTIME_CLASSPATH_CONFIGURATION_NAME));
    }

    private static void addDependsOnTaskInOtherProjects(Task task, boolean useDependedOn, String otherProjectTaskName, String configurationName) {
        Project project = task.getProject();
        Configuration configuration = project.getConfigurations().getByName(configurationName);
        task.dependsOn(configuration.getTaskDependencyFromProjectDependency(useDependedOn, otherProjectTaskName));
    }

    private static /* synthetic */ void lambda$configureTestTaskOrdering$1(TaskCollection jarTasks, Test test) {
        test.shouldRunAfter(jarTasks);
    }
}

