/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.language.scala.tasks.AbstractScalaCompile;

public abstract class ScalaPlugin
implements Plugin<Project> {
    public static final String SCALA_DOC_TASK_NAME = "scaladoc";

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(ScalaBasePlugin.class);
        project.getPluginManager().apply(JavaPlugin.class);
        JvmFeatureInternal mainFeature = JavaPluginHelper.getJavaComponent(project).getMainFeature();
        ScalaPlugin.configureScaladoc(project, mainFeature);
        Configuration incrementalAnalysisElements = project.getConfigurations().getByName("incrementalScalaAnalysisElements");
        String compileTaskName = mainFeature.getSourceSet().getCompileTaskName("scala");
        NamedDomainObjectProvider compileScala = project.getTasks().withType(AbstractScalaCompile.class).named(compileTaskName);
        Provider<RegularFile> compileScalaMapping = project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + compileTaskName + ".mapping");
        compileScala.configure(task -> task.getAnalysisMappingFile().set(compileScalaMapping));
        incrementalAnalysisElements.getOutgoing().artifact(compileScalaMapping, arg_0 -> ScalaPlugin.lambda$apply$1((TaskProvider)compileScala, arg_0));
    }

    private static void configureScaladoc(Project project, JvmFeatureInternal feature) {
        project.getTasks().withType(ScalaDoc.class).configureEach(scalaDoc -> {
            scalaDoc.getConventionMapping().map("classpath", () -> {
                ConfigurableFileCollection files = project.files(new Object[0]);
                files.from(feature.getSourceSet().getOutput());
                files.from(feature.getSourceSet().getCompileClasspath());
                return files;
            });
            scalaDoc.setSource(feature.getSourceSet().getExtensions().getByType(ScalaSourceDirectorySet.class));
            scalaDoc.getCompilationOutputs().from(feature.getSourceSet().getOutput());
        });
        project.getTasks().register(SCALA_DOC_TASK_NAME, ScalaDoc.class, scalaDoc -> {
            scalaDoc.setDescription("Generates Scaladoc for the main source code.");
            scalaDoc.setGroup("documentation");
        });
    }

    private static /* synthetic */ void lambda$apply$1(TaskProvider compileScala, ConfigurablePublishArtifact configurablePublishArtifact) {
        configurablePublishArtifact.builtBy(compileScala);
    }
}

