/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.List;
import java.util.Set;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.WorkValidationException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;

public class DefaultNodeValidator
implements NodeValidator {
    @Override
    public boolean hasValidationProblems(LocalTaskNode node) {
        WorkValidationContext validationContext = this.validateNode(node);
        List<ReportableProblem> problems = validationContext.getProblems();
        this.logWarnings(problems);
        this.reportErrors(problems, node.getTask(), validationContext);
        return !problems.isEmpty();
    }

    private WorkValidationContext validateNode(LocalTaskNode node) {
        WorkValidationContext validationContext = node.getValidationContext();
        Class<?> taskType = GeneratedSubclasses.unpackType(node.getTask());
        TypeValidationContext typeValidationContext = validationContext.forType(taskType, false);
        node.getTaskProperties().validateType(typeValidationContext);
        return validationContext;
    }

    private void logWarnings(List<? extends Problem> problems) {
        problems.stream().filter(problem2 -> problem2.getSeverity().isWarning()).forEach(problem2 -> {
            String warning = TypeValidationProblemRenderer.convertToSingleLine(TypeValidationProblemRenderer.renderMinimalInformationAbout(problem2, false, false));
            DeprecationMessageBuilder.withDocumentation(problem2, ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour(warning).withContext("Execution optimizations are disabled to ensure correctness.")).willBeRemovedInGradle9()).nagUser();
        });
    }

    private void reportErrors(List<? extends Problem> problems, TaskInternal task, WorkValidationContext validationContext) {
        Set<String> uniqueErrors = DefaultNodeValidator.getUniqueErrors(problems);
        if (!uniqueErrors.isEmpty()) {
            throw WorkValidationException.forProblems(uniqueErrors).withSummaryForContext(task.toString(), validationContext).get();
        }
    }

    private static Set<String> getUniqueErrors(List<? extends Problem> problems) {
        return (Set)problems.stream().filter(problem2 -> !problem2.getSeverity().isWarning()).map(TypeValidationProblemRenderer::renderMinimalInformationAbout).collect(ImmutableSet.toImmutableSet());
    }
}

