/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.GradleApiSpecAggregator;
import org.gradle.initialization.GradleApiSpecProvider;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.reflect.Instantiator;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry {
    private final ClassLoader apiOnlyClassLoader;
    private final ClassLoader apiAndPluginsClassLoader;
    private final ClassLoader pluginsClassLoader;
    private final FilteringClassLoader.Spec gradleApiSpec;
    private final MixInLegacyTypesClassLoader.Spec workerExtensionSpec;
    private final Instantiator instantiator;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, LegacyTypesSupport legacyTypesSupport, Instantiator instantiator2) {
        this.instantiator = instantiator2;
        ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
        this.apiOnlyClassLoader = this.restrictToGradleApi(runtimeClassLoader);
        this.pluginsClassLoader = new MixInLegacyTypesClassLoader(runtimeClassLoader, classPathRegistry.getClassPath("GRADLE_EXTENSIONS"), legacyTypesSupport);
        this.gradleApiSpec = this.apiSpecFor(this.pluginsClassLoader);
        this.workerExtensionSpec = new MixInLegacyTypesClassLoader.Spec("legacy-mixin-loader", classPathRegistry.getClassPath("GRADLE_WORKER_EXTENSIONS").getAsURLs());
        this.apiAndPluginsClassLoader = DefaultClassLoaderRegistry.restrictTo(this.gradleApiSpec, this.pluginsClassLoader);
        Instrumented.CallInterceptorRegistry.loadCallInterceptors(this.pluginsClassLoader);
    }

    private ClassLoader restrictToGradleApi(ClassLoader classLoader) {
        return DefaultClassLoaderRegistry.restrictTo(this.apiSpecFor(classLoader), classLoader);
    }

    private static ClassLoader restrictTo(FilteringClassLoader.Spec spec, ClassLoader parent) {
        return new FilteringClassLoader(parent, spec);
    }

    private FilteringClassLoader.Spec apiSpecFor(ClassLoader classLoader) {
        FilteringClassLoader.Spec apiSpec = new FilteringClassLoader.Spec();
        GradleApiSpecProvider.Spec apiAggregate = new GradleApiSpecAggregator(classLoader, this.instantiator).aggregate();
        for (String string2 : apiAggregate.getExportedResources()) {
            apiSpec.allowResource(string2);
        }
        for (String string3 : apiAggregate.getExportedResourcePrefixes()) {
            apiSpec.allowResources(string3);
        }
        for (Class clazz : apiAggregate.getExportedClasses()) {
            apiSpec.allowClass(clazz);
        }
        for (String string4 : apiAggregate.getExportedPackages()) {
            apiSpec.allowPackage(string4);
        }
        return apiSpec;
    }

    @Override
    public ClassLoader getRuntimeClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public ClassLoader getGradleApiClassLoader() {
        return this.apiAndPluginsClassLoader;
    }

    @Override
    public ClassLoader getPluginsClassLoader() {
        return this.pluginsClassLoader;
    }

    @Override
    public ClassLoader getGradleCoreApiClassLoader() {
        return this.apiOnlyClassLoader;
    }

    @Override
    public FilteringClassLoader.Spec getGradleApiFilterSpec() {
        return new FilteringClassLoader.Spec(this.gradleApiSpec);
    }

    @Override
    public MixInLegacyTypesClassLoader.Spec getGradleWorkerExtensionSpec() {
        return this.workerExtensionSpec;
    }
}

