/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.model.IvyArtifactName;

public class ComponentFileArtifactIdentifier
implements ComponentArtifactIdentifier,
DisplayName {
    private final ComponentIdentifier componentId;
    private final Object fileName;

    public ComponentFileArtifactIdentifier(ComponentIdentifier componentId, String fileName) {
        this(componentId, (Object)fileName);
    }

    public ComponentFileArtifactIdentifier(ComponentIdentifier componentId, IvyArtifactName artifactName) {
        this(componentId, (Object)artifactName);
    }

    ComponentFileArtifactIdentifier(ComponentIdentifier componentId, Object fileName) {
        this.componentId = componentId;
        this.fileName = fileName;
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return this.componentId;
    }

    public String getFileName() {
        return this.fileName.toString();
    }

    public Object getRawFileName() {
        return this.fileName;
    }

    @Override
    public String getDisplayName() {
        return this.fileName + " (" + this.componentId + ")";
    }

    @Override
    public String getCapitalizedDisplayName() {
        return this.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ComponentFileArtifactIdentifier other = (ComponentFileArtifactIdentifier)obj;
        return this.componentId.equals(other.componentId) && this.fileName.equals(other.fileName);
    }

    public int hashCode() {
        return this.componentId.hashCode() ^ this.fileName.hashCode();
    }
}

