/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.protocol;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gradle.api.logging.LogLevel;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;
import org.gradle.internal.logging.serializer.LogEventSerializer;
import org.gradle.internal.logging.serializer.LogLevelChangeEventSerializer;
import org.gradle.internal.logging.serializer.ProgressCompleteEventSerializer;
import org.gradle.internal.logging.serializer.ProgressEventSerializer;
import org.gradle.internal.logging.serializer.ProgressStartEventSerializer;
import org.gradle.internal.logging.serializer.PromptOutputEventSerializer;
import org.gradle.internal.logging.serializer.SpanSerializer;
import org.gradle.internal.logging.serializer.StyledTextOutputEventSerializer;
import org.gradle.internal.logging.serializer.UserInputRequestEventSerializer;
import org.gradle.internal.logging.serializer.UserInputResumeEventSerializer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.Cancel;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.serialization.SerializedPayloadSerializer;

public class DaemonMessageSerializer {
    public static Serializer<Message> create(Serializer<BuildAction> buildActionSerializer) {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        Serializer<LogLevel> logLevelSerializer = factory.getSerializerFor(LogLevel.class);
        Serializer<Throwable> throwableSerializer = factory.getSerializerFor(Throwable.class);
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(Build.class, new BuildSerializer(buildActionSerializer));
        registry.register(Cancel.class, new CancelSerializer());
        registry.register(DaemonUnavailable.class, new DaemonUnavailableSerializer());
        registry.register(BuildStarted.class, new BuildStartedSerializer());
        registry.register(Failure.class, new FailureSerializer(throwableSerializer));
        registry.register(Success.class, new SuccessSerializer());
        registry.register(Finished.class, new FinishedSerializer());
        registry.register(BuildEvent.class, new BuildEventSerializer());
        registry.register(ForwardInput.class, new ForwardInputSerializer());
        registry.register(CloseInput.class, new CloseInputSerializer());
        registry.register(LogEvent.class, new LogEventSerializer(logLevelSerializer, throwableSerializer));
        registry.register(UserInputRequestEvent.class, new UserInputRequestEventSerializer());
        registry.register(PromptOutputEvent.class, new PromptOutputEventSerializer());
        registry.register(UserInputResumeEvent.class, new UserInputResumeEventSerializer());
        registry.register(StyledTextOutputEvent.class, new StyledTextOutputEventSerializer(logLevelSerializer, new ListSerializer<StyledTextOutputEvent.Span>(new SpanSerializer(factory.getSerializerFor(StyledTextOutput.Style.class)))));
        registry.register(ProgressStartEvent.class, new ProgressStartEventSerializer());
        registry.register(ProgressCompleteEvent.class, new ProgressCompleteEventSerializer());
        registry.register(ProgressEvent.class, new ProgressEventSerializer());
        registry.register(LogLevelChangeEvent.class, new LogLevelChangeEventSerializer(logLevelSerializer));
        registry.register(OutputMessage.class, new OutputMessageSerializer(registry.build(OutputEvent.class)));
        registry.useJavaSerialization(Message.class);
        return registry.build(Message.class);
    }

    private static class FinishedSerializer
    implements Serializer<Finished> {
        private FinishedSerializer() {
        }

        @Override
        public Finished read(Decoder decoder) {
            return new Finished();
        }

        @Override
        public void write(Encoder encoder, Finished value) {
        }
    }

    private static class BuildStartedSerializer
    implements Serializer<BuildStarted> {
        private BuildStartedSerializer() {
        }

        @Override
        public void write(Encoder encoder, BuildStarted buildStarted) throws Exception {
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, buildStarted.getDiagnostics().getDaemonLog());
            if (buildStarted.getDiagnostics().getPid() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeLong(buildStarted.getDiagnostics().getPid());
            }
        }

        @Override
        public BuildStarted read(Decoder decoder) throws Exception {
            File log2 = BaseSerializerFactory.FILE_SERIALIZER.read(decoder);
            boolean nonNull = decoder.readBoolean();
            Long pid = null;
            if (nonNull) {
                pid = decoder.readLong();
            }
            return new BuildStarted(new DaemonDiagnostics(log2, pid));
        }
    }

    private static class CancelSerializer
    implements Serializer<Cancel> {
        private CancelSerializer() {
        }

        @Override
        public void write(Encoder encoder, Cancel value) {
        }

        @Override
        public Cancel read(Decoder decoder) {
            return new Cancel();
        }
    }

    private static class DaemonUnavailableSerializer
    implements Serializer<DaemonUnavailable> {
        private DaemonUnavailableSerializer() {
        }

        @Override
        public void write(Encoder encoder, DaemonUnavailable value) throws Exception {
            encoder.writeNullableString(value.getReason());
        }

        @Override
        public DaemonUnavailable read(Decoder decoder) throws Exception {
            return new DaemonUnavailable(decoder.readNullableString());
        }
    }

    private static class BuildActionParametersSerializer
    implements Serializer<BuildActionParameters> {
        private final Serializer<LogLevel> logLevelSerializer = new BaseSerializerFactory().getSerializerFor(LogLevel.class);
        private final Serializer<List<File>> classPathSerializer = new ListSerializer<File>(BaseSerializerFactory.FILE_SERIALIZER);

        BuildActionParametersSerializer() {
        }

        @Override
        public void write(Encoder encoder, BuildActionParameters parameters) throws Exception {
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, parameters.getCurrentDir());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, parameters.getSystemProperties());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, parameters.getEnvVariables());
            this.logLevelSerializer.write(encoder, parameters.getLogLevel());
            encoder.writeBoolean(parameters.isUseDaemon());
            this.classPathSerializer.write(encoder, parameters.getInjectedPluginClasspath().getAsFiles());
        }

        @Override
        public BuildActionParameters read(Decoder decoder) throws Exception {
            File currentDir = BaseSerializerFactory.FILE_SERIALIZER.read(decoder);
            Map<String, String> sysProperties = BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder);
            Map<String, String> envVariables = BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder);
            LogLevel logLevel = this.logLevelSerializer.read(decoder);
            boolean useDaemon = decoder.readBoolean();
            ClassPath classPath = DefaultClassPath.of((Collection<File>)this.classPathSerializer.read(decoder));
            return new DefaultBuildActionParameters(sysProperties, envVariables, currentDir, logLevel, useDaemon, classPath);
        }
    }

    private static class BuildSerializer
    implements Serializer<Build> {
        private final Serializer<BuildAction> buildActionSerializer;
        private final Serializer<BuildActionParameters> buildActionParametersSerializer = new BuildActionParametersSerializer();

        private BuildSerializer(Serializer<BuildAction> buildActionSerializer) {
            this.buildActionSerializer = buildActionSerializer;
        }

        @Override
        public void write(Encoder encoder, Build build2) throws Exception {
            encoder.writeLong(build2.getIdentifier().getMostSignificantBits());
            encoder.writeLong(build2.getIdentifier().getLeastSignificantBits());
            encoder.writeBinary(build2.getToken());
            encoder.writeLong(build2.getStartTime());
            encoder.writeBoolean(build2.isInteractive());
            this.buildActionSerializer.write(encoder, build2.getAction());
            GradleLauncherMetaData metaData = (GradleLauncherMetaData)build2.getBuildClientMetaData();
            encoder.writeString(metaData.getAppName());
            this.buildActionParametersSerializer.write(encoder, build2.getParameters());
        }

        @Override
        public Build read(Decoder decoder) throws Exception {
            UUID uuid = new UUID(decoder.readLong(), decoder.readLong());
            byte[] token = decoder.readBinary();
            long timestamp = decoder.readLong();
            boolean interactive = decoder.readBoolean();
            BuildAction buildAction = this.buildActionSerializer.read(decoder);
            GradleLauncherMetaData metaData = new GradleLauncherMetaData(decoder.readString());
            BuildActionParameters buildActionParameters = this.buildActionParametersSerializer.read(decoder);
            return new Build(uuid, token, buildAction, metaData, timestamp, interactive, buildActionParameters);
        }
    }

    private static class OutputMessageSerializer
    implements Serializer<OutputMessage> {
        private final Serializer<OutputEvent> eventSerializer;

        OutputMessageSerializer(Serializer<OutputEvent> eventSerializer) {
            this.eventSerializer = eventSerializer;
        }

        @Override
        public void write(Encoder encoder, OutputMessage message) throws Exception {
            this.eventSerializer.write(encoder, message.getEvent());
        }

        @Override
        public OutputMessage read(Decoder decoder) throws Exception {
            return new OutputMessage(this.eventSerializer.read(decoder));
        }
    }

    private static class CloseInputSerializer
    implements Serializer<CloseInput> {
        private CloseInputSerializer() {
        }

        @Override
        public void write(Encoder encoder, CloseInput value) {
        }

        @Override
        public CloseInput read(Decoder decoder) {
            return new CloseInput();
        }
    }

    private static class ForwardInputSerializer
    implements Serializer<ForwardInput> {
        private ForwardInputSerializer() {
        }

        @Override
        public void write(Encoder encoder, ForwardInput message) throws Exception {
            encoder.writeBinary(message.getBytes());
        }

        @Override
        public ForwardInput read(Decoder decoder) throws Exception {
            return new ForwardInput(decoder.readBinary());
        }
    }

    private static class BuildEventSerializer
    implements Serializer<BuildEvent> {
        private final Serializer<Object> payloadSerializer = new DefaultSerializer<Object>();

        private BuildEventSerializer() {
        }

        @Override
        public void write(Encoder encoder, BuildEvent buildEvent) throws Exception {
            this.payloadSerializer.write(encoder, buildEvent.getPayload());
        }

        @Override
        public BuildEvent read(Decoder decoder) throws Exception {
            return new BuildEvent(this.payloadSerializer.read(decoder));
        }
    }

    private static class FailureSerializer
    implements Serializer<Failure> {
        private final Serializer<Throwable> throwableSerializer;

        FailureSerializer(Serializer<Throwable> throwableSerializer) {
            this.throwableSerializer = throwableSerializer;
        }

        @Override
        public void write(Encoder encoder, Failure failure) throws Exception {
            this.throwableSerializer.write(encoder, (Throwable)failure.getValue());
        }

        @Override
        public Failure read(Decoder decoder) throws Exception {
            return new Failure(this.throwableSerializer.read(decoder));
        }
    }

    private static class SuccessSerializer
    implements Serializer<Success> {
        private final Serializer<Object> javaSerializer = new DefaultSerializer<Object>();
        private final Serializer<SerializedPayload> payloadSerializer = new SerializedPayloadSerializer();

        private SuccessSerializer() {
        }

        @Override
        public void write(Encoder encoder, Success success) throws Exception {
            if (success.getValue() == null) {
                encoder.writeByte((byte)0);
            } else if (success.getValue() instanceof BuildActionResult) {
                BuildActionResult result2 = (BuildActionResult)success.getValue();
                if (result2.getResult() != null) {
                    if (result2.getException() != null || result2.getFailure() != null || result2.wasCancelled()) {
                        throw new IllegalArgumentException("Result should not have both a result object and a failure associated with it.");
                    }
                    if (result2.getResult().getHeader() == null && result2.getResult().getSerializedModel().isEmpty()) {
                        encoder.writeByte((byte)1);
                    } else {
                        encoder.writeByte((byte)2);
                        this.payloadSerializer.write(encoder, result2.getResult());
                    }
                } else if (result2.getFailure() != null) {
                    encoder.writeByte((byte)3);
                    encoder.writeBoolean(result2.wasCancelled());
                    this.payloadSerializer.write(encoder, result2.getFailure());
                } else {
                    encoder.writeByte((byte)4);
                    encoder.writeBoolean(result2.wasCancelled());
                    this.javaSerializer.write(encoder, result2.getException());
                }
            } else {
                encoder.writeByte((byte)5);
                this.javaSerializer.write(encoder, success.getValue());
            }
        }

        @Override
        public Success read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            switch (tag) {
                case 0: {
                    return new Success((Object)null);
                }
                case 1: {
                    return new Success(BuildActionResult.of(new SerializedPayload(null, Collections.emptyList())));
                }
                case 2: {
                    SerializedPayload result2 = this.payloadSerializer.read(decoder);
                    return new Success(BuildActionResult.of(result2));
                }
                case 3: {
                    boolean wasCancelled = decoder.readBoolean();
                    SerializedPayload failure = this.payloadSerializer.read(decoder);
                    return new Success(BuildActionResult.failed(wasCancelled, failure, null));
                }
                case 4: {
                    boolean wasCancelled = decoder.readBoolean();
                    RuntimeException exception = (RuntimeException)this.javaSerializer.read(decoder);
                    return new Success(BuildActionResult.failed(wasCancelled, null, exception));
                }
                case 5: {
                    return new Success(this.javaSerializer.read(decoder));
                }
            }
            throw new IllegalArgumentException("Unexpected payload type.");
        }
    }
}

