/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.model.internal.manage.schema.AbstractModelSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;

public abstract class AbstractStructSchema<T>
extends AbstractModelSchema<T>
implements StructSchema<T> {
    private final ImmutableSortedMap<String, ModelProperty<?>> properties;
    private final Set<WeaklyTypeReferencingMethod<?, ?>> nonPropertyMethods;
    private final Map<Class<? extends ModelSchemaAspect>, ModelSchemaAspect> aspects;

    public AbstractStructSchema(ModelType<T> type, Iterable<ModelProperty<?>> properties, Iterable<WeaklyTypeReferencingMethod<?, ?>> nonPropertyMethods, Iterable<ModelSchemaAspect> aspects) {
        super(type);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (ModelProperty<?> property2 : properties) {
            builder.put((Object)property2.getName(), property2);
        }
        this.properties = builder.build();
        this.nonPropertyMethods = ImmutableSet.copyOf(nonPropertyMethods);
        this.aspects = Maps.uniqueIndex(aspects, (Function)new Function<ModelSchemaAspect, Class<? extends ModelSchemaAspect>>(){

            public Class<? extends ModelSchemaAspect> apply(ModelSchemaAspect aspect) {
                return aspect.getClass();
            }
        });
    }

    @Override
    public SortedSet<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public Collection<ModelProperty<?>> getProperties() {
        return this.properties.values();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey((Object)name);
    }

    @Override
    public ModelProperty<?> getProperty(String name) {
        return (ModelProperty)this.properties.get((Object)name);
    }

    @Override
    public Set<WeaklyTypeReferencingMethod<?, ?>> getNonPropertyMethods() {
        return this.nonPropertyMethods;
    }

    @Override
    public Set<WeaklyTypeReferencingMethod<?, ?>> getAllMethods() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModelProperty property2 : this.properties.values()) {
            builder.addAll(property2.getAccessors());
        }
        builder.addAll(this.nonPropertyMethods);
        return builder.build();
    }

    @Override
    public boolean hasAspect(Class<? extends ModelSchemaAspect> aspectType) {
        return this.aspects.containsKey(aspectType);
    }

    @Override
    public <A extends ModelSchemaAspect> A getAspect(Class<A> aspectType) {
        return (A)((ModelSchemaAspect)Cast.uncheckedCast(this.aspects.get(aspectType)));
    }

    @Override
    public Collection<ModelSchemaAspect> getAspects() {
        return this.aspects.values();
    }
}

