/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedScheduledExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.process.internal.health.memory.JvmMemoryInfo;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.health.memory.JvmMemoryStatusListener;
import org.gradle.process.internal.health.memory.MemoryHolder;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusAspect;
import org.gradle.process.internal.health.memory.OsMemoryStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMemoryManager
implements MemoryManager,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMemoryManager.class);
    public static final int STATUS_INTERVAL_SECONDS = 5;
    private static final double DEFAULT_MIN_FREE_MEMORY_PERCENTAGE = 0.1;
    private static final long MIN_THRESHOLD_BYTES = 0x18000000L;
    private final double minFreeMemoryPercentage;
    private final OsMemoryInfo osMemoryInfo;
    private final JvmMemoryInfo jvmMemoryInfo;
    private final ListenerManager listenerManager;
    private final ManagedScheduledExecutor scheduler;
    private final JvmMemoryStatusListener jvmBroadcast;
    private final OsMemoryStatusListener osBroadcast;
    private final boolean osMemoryStatusSupported;
    private final Object holdersLock = new Object();
    private final Object memoryLock = new Object();
    private final List<MemoryHolder> holders = new ArrayList<MemoryHolder>();
    private OsMemoryStatus currentOsMemoryStatus;
    private final OsMemoryStatusListener osMemoryStatusListener;

    public DefaultMemoryManager(OsMemoryInfo osMemoryInfo, JvmMemoryInfo jvmMemoryInfo, ListenerManager listenerManager, ExecutorFactory executorFactory) {
        this(osMemoryInfo, jvmMemoryInfo, listenerManager, executorFactory, 0.1, true);
    }

    @VisibleForTesting
    DefaultMemoryManager(OsMemoryInfo osMemoryInfo, JvmMemoryInfo jvmMemoryInfo, ListenerManager listenerManager, ExecutorFactory executorFactory, double minFreeMemoryPercentage, boolean autoFree) {
        Preconditions.checkArgument((minFreeMemoryPercentage >= 0.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be >= 0");
        Preconditions.checkArgument((minFreeMemoryPercentage <= 1.0 ? 1 : 0) != 0, (Object)"Free memory percentage must be <= 1");
        this.minFreeMemoryPercentage = minFreeMemoryPercentage;
        this.osMemoryInfo = osMemoryInfo;
        this.jvmMemoryInfo = jvmMemoryInfo;
        this.listenerManager = listenerManager;
        this.scheduler = executorFactory.createScheduled("Memory manager", 1);
        this.jvmBroadcast = listenerManager.getBroadcaster(JvmMemoryStatusListener.class);
        this.osBroadcast = listenerManager.getBroadcaster(OsMemoryStatusListener.class);
        this.osMemoryStatusSupported = this.supportsOsMemoryStatus();
        this.osMemoryStatusListener = new OsMemoryListener(autoFree);
        this.start();
    }

    private boolean supportsOsMemoryStatus() {
        try {
            this.osMemoryInfo.getOsSnapshot();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private void start() {
        this.scheduler.scheduleAtFixedRate(new MemoryCheck(), 5L, 5L, TimeUnit.SECONDS);
        LOGGER.debug("Memory status broadcaster started");
        if (this.osMemoryStatusSupported) {
            this.addListener(this.osMemoryStatusListener);
        } else {
            LOGGER.info("This JVM does not support getting OS memory, so no OS memory status updates will be broadcast");
        }
    }

    @Override
    public void stop() {
        this.scheduler.stop();
        this.listenerManager.removeListener(this.osMemoryStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFreeMemory(long memoryAmountBytes) {
        Object object = this.memoryLock;
        synchronized (object) {
            if (this.currentOsMemoryStatus != null) {
                boolean freedPhysical = this.freeSpecificMemory(this.currentOsMemoryStatus.getPhysicalMemory(), memoryAmountBytes);
                boolean freedVirtual = this.freeSpecificMemory(this.currentOsMemoryStatus.getVirtualMemory(), memoryAmountBytes);
                if (freedPhysical || freedVirtual) {
                    this.currentOsMemoryStatus = null;
                }
            } else {
                LOGGER.debug("There is no current snapshot of OS memory available - memory cannot be freed until a new memory status update occurs");
            }
        }
    }

    private boolean freeSpecificMemory(OsMemoryStatusAspect status, long memoryAmountBytes) {
        if (status instanceof OsMemoryStatusAspect.Unavailable) {
            return false;
        }
        long totalMemory = ((OsMemoryStatusAspect.Available)status).getTotal();
        long freeMemory = ((OsMemoryStatusAspect.Available)status).getFree();
        long requestedFreeMemory = this.getMemoryThresholdInBytes(totalMemory) + (memoryAmountBytes > 0L ? memoryAmountBytes : 0L);
        long newFreeMemory = this.doRequestFreeMemory(status.getName(), requestedFreeMemory, freeMemory);
        return newFreeMemory > freeMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doRequestFreeMemory(String name, long requestedFreeMemory, long freeMemory) {
        long toReleaseMemory = requestedFreeMemory;
        if (freeMemory < requestedFreeMemory) {
            ArrayList<MemoryHolder> memoryHolders;
            LOGGER.debug("{} {} memory requested, {} free", new Object[]{requestedFreeMemory, name, freeMemory});
            Iterator iterator = this.holdersLock;
            synchronized (iterator) {
                memoryHolders = new ArrayList<MemoryHolder>(this.holders);
            }
            for (MemoryHolder holder : memoryHolders) {
                long released = holder.attemptToRelease(toReleaseMemory);
                toReleaseMemory -= released;
                if ((freeMemory += released) < requestedFreeMemory) continue;
                break;
            }
            LOGGER.debug("{} {} memory requested, {} released, {} free", new Object[]{requestedFreeMemory, name, requestedFreeMemory - toReleaseMemory, freeMemory});
        }
        return freeMemory;
    }

    private long getMemoryThresholdInBytes(long totalMemory) {
        return Math.max(0x18000000L, (long)((double)totalMemory * this.minFreeMemoryPercentage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMemoryHolder(MemoryHolder holder) {
        Object object = this.holdersLock;
        synchronized (object) {
            this.holders.add(holder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMemoryHolder(MemoryHolder holder) {
        Object object = this.holdersLock;
        synchronized (object) {
            this.holders.remove(holder);
        }
    }

    @Override
    public void addListener(JvmMemoryStatusListener listener2) {
        this.listenerManager.addListener(listener2);
    }

    @Override
    public void addListener(OsMemoryStatusListener listener2) {
        this.listenerManager.addListener(listener2);
    }

    @Override
    public void removeListener(JvmMemoryStatusListener listener2) {
        this.listenerManager.removeListener(listener2);
    }

    @Override
    public void removeListener(OsMemoryStatusListener listener2) {
        this.listenerManager.removeListener(listener2);
    }

    private class OsMemoryListener
    implements OsMemoryStatusListener {
        private final boolean autoFree;

        private OsMemoryListener(boolean autoFree) {
            this.autoFree = autoFree;
        }

        @Override
        public void onOsMemoryStatus(OsMemoryStatus os) {
            DefaultMemoryManager.this.currentOsMemoryStatus = os;
            if (this.autoFree) {
                DefaultMemoryManager.this.requestFreeMemory(0L);
            }
        }
    }

    private class MemoryCheck
    implements Runnable {
        private MemoryCheck() {
        }

        @Override
        public void run() {
            try {
                if (DefaultMemoryManager.this.osMemoryStatusSupported) {
                    OsMemoryStatus os = DefaultMemoryManager.this.osMemoryInfo.getOsSnapshot();
                    DefaultMemoryManager.this.osBroadcast.onOsMemoryStatus(os);
                }
                JvmMemoryStatus jvm = DefaultMemoryManager.this.jvmMemoryInfo.getJvmSnapshot();
                DefaultMemoryManager.this.jvmBroadcast.onJvmMemoryStatus(jvm);
            }
            catch (Throwable t) {
                LOGGER.debug("Failed to collect memory status: {}", (Object)t.getMessage(), (Object)t);
            }
        }
    }
}

