/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.sourceSetModel;

import com.intellij.gradle.toolingExtension.impl.model.sourceSetModel.DefaultGradleSourceSetModel;
import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import com.intellij.gradle.toolingExtension.util.GradleNegotiationUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.tooling.model.ProjectIdentifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@ApiStatus.Internal
public class GradleSourceSetCache {
    private final ModelBuilderContext context;
    private final ConcurrentMap<ProjectIdentifier, DefaultGradleSourceSetModel> allSourceSetModels;
    @NotNull
    private static final ModelBuilderContext.DataProvider<GradleSourceSetCache> INSTANCE_PROVIDER = GradleSourceSetCache::new;

    private GradleSourceSetCache(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleSourceSetCache.$$$reportNull$$$0(0);
        }
        this.context = context;
        this.allSourceSetModels = new ConcurrentHashMap<ProjectIdentifier, DefaultGradleSourceSetModel>();
    }

    @NotNull
    public DefaultGradleSourceSetModel getSourceSetModel(@NotNull Project project) {
        ProjectIdentifier projectIdentifier;
        DefaultGradleSourceSetModel sourceSetModel;
        if (project == null) {
            GradleSourceSetCache.$$$reportNull$$$0(1);
        }
        if ((sourceSetModel = (DefaultGradleSourceSetModel)this.allSourceSetModels.get(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project))) == null) {
            this.context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.cacheGet.group").withTitle("Source set model isn't found").withText("Source sets for " + GradleNegotiationUtil.getProjectDisplayName((Project)project) + " wasn't collected. All source sets should be collected during " + GradleModelFetchPhase.PROJECT_SOURCE_SET_PHASE + ".").withException((Exception)new IllegalStateException()).withKind(Message.Kind.INTERNAL).reportMessage(project);
            return new DefaultGradleSourceSetModel();
        }
        DefaultGradleSourceSetModel defaultGradleSourceSetModel = sourceSetModel;
        if (defaultGradleSourceSetModel == null) {
            GradleSourceSetCache.$$$reportNull$$$0(2);
        }
        return defaultGradleSourceSetModel;
    }

    public void setSourceSetModel(@NotNull Project project, @NotNull DefaultGradleSourceSetModel sourceSetModel) {
        ProjectIdentifier projectIdentifier;
        DefaultGradleSourceSetModel previousSourceSetModel;
        if (project == null) {
            GradleSourceSetCache.$$$reportNull$$$0(3);
        }
        if (sourceSetModel == null) {
            GradleSourceSetCache.$$$reportNull$$$0(4);
        }
        if ((previousSourceSetModel = this.allSourceSetModels.put(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project), sourceSetModel)) != null) {
            this.context.getMessageReporter().createMessage().withGroup("gradle.sourceSetModel.cacheSet.group").withTitle("Source set model redefinition").withText("Source sets for " + GradleNegotiationUtil.getProjectDisplayName((Project)project) + " was already collected.").withException((Exception)new IllegalStateException()).withKind(Message.Kind.INTERNAL).reportMessage(project);
        }
    }

    public void markSourceSetModelAsError(@NotNull Project project) {
        if (project == null) {
            GradleSourceSetCache.$$$reportNull$$$0(5);
        }
        ProjectIdentifier projectIdentifier = GradleProjectUtil.getProjectIdentifier(project);
        this.allSourceSetModels.put(projectIdentifier, new DefaultGradleSourceSetModel());
    }

    @NotNull
    public static GradleSourceSetCache getInstance(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleSourceSetCache.$$$reportNull$$$0(6);
        }
        GradleSourceSetCache gradleSourceSetCache = (GradleSourceSetCache)context.getData(INSTANCE_PROVIDER);
        if (gradleSourceSetCache == null) {
            GradleSourceSetCache.$$$reportNull$$$0(7);
        }
        return gradleSourceSetCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSetModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/sourceSetModel/GradleSourceSetCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceSetModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSourceSetModel";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSourceSetModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markSourceSetModelAsError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

