/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.intellij.collaboration.api.data.GraphQLRequestPagination;
import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.changes.GitBranchComparisonResult;
import git4idea.changes.GitBranchComparisonResultImpl;
import git4idea.changes.GitCommitShaWithPatches;
import git4idea.fetch.GitFetchSupport;
import git4idea.remote.GitRemoteUrlCoordinates;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHCommitHash;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommit;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHServiceUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJH\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\"0\u0010H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0011H\u0016J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020$0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0011H\u0016J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0011H\u0002J0\u0010+\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\"0\u00100\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016J&\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J&\u00101\u001a\b\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020\u0011H\u0016J$\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00192\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00b3\u0001\u0010\u000e\u001a\u00a6\u0001\u00122\u00120\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u0011 \u0013*\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u00120\u0010j\u0002`\u0012\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0015 \u0013*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0014 \u0013*R\u00122\u00120\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u0011 \u0013*\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\u0004\u0018\u0001`\u00120\u0010j\u0002`\u0012\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0015 \u0013*\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u0014\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;", "Lcom/intellij/openapi/Disposable;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "project", "Lcom/intellij/openapi/project/Project;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "gitRemote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "ghRepository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/progress/ProgressManager;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lgit4idea/remote/GitRemoteUrlCoordinates;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "patchesCache", "Lcom/github/benmanes/caffeine/cache/AsyncLoadingCache;", "Lkotlin/Pair;", "", "Lorg/jetbrains/plugins/github/pullrequest/data/service/DiffSpec;", "kotlin.jvm.PlatformType", "", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "patchesLoadingIndicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "createChangesProvider", "Ljava/util/concurrent/CompletableFuture;", "Lgit4idea/changes/GitBranchComparisonResult;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "baseRef", "mergeBaseRef", "headRef", "commits", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "Lcom/google/common/graph/Graph;", "dispose", "", "fetch", "refspec", "fetchBranch", "branch", "loadCommitDiff", "oid", "loadCommitsFromApi", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "loadDiff", "ref1", "ref2", "loadMergeBaseOid", "baseRefOid", "headRefOid", "loadPatch", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRChangesServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRChangesServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n10#2:189\n*S KotlinDebug\n*F\n+ 1 GHPRChangesServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesServiceImpl\n*L\n129#1:189\n*E\n"})
public final class GHPRChangesServiceImpl
implements GHPRChangesService,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final Project project;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GitRemoteUrlCoordinates gitRemote;
    @NotNull
    private final GHRepositoryCoordinates ghRepository;
    @NotNull
    private final EmptyProgressIndicator patchesLoadingIndicator;
    private final AsyncLoadingCache<Pair<String, String>, List<FilePatch>> patchesCache;
    @NotNull
    private static final Logger LOG;

    public GHPRChangesServiceImpl(@NotNull ProgressManager progressManager, @NotNull Project project, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRemoteUrlCoordinates gitRemote, @NotNull GHRepositoryCoordinates ghRepository) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)gitRemote, (String)"gitRemote");
        Intrinsics.checkNotNullParameter((Object)ghRepository, (String)"ghRepository");
        this.progressManager = progressManager;
        this.project = project;
        this.requestExecutor = requestExecutor;
        this.gitRemote = gitRemote;
        this.ghRepository = ghRepository;
        this.patchesLoadingIndicator = new EmptyProgressIndicator();
        this.patchesCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).executor((Executor)ProcessIOExecutorService.INSTANCE).buildAsync((arg_0, arg_1) -> GHPRChangesServiceImpl.patchesCache$lambda$1(this, arg_0, arg_1));
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> fetch(@NotNull ProgressIndicator progressIndicator, @NotNull String refspec) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)refspec, (String)"refspec");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, refspec){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $refspec;
            {
                this.this$0 = $receiver;
                this.$refspec = $refspec;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GitFetchSupport.fetchSupport((Project)GHPRChangesServiceImpl.access$getProject$p(this.this$0)).fetch(GHPRChangesServiceImpl.access$getGitRemote$p(this.this$0).getRepository(), GHPRChangesServiceImpl.access$getGitRemote$p(this.this$0).getRemote(), this.$refspec).throwExceptionIfFailed();
            }
        }), LOG, "Error occurred while fetching \"" + refspec + "\"");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> fetchBranch(@NotNull ProgressIndicator progressIndicator, @NotNull String branch) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return GHServiceUtil.INSTANCE.logError(this.fetch(progressIndicator, branch), LOG, "Error occurred while fetching \"" + branch + "\"");
    }

    @Override
    @NotNull
    public CompletableFuture<Pair<GHCommit, Graph<GHCommit>>> loadCommitsFromApi(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Pair<? extends GHCommit, ? extends Graph<GHCommit>>>(this, pullRequestId){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<GHCommit, Graph<GHCommit>> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable $this$map$iv = new SimpleGHGQLPagesLoader<T>(GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0), (Function1)new Function1<GraphQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHPullRequestCommit>>>(this.this$0, this.$pullRequestId){
                    final /* synthetic */ GHPRChangesServiceImpl this$0;
                    final /* synthetic */ GHPRIdentifier $pullRequestId;
                    {
                        this.this$0 = $receiver;
                        this.$pullRequestId = $pullRequestId;
                        super(1);
                    }

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHPullRequestCommit>> invoke(@NotNull GraphQLRequestPagination p) {
                        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                        return GHGQLRequests.PullRequest.INSTANCE.commits(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0), this.$pullRequestId.getNumber(), p);
                    }
                }, false, 0, 12, null).loadAll(indicator);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GHPullRequestCommit gHPullRequestCommit = (GHPullRequestCommit)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getCommit());
                }
                List list = (List)destination$iv$iv;
                Companion companion = GHPRChangesServiceImpl.Companion;
                List p0 = list;
                boolean bl = false;
                return org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$buildCommitsTree(companion, p0);
            }
        }), LOG, "Error occurred while loading commits for PR " + pullRequestId.getNumber());
    }

    private final CompletableFuture<String> loadCommitDiff(ProgressIndicator progressIndicator, String oid) {
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, String>(this, oid){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $oid;
            {
                this.this$0 = $receiver;
                this.$oid = $oid;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.Commits.getDiff(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0), this.$oid));
            }
        }), LOG, "Error occurred while loading diffs for commit " + oid);
    }

    private final CompletableFuture<String> loadDiff(ProgressIndicator progressIndicator, String ref1, String ref2) {
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, String>(this, ref1, ref2){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $ref1;
            final /* synthetic */ String $ref2;
            {
                this.this$0 = $receiver;
                this.$ref1 = $ref1;
                this.$ref2 = $ref2;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.Commits.getDiff(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0), this.$ref1, this.$ref2));
            }
        }), LOG, "Error occurred while loading diffs between " + ref1 + " and " + ref2);
    }

    @Override
    @NotNull
    public CompletableFuture<String> loadMergeBaseOid(@NotNull ProgressIndicator progressIndicator, @NotNull String baseRefOid, @NotNull String headRefOid) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)baseRefOid, (String)"baseRefOid");
        Intrinsics.checkNotNullParameter((Object)headRefOid, (String)"headRefOid");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, String>(this, baseRefOid, headRefOid){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $baseRefOid;
            final /* synthetic */ String $headRefOid;
            {
                this.this$0 = $receiver;
                this.$baseRefOid = $baseRefOid;
                this.$headRefOid = $headRefOid;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.Commits.compare(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0), this.$baseRefOid, this.$headRefOid)).getMergeBaseCommit().getSha();
            }
        }), LOG, "Error occurred while calculating merge base for " + baseRefOid + " and " + headRefOid);
    }

    @Override
    @NotNull
    public CompletableFuture<List<FilePatch>> loadPatch(@NotNull String ref1, @NotNull String ref2) {
        Intrinsics.checkNotNullParameter((Object)ref1, (String)"ref1");
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref2");
        CompletableFuture completableFuture = this.patchesCache.get((Object)TuplesKt.to((Object)ref1, (Object)ref2));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"get(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<GitBranchComparisonResult> createChangesProvider(@NotNull ProgressIndicator progressIndicator, @NotNull String baseRef, @NotNull String mergeBaseRef, @NotNull String headRef, @NotNull Pair<GHCommit, ? extends Graph<GHCommit>> commits) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)baseRef, (String)"baseRef");
        Intrinsics.checkNotNullParameter((Object)mergeBaseRef, (String)"mergeBaseRef");
        Intrinsics.checkNotNullParameter((Object)headRef, (String)"headRef");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        ProgressWrapper progressWrapper = ProgressWrapper.wrap((ProgressIndicator)progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)progressWrapper, (String)"wrap(...)");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, (ProgressIndicator)progressWrapper, (Function1)new Function1<ProgressIndicator, GitBranchComparisonResult>(this, baseRef, headRef, commits, mergeBaseRef){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $baseRef;
            final /* synthetic */ String $headRef;
            final /* synthetic */ Pair<GHCommit, Graph<GHCommit>> $commits;
            final /* synthetic */ String $mergeBaseRef;
            {
                this.this$0 = $receiver;
                this.$baseRef = $baseRef;
                this.$headRef = $headRef;
                this.$commits = $commits;
                this.$mergeBaseRef = $mergeBaseRef;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GitBranchComparisonResult invoke(@NotNull ProgressIndicator it) {
                void $this$mapTo$iv$iv;
                Object object;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CompletableFuture prPatchesRequest = GHPRChangesServiceImpl.access$getPatchesCache$p(this.this$0).get((Object)TuplesKt.to((Object)this.$baseRef, (Object)this.$headRef));
                Pair<GHCommit, Graph<GHCommit>> pair = this.$commits;
                GHCommit lastCommit = (GHCommit)pair.component1();
                Graph graph = (Graph)pair.component2();
                LinkedHashMap<K, V> commitsPatchesRequests = new LinkedHashMap<K, V>();
                for (GHCommit commit : Traverser.forGraph((SuccessorsFunction)((SuccessorsFunction)graph)).depthFirstPostOrder((Object)lastCommit)) {
                    CompletableFuture completableFuture;
                    Map map2 = commitsPatchesRequests;
                    Intrinsics.checkNotNull((Object)commit);
                    object = commit;
                    Intrinsics.checkNotNullExpressionValue((Object)GHPRChangesServiceImpl.access$getPatchesCache$p(this.this$0).get((Object)TuplesKt.to(null, (Object)commit.getOid())), (String)"get(...)");
                    map2.put(object, completableFuture);
                }
                Map $this$map$iv = commitsPatchesRequests;
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    GHCommit commit = (GHCommit)entry.getKey();
                    CompletableFuture request = (CompletableFuture)entry.getValue();
                    List patches = (List)org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$joinCancellable(GHPRChangesServiceImpl.Companion, request);
                    Iterable iterable = commit.getParents();
                    String string = commit.getOid();
                    boolean $i$f$map2 = false;
                    void var23_24 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it2;
                        GHCommitHash gHCommitHash = (GHCommitHash)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection2.add(it2.getOid());
                    }
                    List list = patches;
                    List list2 = (List)destination$iv$iv2;
                    String string2 = string;
                    collection.add(new GitCommitShaWithPatches(string2, list2, list));
                }
                List commitsList = (List)destination$iv$iv;
                Intrinsics.checkNotNull((Object)prPatchesRequest);
                List prPatches = (List)org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$joinCancellable(GHPRChangesServiceImpl.Companion, prPatchesRequest);
                it.checkCanceled();
                Project project = GHPRChangesServiceImpl.access$getProject$p(this.this$0);
                VirtualFile virtualFile = GHPRChangesServiceImpl.access$getGitRemote$p(this.this$0).getRepository().getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                Intrinsics.checkNotNull((Object)prPatches);
                return (GitBranchComparisonResult)new GitBranchComparisonResultImpl(project, virtualFile, this.$baseRef, this.$mergeBaseRef, commitsList, prPatches);
            }
        }), LOG, "Error occurred while building changes from commits");
    }

    public void dispose() {
        this.patchesLoadingIndicator.cancel();
    }

    private static final List patchesCache$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final CompletableFuture patchesCache$lambda$1(GHPRChangesServiceImpl this$0, Pair key, Executor executor) {
        CompletableFuture<String> completableFuture;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String ref1 = (String)key.component1();
        String ref2 = (String)key.component2();
        if (ref1 == null) {
            ProgressWrapper progressWrapper = ProgressWrapper.wrap((ProgressIndicator)((ProgressIndicator)this$0.patchesLoadingIndicator));
            Intrinsics.checkNotNullExpressionValue((Object)progressWrapper, (String)"wrap(...)");
            completableFuture = this$0.loadCommitDiff((ProgressIndicator)progressWrapper, ref2);
        } else {
            ProgressWrapper progressWrapper = ProgressWrapper.wrap((ProgressIndicator)((ProgressIndicator)this$0.patchesLoadingIndicator));
            Intrinsics.checkNotNullExpressionValue((Object)progressWrapper, (String)"wrap(...)");
            completableFuture = this$0.loadDiff((ProgressIndicator)progressWrapper, ref1, ref2);
        }
        return completableFuture.thenApplyAsync(arg_0 -> GHPRChangesServiceImpl.patchesCache$lambda$1$lambda$0(patchesCache.1.1.INSTANCE, arg_0), executor);
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRChangesServiceImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ GitRemoteUrlCoordinates access$getGitRemote$p(GHPRChangesServiceImpl $this) {
        return $this.gitRemote;
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRChangesServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHRepositoryCoordinates access$getGhRepository$p(GHPRChangesServiceImpl $this) {
        return $this.ghRepository;
    }

    public static final /* synthetic */ AsyncLoadingCache access$getPatchesCache$p(GHPRChangesServiceImpl $this) {
        return $this.patchesCache;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRChangesService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001d\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "buildCommitsTree", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "Lcom/google/common/graph/Graph;", "commits", "", "readAllPatches", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "diffFile", "", "joinCancellable", "T", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGHPRChangesServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRChangesServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesServiceImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> T joinCancellable(CompletableFuture<T> $this$joinCancellable) throws ProcessCanceledException {
            try {
                return $this$joinCancellable.join();
            }
            catch (CancellationException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (CompletionException e) {
                if (CompletableFutureUtil.INSTANCE.isCancellation((Throwable)e)) {
                    throw new ProcessCanceledException((Throwable)e);
                }
                throw CompletableFutureUtil.INSTANCE.extractError((Throwable)e);
            }
        }

        private final List<FilePatch> readAllPatches(String diffFile) {
            PatchReader reader = new PatchReader((CharSequence)diffFile, true);
            reader.parseAllPatches();
            List list = reader.getAllPatches();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllPatches(...)");
            return list;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<GHCommit, Graph<GHCommit>> buildCommitsTree(List<GHCommit> commits) {
            void $this$buildCommitsTree_u24lambda_u241;
            ImmutableGraph.Builder builder;
            GHCommit gHCommit;
            Map commitsBySha;
            block3: {
                commitsBySha = new LinkedHashMap();
                Set parentCommits = new LinkedHashSet();
                for (GHCommit commit : commits) {
                    commitsBySha.put(commit.getOid(), commit);
                    parentCommits.addAll((Collection)commit.getParents());
                }
                List<GHCommit> list = commits;
                ListIterator<GHCommit> listIterator = list.listIterator(list.size());
                while (listIterator.hasPrevious()) {
                    GHCommit gHCommit2;
                    GHCommit it = gHCommit2 = listIterator.previous();
                    boolean bl = false;
                    if (!(!parentCommits.contains(it))) continue;
                    gHCommit = gHCommit2;
                    break block3;
                }
                gHCommit = null;
            }
            GHCommit gHCommit3 = gHCommit;
            if (gHCommit3 == null) {
                throw new IllegalStateException("Could not determine last commit".toString());
            }
            GHCommit lastCommit = gHCommit3;
            ImmutableGraph.Builder builder2 = builder = GraphBuilder.directed().allowsSelfLoops(false).immutable();
            GHCommit gHCommit4 = lastCommit;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$buildCommitsTree_u24lambda_u241);
            org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.buildCommitsTree$addCommits((ImmutableGraph.Builder<GHCommit>)$this$buildCommitsTree_u24lambda_u241, commitsBySha, lastCommit);
            return TuplesKt.to((Object)gHCommit4, (Object)builder.build());
        }

        private static final void buildCommitsTree$addCommits(ImmutableGraph.Builder<GHCommit> $this$buildCommitsTree_u24addCommits, Map<String, GHCommit> commitsBySha, GHCommit commit) {
            $this$buildCommitsTree_u24addCommits.addNode((Object)commit);
            for (GHCommitHash parent : commit.getParents()) {
                GHCommit parentCommit = commitsBySha.get(parent.getOid());
                if (parentCommit == null) continue;
                $this$buildCommitsTree_u24addCommits.putEdge((Object)commit, (Object)parentCommit);
                org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.buildCommitsTree$addCommits($this$buildCommitsTree_u24addCommits, commitsBySha, parentCommit);
            }
        }

        public static final /* synthetic */ Pair access$buildCommitsTree(Companion $this, List commits) {
            return $this.buildCommitsTree(commits);
        }

        public static final /* synthetic */ Object access$joinCancellable(Companion $this, CompletableFuture $receiver) {
            return $this.joinCancellable($receiver);
        }

        public static final /* synthetic */ List access$readAllPatches(Companion $this, String diffFile) {
            return $this.readAllPatches(diffFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

