/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.internal.thread.graph;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.testng.TestNGException;
import org.gradle.internal.impldep.org.testng.collections.Lists;
import org.gradle.internal.impldep.org.testng.internal.DynamicGraph;
import org.gradle.internal.impldep.org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.gradle.internal.impldep.org.testng.internal.thread.graph.IWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphThreadPoolExecutor<T>
extends ThreadPoolExecutor {
    private static final boolean DEBUG = false;
    private static final boolean DOT_FILES = false;
    private DynamicGraph<T> m_graph;
    private List<Runnable> m_activeRunnables = Lists.newArrayList();
    private IThreadWorkerFactory<T> m_factory;
    private List<String> m_dotFiles = Lists.newArrayList();
    private int m_threadCount;

    public GraphThreadPoolExecutor(DynamicGraph<T> graph, IThreadWorkerFactory<T> factory, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        this.ppp("Initializing executor with " + corePoolSize + " threads and following graph " + graph);
        this.m_threadCount = maximumPoolSize;
        this.m_graph = graph;
        this.m_factory = factory;
        if (this.m_graph.getFreeNodes().isEmpty()) {
            throw new TestNGException("The graph of methods contains a cycle:" + graph.getEdges());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            List<T> freeNodes = this.m_graph.getFreeNodes();
            this.runNodes(freeNodes);
        }
    }

    private void runNodes(List<T> freeNodes) {
        List<IWorker<T>> runnables = this.m_factory.createWorkers(freeNodes);
        for (IWorker<T> r : runnables) {
            this.m_activeRunnables.add(r);
            this.ppp("Added to active runnable");
            this.setStatus(r, DynamicGraph.Status.RUNNING);
            this.ppp("Executing: " + r);
            try {
                this.execute(r);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(IWorker<T> worker, DynamicGraph.Status status) {
        this.ppp("Set status:" + worker + " status:" + (Object)((Object)status));
        if (status == DynamicGraph.Status.FINISHED) {
            this.m_activeRunnables.remove(worker);
        }
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            for (T m : worker.getTasks()) {
                this.m_graph.setStatus(m, status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterExecute(Runnable r, Throwable t) {
        this.ppp("Finished runnable:" + r);
        this.setStatus((IWorker)r, DynamicGraph.Status.FINISHED);
        DynamicGraph<T> dynamicGraph = this.m_graph;
        synchronized (dynamicGraph) {
            this.ppp("Node count:" + this.m_graph.getNodeCount() + " and " + this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED) + " finished");
            if (this.m_graph.getNodeCount() == this.m_graph.getNodeCountWithStatus(DynamicGraph.Status.FINISHED)) {
                this.ppp("Shutting down executor " + this);
                this.shutdown();
            } else {
                List<T> freeNodes = this.m_graph.getFreeNodes();
                this.runNodes(freeNodes);
            }
        }
    }

    private void generateFiles(List<String> files) {
        try {
            File dir2 = File.createTempFile("TestNG-", "");
            dir2.delete();
            dir2.mkdir();
            for (int i = 0; i < files.size(); ++i) {
                File f = new File(dir2, "" + (i < 10 ? "0" : "") + i + ".dot");
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.append(files.get(i));
                bw.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void ppp(String string) {
    }
}

