/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_util;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import org.assertj.swing.dependency.fest_util.Arrays;
import org.assertj.swing.dependency.fest_util.ToString;

final class ArrayFormatter {
    private static final String NULL = "null";

    ArrayFormatter() {
    }

    String format(Object o) {
        if (!Arrays.isArray(o)) {
            return null;
        }
        return this.isObjectArray(o) ? this.formatObjectArray(o) : this.formatPrimitiveArray(o);
    }

    private String formatObjectArray(Object o) {
        Object[] array = (Object[])o;
        int size = array.length;
        if (size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(20 * (size - 1));
        this.deepToString(array, buffer, new HashSet<Object[]>());
        return buffer.toString();
    }

    private void deepToString(Object[] array, StringBuilder buffer, Set<Object[]> alreadyFormatted) {
        if (array == null) {
            buffer.append(NULL);
            return;
        }
        alreadyFormatted.add(array);
        buffer.append('[');
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            Object element2;
            if (i != 0) {
                buffer.append(", ");
            }
            if (!Arrays.isArray(element2 = array[i])) {
                buffer.append(element2 == null ? NULL : ToString.toStringOf(element2));
                continue;
            }
            if (!this.isObjectArray(element2)) {
                buffer.append(this.formatPrimitiveArray(element2));
                continue;
            }
            if (alreadyFormatted.contains(element2)) {
                buffer.append("[...]");
                continue;
            }
            this.deepToString((Object[])element2, buffer, alreadyFormatted);
        }
        buffer.append(']');
        alreadyFormatted.remove(array);
    }

    private boolean isObjectArray(Object o) {
        return Arrays.isArray(o) && !this.isArrayTypePrimitive(o);
    }

    private String formatPrimitiveArray(Object o) {
        if (!Arrays.isArray(o)) {
            return null;
        }
        if (!this.isArrayTypePrimitive(o)) {
            throw this.notAnArrayOfPrimitives(o);
        }
        int size = Array.getLength(o);
        if (size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        buffer.append(Array.get(o, 0));
        for (int i = 1; i < size; ++i) {
            buffer.append(", ");
            buffer.append(Array.get(o, i));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private boolean isArrayTypePrimitive(Object o) {
        return o.getClass().getComponentType().isPrimitive();
    }

    private IllegalArgumentException notAnArrayOfPrimitives(Object o) {
        return new IllegalArgumentException(String.format("<%s> is not an array of primitives", o));
    }
}

