/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.invoker;

import java.io.PrintStream;
import org.apache.maven.shared.invoker.InvocationOutputHandler;

public class PrintStreamHandler
implements InvocationOutputHandler {
    private PrintStream out;
    private boolean alwaysFlush;

    public PrintStreamHandler() {
        this(System.out, false);
    }

    public PrintStreamHandler(PrintStream out, boolean alwaysFlush) {
        if (out == null) {
            throw new NullPointerException("missing output stream");
        }
        this.out = out;
        this.alwaysFlush = alwaysFlush;
    }

    @Override
    public void consumeLine(String line) {
        if (line == null) {
            this.out.println();
        } else {
            this.out.println(line);
        }
        if (this.alwaysFlush) {
            this.out.flush();
        }
    }
}

