/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.ErrorAnalyzer;
import com.intellij.uiDesigner.ErrorInfo;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.componentTree.ComponentSelectionListener;
import com.intellij.uiDesigner.designSurface.GlassLayer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.quickFixes.QuickFixManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class QuickFixManagerImpl
extends QuickFixManager<GlassLayer> {
    public QuickFixManagerImpl(GuiEditor editor, GlassLayer component, JViewport viewPort) {
        super(editor, component, viewPort);
        editor.addComponentSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectedComponentChanged(@NotNull GuiEditor source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickFixManagerImpl.this.hideIntentionHint();
                QuickFixManagerImpl.this.updateIntentionHintVisibility();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/uiDesigner/designSurface/QuickFixManagerImpl$1", "selectedComponentChanged"));
            }
        });
    }

    @Override
    protected ErrorInfo @NotNull [] getErrorInfos() {
        ArrayList<RadComponent> list = FormEditingUtil.getSelectedComponents(this.getEditor());
        if (list.size() != 1) {
            if (ErrorInfo.EMPTY_ARRAY == null) {
                QuickFixManagerImpl.$$$reportNull$$$0(0);
            }
            return ErrorInfo.EMPTY_ARRAY;
        }
        ErrorInfo[] errorInfoArray = ErrorAnalyzer.getAllErrorsForComponent(list.get(0));
        if (errorInfoArray == null) {
            QuickFixManagerImpl.$$$reportNull$$$0(1);
        }
        return errorInfoArray;
    }

    @Override
    protected Rectangle getErrorBounds() {
        ArrayList<RadComponent> list = FormEditingUtil.getSelectedComponents(this.getEditor());
        if (list.size() != 1) {
            return null;
        }
        RadComponent c = list.get(0);
        return SwingUtilities.convertRectangle(c.getDelegee().getParent(), c.getBounds(), this.getEditor().getGlassLayer());
    }

    @Override
    protected Rectangle getHintClipRect(JViewport viewPort) {
        Rectangle rc = viewPort.getViewRect();
        rc.grow(4, 4);
        return rc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/designSurface/QuickFixManagerImpl", "getErrorInfos"));
    }
}

