/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProtoContainer {
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;
    @Nullable
    private final SourceElement source;

    private ProtoContainer(NameResolver nameResolver2, TypeTable typeTable, SourceElement source) {
        this.nameResolver = nameResolver2;
        this.typeTable = typeTable;
        this.source = source;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    @Nullable
    public final SourceElement getSource() {
        return this.source;
    }

    @NotNull
    public abstract FqName debugFqName();

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.debugFqName();
    }

    public /* synthetic */ ProtoContainer(NameResolver nameResolver2, TypeTable typeTable, SourceElement source, DefaultConstructorMarker $constructor_marker) {
        this(nameResolver2, typeTable, source);
    }

    public static final class Class
    extends ProtoContainer {
        @NotNull
        private final ProtoBuf.Class classProto;
        @Nullable
        private final Class outerClass;
        @NotNull
        private final ClassId classId;
        @NotNull
        private final ProtoBuf.Class.Kind kind;
        private final boolean isInner;

        public Class(@NotNull ProtoBuf.Class classProto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @Nullable SourceElement source, @Nullable Class outerClass) {
            Intrinsics.checkNotNullParameter((Object)classProto, (String)"classProto");
            Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
            super(nameResolver2, typeTable, source, null);
            this.classProto = classProto;
            this.outerClass = outerClass;
            this.classId = NameResolverUtilKt.getClassId(nameResolver2, this.classProto.getFqName());
            Object object = Flags.CLASS_KIND.get(this.classProto.getFlags());
            this.kind = object == null ? ProtoBuf.Class.Kind.CLASS : object;
            object = Flags.IS_INNER.get(this.classProto.getFlags());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"IS_INNER.get(classProto.flags)");
            this.isInner = (Boolean)object;
        }

        @NotNull
        public final ProtoBuf.Class getClassProto() {
            return this.classProto;
        }

        @Nullable
        public final Class getOuterClass() {
            return this.outerClass;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @NotNull
        public final ProtoBuf.Class.Kind getKind() {
            return this.kind;
        }

        public final boolean isInner() {
            return this.isInner;
        }

        @Override
        @NotNull
        public FqName debugFqName() {
            FqName fqName2 = this.classId.asSingleFqName();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.asSingleFqName()");
            return fqName2;
        }
    }

    public static final class Package
    extends ProtoContainer {
        @NotNull
        private final FqName fqName;

        public Package(@NotNull FqName fqName2, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @Nullable SourceElement source) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
            Intrinsics.checkNotNullParameter((Object)typeTable, (String)"typeTable");
            super(nameResolver2, typeTable, source, null);
            this.fqName = fqName2;
        }

        @Override
        @NotNull
        public FqName debugFqName() {
            return this.fqName;
        }
    }
}

