/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.model.NoThreadInfoInProfilerData;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BQ\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0016R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/CollapsedDumpParser;", "FrameItem", "", "Lcom/intellij/profiler/LineByLineParser;", "dataBuilder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "threadNameMapper", "Lkotlin/Function1;", "", "Lcom/intellij/profiler/model/ThreadInfo;", "frameItemMapper", "firstFrameIsThreadNameValidator", "", "(Lcom/intellij/profiler/DummyCallTreeBuilder;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "cachedFrames", "Ljava/util/concurrent/ConcurrentHashMap;", "getDataBuilder", "()Lcom/intellij/profiler/DummyCallTreeBuilder;", "firstFrameIsThread", "Lcom/intellij/util/ThreeState;", "consumeLine", "", "line", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCollapsedDumpParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollapsedDumpParser.kt\ncom/intellij/profiler/CollapsedDumpParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1549#2:49\n1620#2,3:50\n*S KotlinDebug\n*F\n+ 1 CollapsedDumpParser.kt\ncom/intellij/profiler/CollapsedDumpParser\n*L\n42#1:49\n42#1:50,3\n*E\n"})
public final class CollapsedDumpParser<FrameItem>
extends LineByLineParser {
    @NotNull
    private final DummyCallTreeBuilder<FrameItem> dataBuilder;
    @NotNull
    private final Function1<String, ThreadInfo> threadNameMapper;
    @NotNull
    private final Function1<String, FrameItem> frameItemMapper;
    @NotNull
    private final Function1<String, Boolean> firstFrameIsThreadNameValidator;
    @NotNull
    private final ConcurrentHashMap<String, FrameItem> cachedFrames;
    @NotNull
    private ThreeState firstFrameIsThread;

    public CollapsedDumpParser(@NotNull DummyCallTreeBuilder<FrameItem> dataBuilder, @NotNull Function1<? super String, ? extends ThreadInfo> threadNameMapper, @NotNull Function1<? super String, ? extends FrameItem> frameItemMapper, @NotNull Function1<? super String, Boolean> firstFrameIsThreadNameValidator) {
        Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
        Intrinsics.checkNotNullParameter(threadNameMapper, (String)"threadNameMapper");
        Intrinsics.checkNotNullParameter(frameItemMapper, (String)"frameItemMapper");
        Intrinsics.checkNotNullParameter(firstFrameIsThreadNameValidator, (String)"firstFrameIsThreadNameValidator");
        this.dataBuilder = dataBuilder;
        this.threadNameMapper = threadNameMapper;
        this.frameItemMapper = frameItemMapper;
        this.firstFrameIsThreadNameValidator = firstFrameIsThreadNameValidator;
        this.cachedFrames = new ConcurrentHashMap();
        this.firstFrameIsThread = ThreeState.UNSURE;
    }

    public /* synthetic */ CollapsedDumpParser(DummyCallTreeBuilder dummyCallTreeBuilder, Function1 function1, Function1 function12, Function1 function13, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function13 = 1.INSTANCE;
        }
        this(dummyCallTreeBuilder, (Function1<? super String, ? extends ThreadInfo>)function1, function12, (Function1<? super String, Boolean>)function13);
    }

    @NotNull
    public final DummyCallTreeBuilder<FrameItem> getDataBuilder() {
        return this.dataBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void consumeLine(@NotNull String line) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String framesString = StringsKt.substringBeforeLast((String)line, (char)' ', (String)"");
        Long count = StringsKt.toLongOrNull((String)StringsKt.substringAfterLast$default((String)line, (char)' ', null, (int)2, null));
        if (count == null || ((CharSequence)framesString).length() == 0) {
            int n = this.getBadLines();
            this.setBadLines(n + 1);
            return;
        }
        char[] cArray = new char[]{';'};
        List parts = StringsKt.split$default((CharSequence)framesString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (this.firstFrameIsThread == ThreeState.UNSURE) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)((Boolean)this.firstFrameIsThreadNameValidator.invoke(CollectionsKt.first((List)parts))));
            Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"fromBoolean(...)");
            this.firstFrameIsThread = threeState;
        }
        if (this.firstFrameIsThread.toBoolean() && parts.size() == 1) {
            int n = this.getBadLines();
            this.setBadLines(n + 1);
            return;
        }
        ThreadInfo thread2 = null;
        List frames = null;
        if (this.firstFrameIsThread.toBoolean()) {
            thread2 = (ThreadInfo)this.threadNameMapper.invoke(CollectionsKt.first((List)parts));
            frames = CollectionsKt.drop((Iterable)parts, (int)1);
        } else {
            thread2 = NoThreadInfoInProfilerData.INSTANCE;
            frames = parts;
        }
        Iterable iterable = frames;
        ThreadInfo threadInfo = thread2;
        DummyCallTreeBuilder<FrameItem> dummyCallTreeBuilder = this.dataBuilder;
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.cachedFrames.computeIfAbsent((String)it, arg_0 -> CollapsedDumpParser.consumeLine$lambda$1$lambda$0(this.frameItemMapper, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
            collection.add(object);
        }
        collection = (List)destination$iv$iv;
        dummyCallTreeBuilder.addStack(threadInfo, (List<FrameItem>)collection, count);
    }

    private static final Object consumeLine$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }
}

