/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public abstract class PairedBraceAndAnglesMatcher
extends PairedBraceMatcherAdapter {
    private final TokenSet myTokenSetAllowedInsideAngleBrackets;
    private final ParentAwareTokenSet myBasicTokenSetAllowedInsideAngleBrackets;
    private final LanguageFileType myFileType;

    public PairedBraceAndAnglesMatcher(@NotNull PairedBraceMatcher matcher, @NotNull Language language, @NotNull LanguageFileType fileType, @NotNull TokenSet tokenSetAllowedInsideAngleBrackets) {
        if (matcher == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(0);
        }
        if (language == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(1);
        }
        if (fileType == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(2);
        }
        if (tokenSetAllowedInsideAngleBrackets == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(3);
        }
        super(matcher, language);
        this.myTokenSetAllowedInsideAngleBrackets = tokenSetAllowedInsideAngleBrackets;
        this.myBasicTokenSetAllowedInsideAngleBrackets = null;
        this.myFileType = fileType;
    }

    public PairedBraceAndAnglesMatcher(@NotNull PairedBraceMatcher matcher, @NotNull Language language, @NotNull LanguageFileType fileType, @NotNull ParentAwareTokenSet basicTokenSetAllowedInsideAngleBrackets) {
        if (matcher == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(4);
        }
        if (language == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(6);
        }
        if (basicTokenSetAllowedInsideAngleBrackets == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(7);
        }
        super(matcher, language);
        this.myTokenSetAllowedInsideAngleBrackets = null;
        this.myBasicTokenSetAllowedInsideAngleBrackets = basicTokenSetAllowedInsideAngleBrackets;
        this.myFileType = fileType;
    }

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(8);
        }
        if (fileText == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(9);
        }
        if (fileType == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(10);
        }
        return this.isBrace(iterator, fileText, fileType, true);
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(11);
        }
        if (fileText == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            PairedBraceAndAnglesMatcher.$$$reportNull$$$0(13);
        }
        return this.isBrace(iterator, fileText, fileType, false);
    }

    @NotNull
    public abstract IElementType lt();

    @NotNull
    public abstract IElementType gt();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBrace(HighlighterIterator iterator, CharSequence fileText, FileType fileType, boolean left) {
        IElementType opposite;
        BracePair pair = this.findPair(left, iterator, fileText, fileType);
        if (pair == null) {
            return false;
        }
        if ((left ? pair.getRightBraceType() : pair.getLeftBraceType()) != (opposite = left ? this.gt() : this.lt())) {
            return true;
        }
        if (fileType != this.myFileType) {
            return false;
        }
        IElementType braceElementType = left ? this.lt() : this.gt();
        int count = 0;
        try {
            int paired = 1;
            while (true) {
                ++count;
                if (left) {
                    iterator.advance();
                } else {
                    iterator.retreat();
                }
                if (iterator.atEnd()) break;
                IElementType tokenType = iterator.getTokenType();
                if (tokenType == opposite) {
                    if (--paired != 0) continue;
                    boolean bl = true;
                    return bl;
                }
                if (tokenType == braceElementType) {
                    ++paired;
                    continue;
                }
                if (this.myTokenSetAllowedInsideAngleBrackets != null && this.myTokenSetAllowedInsideAngleBrackets.contains(tokenType) || this.myBasicTokenSetAllowedInsideAngleBrackets != null && this.myBasicTokenSetAllowedInsideAngleBrackets.contains(tokenType)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            while (count-- > 0) {
                if (left) {
                    iterator.retreat();
                    continue;
                }
                iterator.advance();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSetAllowedInsideAngleBrackets";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basicTokenSetAllowedInsideAngleBrackets";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/PairedBraceAndAnglesMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isLBraceToken";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isRBraceToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

