/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDefaultArgumentsInExpectWithActualTypealiasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getMembersWithDefaultValueParametersUnlessAnnotation", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDefaultArgumentsInExpectWithActualTypealiasChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDefaultArgumentsInExpectWithActualTypealiasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDefaultArgumentsInExpectWithActualTypealiasChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n36#2:75\n1#3:76\n1#3:92\n857#4:77\n1747#4,3:78\n858#4:81\n1603#4,9:82\n1855#4:91\n1856#4:93\n1612#4:94\n*S KotlinDebug\n*F\n+ 1 FirDefaultArgumentsInExpectWithActualTypealiasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDefaultArgumentsInExpectWithActualTypealiasChecker\n*L\n30#1:75\n64#1:92\n61#1:77\n61#1:78,3\n61#1:81\n64#1:82,9\n64#1:91\n64#1:93\n64#1:94\n*E\n"})
public final class FirDefaultArgumentsInExpectWithActualTypealiasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirDefaultArgumentsInExpectWithActualTypealiasChecker INSTANCE = new FirDefaultArgumentsInExpectWithActualTypealiasChecker();

    private FirDefaultArgumentsInExpectWithActualTypealiasChecker() {
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects) || !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        FirMemberDeclaration $this$isActual$iv = declaration2;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        FirTypeAliasSymbol actualTypealiasSymbol = declaration2.getSymbol();
        FirBasedSymbol<?> firBasedSymbol = ExpectActualAttributesKt.getSingleExpectForActualOrNull(actualTypealiasSymbol);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> expectedSingleCandidate = firBasedSymbol;
        FirRegularClassSymbol expectClassSymbol = (FirRegularClassSymbol)expectedSingleCandidate;
        List<FirFunctionSymbol<?>> membersWithDefaultValueParameters = this.getMembersWithDefaultValueParametersUnlessAnnotation(expectClassSymbol);
        if (membersWithDefaultValueParameters.isEmpty()) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration2.getSource()), FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_WITH_ACTUAL_TYPEALIAS(), (Object)expectClassSymbol, membersWithDefaultValueParameters, (DiagnosticContext)context2, null, (int)32, null);
    }

    private final List<FirFunctionSymbol<?>> getMembersWithDefaultValueParametersUnlessAnnotation(FirClassSymbol<?> classSymbol2) {
        List result2 = new ArrayList();
        FirDefaultArgumentsInExpectWithActualTypealiasChecker.getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(result2, classSymbol2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(List<FirFunctionSymbol<?>> result2, FirClassSymbol<?> classSymbol2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object element$iv2;
        FirContainingNamesAwareScope memberScope2;
        if (classSymbol2.getClassKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirContainingNamesAwareScope $this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u240 = memberScope2 = FirDeclaredMemberScopeProviderKt.declaredMemberScope(classSymbol2, classSymbol2.getModuleData().getSession(), null);
        boolean bl = false;
        List functionsAndConstructors = CollectionsKt.plus(FirContainingNamesAwareScopeKt.collectAllFunctions($this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u240), (Iterable)FirScopeKt.getDeclaredConstructors($this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u240));
        Iterable $this$filterTo$iv = functionsAndConstructors;
        boolean $i$f$filterTo22 = false;
        for (Object element$iv2 : $this$filterTo$iv) {
            boolean bl2;
            block7: {
                FirFunctionSymbol it = (FirFunctionSymbol)element$iv2;
                boolean bl3 = false;
                Iterable $this$any$iv = it.getValueParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv3 : $this$any$iv) {
                        FirValueParameterSymbol p0 = (FirValueParameterSymbol)element$iv3;
                        boolean bl4 = false;
                        if (!p0.getHasDefaultValue()) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            ((Collection)result2).add(element$iv2);
        }
        Iterable $i$f$filterTo22 = memberScope2.getClassifierNames();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirClassSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            Name it = (Name)element$iv$iv;
            boolean bl6 = false;
            FirClassifierSymbol<?> firClassifierSymbol = FirScopeKt.getSingleClassifier(memberScope2, it);
            if ((firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nestedClasses = (List)destination$iv$iv;
        for (FirClassSymbol nestedClassSymbol : nestedClasses) {
            FirDefaultArgumentsInExpectWithActualTypealiasChecker.getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(result2, nestedClassSymbol);
        }
    }
}

