/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0014\u001a\u00020\u0013*\u00020\u000fH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorsTypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAccessorForDelegatedProperty", "property", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "checkGetter", "checkSetter", "isLegallyAbstract", "", "isImplicitDelegateAccessor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyAccessorsTypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyAccessorsTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorsTypesChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,134:1\n21#2:135\n21#2:136\n21#2:137\n12#2:138\n65#2:140\n62#2:141\n60#2:142\n1#3:139\n37#4:143\n*S KotlinDebug\n*F\n+ 1 FirPropertyAccessorsTypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorsTypesChecker\n*L\n41#1:135\n75#1:136\n81#1:137\n131#1:138\n131#1:140\n131#1:141\n131#1:142\n131#1:143\n*E\n"})
public final class FirPropertyAccessorsTypesChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyAccessorsTypesChecker INSTANCE = new FirPropertyAccessorsTypesChecker();

    private FirPropertyAccessorsTypesChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkGetter(declaration2, context2, reporter);
        this.checkSetter(declaration2, context2, reporter);
    }

    private final void checkGetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor getter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        this.checkAccessorForDelegatedProperty(property2, getter2, context2, reporter);
        if (this.isImplicitDelegateAccessor(getter2)) {
            return;
        }
        FirMemberDeclaration $this$visibility$iv = getter2;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = property2;
        $i$f$getVisibility = false;
        if (!Intrinsics.areEqual((Object)visibility2, (Object)$this$visibility$iv.getStatus().getVisibility())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)getter2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (property2.getSymbol().getCallableId().getClassId() != null && getter2.getBody() != null && property2.getDelegate() == null && this.isLegallyAbstract(property2, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)getter2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_GETTER(), (DiagnosticContext)context2, null, (int)8, null);
        }
        FirTypeRef getterReturnTypeRef = getter2.getReturnTypeRef();
        KtSourceElement ktSourceElement = getterReturnTypeRef.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        ConeKotlinType getterReturnType = FirTypeUtilsKt.getConeType(getterReturnTypeRef);
        if (propertyType instanceof ConeErrorType || getterReturnType instanceof ConeErrorType) {
            return;
        }
        if (!Intrinsics.areEqual((Object)getterReturnType, (Object)FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()))) {
            KtSourceElement getterReturnTypeSource = getterReturnTypeRef.getSource();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)getterReturnTypeSource), FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), (Object)propertyType, (Object)getterReturnType, (DiagnosticContext)context2, null, (int)32, null);
        }
    }

    private final void checkSetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        ConeKotlinType setterReturnType;
        FirValueParameter valueSetterParameter;
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor setter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        if (property2.isVal()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)setter2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVAL_WITH_SETTER(), (DiagnosticContext)context2, null, (int)8, null);
        }
        this.checkAccessorForDelegatedProperty(property2, setter2, context2, reporter);
        if (this.isImplicitDelegateAccessor(setter2)) {
            return;
        }
        FirMemberDeclaration $this$visibility$iv = setter2;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = property2;
        $i$f$getVisibility = false;
        Integer visibilityCompareResult = visibility2.compareTo($this$visibility$iv.getStatus().getVisibility());
        if (visibilityCompareResult == null || visibilityCompareResult > 0) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)setter2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY(), (DiagnosticContext)context2, null, (int)8, null);
        }
        if (property2.getSymbol().getCallableId().getClassId() != null && property2.getDelegate() == null) {
            boolean isLegallyAbstract = this.isLegallyAbstract(property2, context2);
            FirMemberDeclaration $this$visibility$iv2 = setter2;
            boolean $i$f$getVisibility2 = false;
            if (Intrinsics.areEqual((Object)$this$visibility$iv2.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                $this$visibility$iv2 = property2;
                $i$f$getVisibility2 = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv2.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                    if (isLegallyAbstract) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)setter2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_ABSTRACT_PROPERTY(), (DiagnosticContext)context2, null, (int)8, null);
                    } else if (!DeclarationUtilsKt.isEffectivelyFinal(property2, context2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)setter2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_OPEN_PROPERTY(), (DiagnosticContext)context2, null, (int)8, null);
                    }
                }
            }
            if (isLegallyAbstract && setter2.getBody() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)setter2.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_SETTER(), (DiagnosticContext)context2, null, (int)8, null);
            }
        }
        if ((valueSetterParameter = (FirValueParameter)CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
            return;
        }
        ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
        KtSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
        if (propertyType instanceof ConeErrorType || valueSetterType instanceof ConeErrorType) {
            return;
        }
        if (!Intrinsics.areEqual((Object)valueSetterType, (Object)propertyType) && !ConeTypeUtilsKt.hasError(valueSetterType)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)valueSetterTypeSource), FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), (Object)propertyType, (Object)valueSetterType, (DiagnosticContext)context2, null, (int)32, null);
        }
        if (!ConeBuiltinTypeUtilsKt.isUnit(setterReturnType = FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef()))) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)setter2.getReturnTypeRef().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), (DiagnosticContext)context2, null, (int)8, null);
        }
    }

    private final void checkAccessorForDelegatedProperty(FirProperty property2, FirPropertyAccessor accessor, CheckerContext context2, DiagnosticReporter reporter) {
        if (property2.getDelegateFieldSymbol() != null && accessor.getBody() != null) {
            KtSourceElement ktSourceElement = accessor.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)accessor.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getACCESSOR_FOR_DELEGATED_PROPERTY(), (DiagnosticContext)context2, null, (int)8, null);
            }
        }
    }

    private final boolean isImplicitDelegateAccessor(FirPropertyAccessor $this$isImplicitDelegateAccessor) {
        KtSourceElement ktSourceElement = $this$isImplicitDelegateAccessor.getSource();
        return Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLegallyAbstract(FirProperty property2, CheckerContext context2) {
        FirMemberDeclaration $this$isAbstract$iv = property2;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() != Modality.ABSTRACT) return false;
        boolean bl = true;
        if (!bl) return false;
        FirClass it = FirHelpersKt.findClosestClassOrObject(context2);
        boolean bl2 = false;
        if (!(it instanceof FirRegularClass)) return false;
        FirRegularClass $this$canHaveAbstractDeclaration$iv = (FirRegularClass)it;
        boolean $i$f$getCanHaveAbstractDeclaration = false;
        FirMemberDeclaration $this$isAbstract$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isAbstract2 = false;
        if ($this$isAbstract$iv$iv.getStatus().getModality() == Modality.ABSTRACT) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        FirRegularClass $this$isSealed$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isSealed = false;
        if ($this$isSealed$iv$iv.getStatus().getModality() == Modality.SEALED) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        FirClass $this$isEnumClass$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv$iv = $this$isEnumClass$iv$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if ($this$isEnumClass$iv$iv$iv != ClassKind.ENUM_CLASS) return false;
        return true;
    }
}

