/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.contracts;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtBooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.KtBooleanExpression;
import org.jetbrains.kotlin.contracts.description.KtBooleanValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConstantReference;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtValueParameterReference;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractConstantValues;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeContractDescriptionError;
import org.jetbrains.kotlin.fir.resolve.transformers.contracts.FirContractsDslNames;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 M2 \u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0001:\u0001MB#\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0015j\u0002`\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J6\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010%\u001a\u00020&2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010(\u001a\u00020)2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010+\u001a\u00020,2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010.\u001a\u00020/2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u00101\u001a\u0002022\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u00104\u001a\u0002052\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u00106\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u00107\u001a\u0002082\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u00109\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010:\u001a\u00020;2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J*\u0010<\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u00052\u0006\u0010=\u001a\u00020>2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040@j\u0002`A*\u00020BH\u0002J\u001c\u0010C\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002j\u0002`\u0005*\u00020&H\u0002J\u001c\u0010D\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0015j\u0002`\u0016*\u00020BH\u0002J\u0018\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0010*\u00020FH\u0002J\u0014\u0010G\u001a\u00020H*\u00020\n2\u0006\u0010I\u001a\u00020JH\u0002J\u000e\u0010K\u001a\u0004\u0018\u00010L*\u00020BH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;", "valueParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirContractDescriptionOwner;Ljava/util/List;)V", "noArgument", "Lorg/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "noReceiver", "toValueParameterReference", "Lorg/jetbrains/kotlin/contracts/description/KtValueParameterReference;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeValueParameterReference;", "type", "index", "", "name", "", "visitBinaryLogicExpression", "binaryLogicExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "data", "visitConstExpression", "T", "constExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirConstExpression;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEqualityOperatorCall", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "visitFunctionCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "visitPropertyAccessExpression", "propertyAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "visitReturnExpression", "returnExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "visitSmartCastExpression", "smartCastExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "visitThisReceiverExpression", "thisReceiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirThisReceiverExpression;", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "asContractBooleanExpression", "Lorg/jetbrains/kotlin/contracts/description/KtBooleanExpression;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeBooleanExpression;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "asContractElement", "asContractValueExpression", "asElement", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeContractDescriptionError;", "isAccessorOf", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "parseInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nConeEffectExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeEffectExtractor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,272:1\n46#2:273\n44#2:274\n44#2:275\n44#2:276\n44#2:277\n44#2:278\n44#2:279\n46#2:281\n1#3:280\n2624#4,3:282\n226#5:285\n*S KotlinDebug\n*F\n+ 1 ConeEffectExtractor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor\n*L\n61#1:273\n66#1:274\n84#1:275\n85#1:276\n96#1:277\n130#1:278\n134#1:279\n216#1:281\n221#1:282,3\n224#1:285\n*E\n"})
public final class ConeEffectExtractor
extends FirDefaultVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirContractDescriptionOwner owner;
    @NotNull
    private final List<FirValueParameter> valueParameters;
    @NotNull
    private static final CallableId BOOLEAN_AND = FirContractsDslNames.INSTANCE.id$resolve("kotlin", "Boolean", "and");
    @NotNull
    private static final CallableId BOOLEAN_OR = FirContractsDslNames.INSTANCE.id$resolve("kotlin", "Boolean", "or");
    @NotNull
    private static final CallableId BOOLEAN_NOT = FirContractsDslNames.INSTANCE.id$resolve("kotlin", "Boolean", "not");

    public ConeEffectExtractor(@NotNull FirSession session2, @NotNull FirContractDescriptionOwner owner, @NotNull List<? extends FirValueParameter> valueParameters2) {
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter(valueParameters2, (String)"valueParameters");
        this.session = session2;
        this.owner = owner;
        this.valueParameters = valueParameters2;
    }

    private final KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> asElement(ConeContractDescriptionError $this$asElement) {
        return new KtErroneousContractElement((Object)$this$asElement);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitElement(@NotNull FirElement element3, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.IllegalElement(element3));
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitReturnExpression(@NotNull FirReturnExpression returnExpression, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
        return (KtContractDescriptionElement)returnExpression.getResult().accept(this, data2);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitFunctionCall(@NotNull FirFunctionCall functionCall, @Nullable Void data2) {
        KtContractDescriptionElement ktContractDescriptionElement;
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        CallableId callableId = FirExpressionUtilKt.toResolvedCallableSymbol(functionCall);
        if (callableId == null || (callableId = callableId.getCallableId()) == null) {
            return (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.UnresolvedCall(functionCall.getCalleeReference().getName()));
        }
        CallableId resolvedId = callableId;
        CallableId callableId2 = resolvedId;
        if (Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getIMPLIES())) {
            FirExpression firExpression2 = functionCall.getExplicitReceiver();
            KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> ktContractDescriptionElement2 = firExpression2 != null ? this.asContractElement(firExpression2) : null;
            KtEffectDeclaration ktEffectDeclaration = ktContractDescriptionElement2 instanceof KtEffectDeclaration ? (KtEffectDeclaration)ktContractDescriptionElement2 : null;
            if (ktEffectDeclaration == null) {
                ktEffectDeclaration = (KtEffectDeclaration)this.noReceiver(resolvedId);
            }
            KtEffectDeclaration effect = ktEffectDeclaration;
            FirCall $this$argument$iv = functionCall;
            boolean $i$f$getArgument = false;
            KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> ktContractDescriptionElement3 = this.asContractElement((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
            KtBooleanExpression ktBooleanExpression = ktContractDescriptionElement3 instanceof KtBooleanExpression ? (KtBooleanExpression)ktContractDescriptionElement3 : null;
            if (ktBooleanExpression == null) {
                ktBooleanExpression = (KtBooleanExpression)this.noArgument(resolvedId);
            }
            KtBooleanExpression condition2 = ktBooleanExpression;
            ktContractDescriptionElement = (KtContractDescriptionElement)new KtConditionalEffectDeclaration(effect, condition2);
        } else if (Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getRETURNS())) {
            KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> value2;
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            FirExpression argument2 = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
            KtConstantReference value3 = argument2 == null ? ConeContractConstantValues.INSTANCE.getWILDCARD() : ((value2 = this.asContractElement(argument2)) instanceof KtConstantReference ? (KtConstantReference)value2 : (KtConstantReference)new KtErroneousConstantReference((Object)new ConeContractDescriptionError.NotAConstant(value2)));
            Intrinsics.checkNotNull(value3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.contracts.description.KtConstantReference<org.jetbrains.kotlin.fir.types.ConeKotlinType, org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic>{ org.jetbrains.kotlin.fir.contracts.description.ConeValuesKt.ConeConstantReference }");
            ktContractDescriptionElement = (KtContractDescriptionElement)new KtReturnsEffectDeclaration(value3);
        } else if (Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getRETURNS_NOT_NULL())) {
            ktContractDescriptionElement = (KtContractDescriptionElement)new KtReturnsEffectDeclaration(ConeContractConstantValues.INSTANCE.getNOT_NULL());
        } else if (Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getCALLS_IN_PLACE())) {
            KtCallsEffectDeclaration ktCallsEffectDeclaration;
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            KtValueParameterReference<ConeKotlinType, ConeDiagnostic> reference2 = this.asContractValueExpression($this$arguments$iv.getArgumentList().getArguments().get(0));
            FirCall $this$arguments$iv2 = functionCall;
            boolean $i$f$getArguments2 = false;
            FirExpression argument3 = (FirExpression)CollectionsKt.getOrNull($this$arguments$iv2.getArgumentList().getArguments(), (int)1);
            if (argument3 == null) {
                ktCallsEffectDeclaration = new KtCallsEffectDeclaration(reference2, EventOccurrencesRange.UNKNOWN);
            } else {
                EventOccurrencesRange kind2;
                EventOccurrencesRange eventOccurrencesRange = kind2 = this.parseInvocationKind(argument3);
                ktCallsEffectDeclaration = (eventOccurrencesRange == null ? -1 : WhenMappings.$EnumSwitchMapping$0[eventOccurrencesRange.ordinal()]) == -1 ? (KtCallsEffectDeclaration)new KtErroneousCallsEffectDeclaration(reference2, (Object)new ConeContractDescriptionError.UnresolvedInvocationKind(argument3)) : new KtCallsEffectDeclaration(reference2, kind2);
            }
            ktContractDescriptionElement = (KtContractDescriptionElement)ktCallsEffectDeclaration;
        } else if (Intrinsics.areEqual((Object)callableId2, (Object)BOOLEAN_AND) ? true : Intrinsics.areEqual((Object)callableId2, (Object)BOOLEAN_OR)) {
            LogicOperationKind logicOperationKind;
            CallableId callableId3;
            KtBooleanExpression right;
            KtBooleanExpression ktBooleanExpression = functionCall.getExplicitReceiver();
            if (ktBooleanExpression == null || (ktBooleanExpression = this.asContractBooleanExpression((FirExpression)ktBooleanExpression)) == null) {
                ktBooleanExpression = (KtBooleanExpression)this.noReceiver(resolvedId);
            }
            KtBooleanExpression left = ktBooleanExpression;
            FirCall $this$arguments$iv = functionCall;
            boolean $i$f$getArguments = false;
            KtBooleanExpression ktBooleanExpression2 = (KtBooleanExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
            if (ktBooleanExpression2 == null || (ktBooleanExpression2 = this.asContractBooleanExpression((FirExpression)ktBooleanExpression2)) == null) {
                ktBooleanExpression2 = right = (KtBooleanExpression)this.noArgument(resolvedId);
            }
            if (Intrinsics.areEqual((Object)(callableId3 = resolvedId), (Object)BOOLEAN_AND)) {
                logicOperationKind = LogicOperationKind.AND;
            } else if (Intrinsics.areEqual((Object)callableId3, (Object)BOOLEAN_OR)) {
                logicOperationKind = LogicOperationKind.OR;
            } else {
                AddToStdlibKt.shouldNotBeCalled$default(null, (int)1, null);
                throw null;
            }
            LogicOperationKind kind3 = logicOperationKind;
            ktContractDescriptionElement = (KtContractDescriptionElement)new KtBinaryLogicExpression(left, right, kind3);
        } else if (Intrinsics.areEqual((Object)callableId2, (Object)BOOLEAN_NOT)) {
            KtBooleanExpression ktBooleanExpression = functionCall.getExplicitReceiver();
            if (ktBooleanExpression == null || (ktBooleanExpression = this.asContractBooleanExpression((FirExpression)ktBooleanExpression)) == null) {
                ktBooleanExpression = (KtBooleanExpression)this.noReceiver(resolvedId);
            }
            KtBooleanExpression arg = ktBooleanExpression;
            ktContractDescriptionElement = (KtContractDescriptionElement)new KtLogicalNot(arg);
        } else {
            ktContractDescriptionElement = (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.NotContractDsl(resolvedId));
        }
        return ktContractDescriptionElement;
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitBinaryLogicExpression(@NotNull FirBinaryLogicExpression binaryLogicExpression, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
        KtBooleanExpression<ConeKotlinType, ConeDiagnostic> left = this.asContractBooleanExpression(binaryLogicExpression.getLeftOperand());
        KtBooleanExpression<ConeKotlinType, ConeDiagnostic> right = this.asContractBooleanExpression(binaryLogicExpression.getRightOperand());
        return (KtContractDescriptionElement)new KtBinaryLogicExpression(left, right, binaryLogicExpression.getKind());
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @Nullable Void data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
        FirOperation operation2 = equalityOperatorCall.getOperation();
        switch (WhenMappings.$EnumSwitchMapping$1[operation2.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                return (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.IllegalEqualityOperator(operation2));
            }
        }
        boolean isNegated = bl;
        FirCall $this$arguments$iv = equalityOperatorCall;
        boolean $i$f$getArguments = false;
        FirExpression argument2 = $this$arguments$iv.getArgumentList().getArguments().get(1);
        FirConstExpression firConstExpression = argument2 instanceof FirConstExpression ? (FirConstExpression)argument2 : null;
        if (firConstExpression == null) {
            return (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.NotAConstant(argument2));
        }
        FirConstExpression firConstExpression2 = firConstExpression;
        if (!Intrinsics.areEqual(firConstExpression2.getKind(), (Object)ConstantValueKind.Null.INSTANCE)) {
            return (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.IllegalConst(firConstExpression2, true));
        }
        FirCall $this$arguments$iv2 = equalityOperatorCall;
        boolean $i$f$getArguments2 = false;
        KtValueParameterReference<ConeKotlinType, ConeDiagnostic> arg = this.asContractValueExpression($this$arguments$iv2.getArgumentList().getArguments().get(0));
        return (KtContractDescriptionElement)new KtIsNullPredicate(arg, isNegated);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitSmartCastExpression(@NotNull FirSmartCastExpression smartCastExpression, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)smartCastExpression, (String)"smartCastExpression");
        return (KtContractDescriptionElement)smartCastExpression.getOriginalExpression().accept(this, data2);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        if (firCallableSymbol == null) {
            ConeEffectExtractor $this$visitQualifiedAccessExpression_u24lambda_u240 = this;
            boolean bl = false;
            FirReference firReference = qualifiedAccessExpression.getCalleeReference();
            FirNamedReference firNamedReference = firReference instanceof FirNamedReference ? (FirNamedReference)firReference : null;
            if (firNamedReference == null || (firNamedReference = firNamedReference.getName()) == null) {
                Name name2 = Name.special((String)"unresolved");
                firNamedReference = name2;
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
            }
            FirNamedReference name3 = firNamedReference;
            return (KtContractDescriptionElement)$this$visitQualifiedAccessExpression_u24lambda_u240.asElement(new ConeContractDescriptionError.UnresolvedCall((Name)name3));
        }
        FirCallableSymbol<?> symbol2 = firCallableSymbol;
        Object $this$visitQualifiedAccessExpression_u24lambda_u240 = symbol2.getFir();
        FirValueParameter firValueParameter = $this$visitQualifiedAccessExpression_u24lambda_u240 instanceof FirValueParameter ? (FirValueParameter)$this$visitQualifiedAccessExpression_u24lambda_u240 : null;
        if (firValueParameter == null) {
            return (KtContractDescriptionElement)new KtErroneousValueParameterReference((Object)new ConeContractDescriptionError.IllegalParameter(symbol2, symbol2 + " is not a value parameter"));
        }
        FirValueParameter parameter2 = firValueParameter;
        Integer bl = this.valueParameters.indexOf(parameter2);
        int it = ((Number)bl).intValue();
        boolean bl2 = false;
        Integer n = !(it < 0) ? bl : null;
        if (n == null) {
            return (KtContractDescriptionElement)new KtErroneousValueParameterReference((Object)new ConeContractDescriptionError.IllegalParameter(symbol2, "Value paramter " + symbol2 + " is not found in parameters of outer function"));
        }
        int index = n;
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
        String string = parameter2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String name4 = string;
        return (KtContractDescriptionElement)this.toValueParameterReference(type2, index, name4);
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter((Object)propertyAccessExpression, (String)"propertyAccessExpression");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    private final KtValueParameterReference<ConeKotlinType, ConeDiagnostic> toValueParameterReference(ConeKotlinType type2, int index, String name2) {
        return Intrinsics.areEqual((Object)type2, (Object)this.session.getBuiltinTypes().getBooleanType().getType()) ? (KtValueParameterReference)new KtBooleanValueParameterReference(index, name2) : new KtValueParameterReference(index, name2);
    }

    private final boolean isAccessorOf(FirContractDescriptionOwner $this$isAccessorOf, FirDeclaration declaration2) {
        return declaration2 instanceof FirProperty && (Intrinsics.areEqual((Object)((FirProperty)declaration2).getGetter(), (Object)$this$isAccessorOf) || Intrinsics.areEqual((Object)((FirProperty)declaration2).getSetter(), (Object)$this$isAccessorOf));
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitThisReceiverExpression(@NotNull FirThisReceiverExpression thisReceiverExpression, @Nullable Void data2) {
        KtContractDescriptionElement ktContractDescriptionElement;
        FirCallableDeclaration callableOwner;
        Intrinsics.checkNotNullParameter((Object)thisReceiverExpression, (String)"thisReceiverExpression");
        FirBasedSymbol<?> firBasedSymbol = thisReceiverExpression.getCalleeReference().getBoundSymbol();
        if (firBasedSymbol == null || (firBasedSymbol = firBasedSymbol.getFir()) == null) {
            return (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.UnresolvedThis(thisReceiverExpression));
        }
        FirBasedSymbol<?> declaration2 = firBasedSymbol;
        FirContractDescriptionOwner firContractDescriptionOwner = this.owner;
        FirCallableDeclaration firCallableDeclaration = callableOwner = firContractDescriptionOwner instanceof FirCallableDeclaration ? (FirCallableDeclaration)((Object)firContractDescriptionOwner) : null;
        boolean ownerHasReceiver = (firCallableDeclaration != null ? firCallableDeclaration.getReceiverParameter() : null) != null;
        FirCallableDeclaration firCallableDeclaration2 = callableOwner;
        boolean ownerIsMemberOfDeclaration = Intrinsics.areEqual((Object)(firCallableDeclaration2 != null ? ResolveUtilsKt.getContainingClass(firCallableDeclaration2, this.session) : null), declaration2);
        if (Intrinsics.areEqual(declaration2, (Object)this.owner) || this.isAccessorOf(this.owner, (FirDeclaration)((Object)declaration2)) || ownerIsMemberOfDeclaration && !ownerHasReceiver) {
            ConeKotlinType type2 = FirTypeUtilsKt.getResolvedType(thisReceiverExpression);
            ktContractDescriptionElement = (KtContractDescriptionElement)this.toValueParameterReference(type2, -1, "this");
        } else {
            ktContractDescriptionElement = (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.IllegalThis(thisReceiverExpression));
        }
        return ktContractDescriptionElement;
    }

    @Override
    @NotNull
    public <T> KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitConstExpression(@NotNull FirConstExpression<T> constExpression, @Nullable Void data2) {
        KtContractDescriptionElement ktContractDescriptionElement;
        Intrinsics.checkNotNullParameter(constExpression, (String)"constExpression");
        ConstantValueKind<T> constantValueKind = constExpression.getKind();
        if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
            ktContractDescriptionElement = (KtContractDescriptionElement)ConeContractConstantValues.INSTANCE.getNULL();
        } else if (Intrinsics.areEqual(constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            KtBooleanConstantReference<ConeKotlinType, ConeDiagnostic> ktBooleanConstantReference;
            T t = constExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean bl = (Boolean)t;
            if (bl) {
                ktBooleanConstantReference = ConeContractConstantValues.INSTANCE.getTRUE();
            } else if (!bl) {
                ktBooleanConstantReference = ConeContractConstantValues.INSTANCE.getFALSE();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ktContractDescriptionElement = (KtContractDescriptionElement)ktBooleanConstantReference;
        } else {
            ktContractDescriptionElement = (KtContractDescriptionElement)this.asElement(new ConeContractDescriptionError.IllegalConst(constExpression, false));
        }
        return ktContractDescriptionElement;
    }

    @Override
    @NotNull
    public KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @Nullable Void data2) {
        ConeContractDescriptionError coneContractDescriptionError;
        Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
        FirCall $this$argument$iv = typeOperatorCall;
        boolean $i$f$getArgument = false;
        KtValueParameterReference<ConeKotlinType, ConeDiagnostic> arg = this.asContractValueExpression((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()));
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(typeOperatorCall.getConversionTypeRef()), this.session);
        boolean isNegated = typeOperatorCall.getOperation() == FirOperation.NOT_IS;
        FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(type2, this.session);
        FirTypeParameterSymbol firTypeParameterSymbol = firClassifierSymbol instanceof FirTypeParameterSymbol ? (FirTypeParameterSymbol)firClassifierSymbol : null;
        if (firTypeParameterSymbol != null) {
            boolean bl;
            FirTypeParameterSymbol typeParameterSymbol;
            block10: {
                typeParameterSymbol = firTypeParameterSymbol;
                boolean bl2 = false;
                FirContractDescriptionOwner firContractDescriptionOwner = this.owner;
                FirTypeParameterRefsOwner firTypeParameterRefsOwner = firContractDescriptionOwner instanceof FirTypeParameterRefsOwner ? (FirTypeParameterRefsOwner)((Object)firContractDescriptionOwner) : null;
                List list2 = firTypeParameterRefsOwner != null ? firTypeParameterRefsOwner.getTypeParameters() : null;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List typeParametersOfOwner = list2;
                Iterable $this$none$iv = typeParametersOfOwner;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof FirTypeParameter && Intrinsics.areEqual((Object)it.getSymbol(), (Object)typeParameterSymbol))) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                coneContractDescriptionError = new ConeContractDescriptionError.NotSelfTypeParameter(typeParameterSymbol);
            } else {
                ConeContractDescriptionError.NotReifiedTypeParameter notReifiedTypeParameter;
                boolean condition$iv = !typeParameterSymbol.isReified();
                boolean $i$f$runIf = false;
                if (condition$iv) {
                    boolean bl4 = false;
                    notReifiedTypeParameter = new ConeContractDescriptionError.NotReifiedTypeParameter(typeParameterSymbol);
                } else {
                    notReifiedTypeParameter = null;
                }
                coneContractDescriptionError = notReifiedTypeParameter;
            }
        } else {
            coneContractDescriptionError = null;
        }
        ConeContractDescriptionError diagnostic = coneContractDescriptionError;
        return diagnostic == null ? (KtContractDescriptionElement)new KtIsInstancePredicate(arg, (Object)type2, isNegated) : (KtContractDescriptionElement)new KtErroneousIsInstancePredicate(arg, (Object)type2, isNegated, diagnostic);
    }

    private final EventOccurrencesRange parseInvocationKind(FirExpression $this$parseInvocationKind) {
        if (!($this$parseInvocationKind instanceof FirQualifiedAccessExpression)) {
            return null;
        }
        CallableId callableId = FirExpressionUtilKt.toResolvedCallableSymbol($this$parseInvocationKind);
        if (callableId == null || (callableId = callableId.getCallableId()) == null) {
            return null;
        }
        CallableId resolvedId = callableId;
        CallableId callableId2 = resolvedId;
        return Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getEXACTLY_ONCE_KIND()) ? EventOccurrencesRange.EXACTLY_ONCE : (Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getAT_LEAST_ONCE_KIND()) ? EventOccurrencesRange.AT_LEAST_ONCE : (Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getAT_MOST_ONCE_KIND()) ? EventOccurrencesRange.AT_MOST_ONCE : (Intrinsics.areEqual((Object)callableId2, (Object)FirContractsDslNames.INSTANCE.getUNKNOWN_KIND()) ? EventOccurrencesRange.UNKNOWN : null)));
    }

    private final KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> noReceiver(CallableId callableId) {
        return this.asElement(new ConeContractDescriptionError.NoReceiver(callableId.getCallableName()));
    }

    private final KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> noArgument(CallableId callableId) {
        return this.asElement(new ConeContractDescriptionError.NoArgument(callableId.getCallableName()));
    }

    private final KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> asContractElement(FirElement $this$asContractElement) {
        return (KtContractDescriptionElement)$this$asContractElement.accept(this, null);
    }

    private final KtBooleanExpression<ConeKotlinType, ConeDiagnostic> asContractBooleanExpression(FirExpression $this$asContractBooleanExpression) {
        KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> element3 = this.asContractElement($this$asContractBooleanExpression);
        return element3 instanceof KtBooleanExpression ? (KtBooleanExpression)element3 : (KtBooleanExpression)this.asElement(new ConeContractDescriptionError.NotABooleanExpression(element3));
    }

    private final KtValueParameterReference<ConeKotlinType, ConeDiagnostic> asContractValueExpression(FirExpression $this$asContractValueExpression) {
        KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> element3 = this.asContractElement($this$asContractValueExpression);
        return element3 instanceof KtValueParameterReference ? (KtValueParameterReference)element3 : (KtValueParameterReference)new KtErroneousValueParameterReference((Object)new ConeContractDescriptionError.NotAParameterReference(element3));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/contracts/ConeEffectExtractor$Companion;", "", "()V", "BOOLEAN_AND", "Lorg/jetbrains/kotlin/name/CallableId;", "BOOLEAN_NOT", "BOOLEAN_OR", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            $EnumSwitchMapping$0 = new int[EventOccurrencesRange.values().length];
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.EQ.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_EQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

