/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.fir.analysisApiProviders;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ConcurrentList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.LLFirDeclarationModificationService;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinModuleOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinTopics;
import org.jetbrains.kotlin.idea.base.fir.analysisApiProviders.FirIdeOutOfBlockPsiTreeChangePreprocessorKt;
import org.jetbrains.kotlin.idea.util.ModificationEventUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/base/fir/analysisApiProviders/FirIdeOutOfBlockPsiTreeChangePreprocessor;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "invalidateCachesForInjectedKotlinCode", "", "injectedDocument", "Lcom/intellij/injected/editor/DocumentWindow;", "invalidateCachesInInjectedDocuments", "rootElement", "Lcom/intellij/psi/PsiElement;", "treeChanged", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "containsInjection", "", "kotlin.base.fir.analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nFirIdeOutOfBlockPsiTreeChangePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIdeOutOfBlockPsiTreeChangePreprocessor.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiProviders/FirIdeOutOfBlockPsiTreeChangePreprocessor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,109:1\n60#2,2:110\n12474#3,2:112\n*S KotlinDebug\n*F\n+ 1 FirIdeOutOfBlockPsiTreeChangePreprocessor.kt\norg/jetbrains/kotlin/idea/base/fir/analysisApiProviders/FirIdeOutOfBlockPsiTreeChangePreprocessor\n*L\n70#1:110,2\n84#1:112,2\n*E\n"})
public final class FirIdeOutOfBlockPsiTreeChangePreprocessor
implements PsiTreeChangePreprocessor {
    @NotNull
    private final Project project;

    public FirIdeOutOfBlockPsiTreeChangePreprocessor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        PsiElement child2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!PsiModificationTrackerImpl.canAffectPsi((PsiTreeChangeEventImpl)event) || event.isGenericChange() || event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_ADDITION) {
            return;
        }
        if (FirIdeOutOfBlockPsiTreeChangePreprocessorKt.access$isGlobalChange(event)) {
            ModificationEventUtilsKt.publishGlobalSourceOutOfBlockModification(this.project);
            return;
        }
        PsiElement rootElement = event.getParent();
        if (rootElement != null) {
            this.invalidateCachesInInjectedDocuments(rootElement);
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType = event.getCode();
        switch (psiEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType.ordinal()]) {
            case 1: {
                PsiElement psiElement2 = rootElement;
                break;
            }
            case 2: {
                PsiElement psiElement2 = event.getOldChild();
                break;
            }
            default: {
                PsiElement psiElement2 = child2 = event.getChild();
            }
        }
        if (rootElement == null || !rootElement.isPhysical()) {
            return;
        }
        LLFirDeclarationModificationService lLFirDeclarationModificationService = LLFirDeclarationModificationService.Companion.getInstance(this.project);
        PsiElement psiElement3 = child2;
        if (psiElement3 == null) {
            psiElement3 = rootElement;
        }
        lLFirDeclarationModificationService.elementModified(psiElement3, event.getCode() == PsiTreeChangeEventImpl.PsiEventType.CHILD_ADDED ? (LLFirDeclarationModificationService.ModificationType)LLFirDeclarationModificationService.ModificationType.NewElement.INSTANCE : (LLFirDeclarationModificationService.ModificationType)LLFirDeclarationModificationService.ModificationType.Unknown.INSTANCE);
    }

    private final void invalidateCachesInInjectedDocuments(PsiElement rootElement) {
        PsiElement $this$parentOfType_u24default$iv = rootElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiLanguageInjectionHost.class, (boolean)true);
        if (psiLanguageInjectionHost == null) {
            return;
        }
        PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
        ConcurrentList concurrentList = InjectedLanguageUtilBase.getCachedInjectedDocuments((PsiFile)rootElement.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"getCachedInjectedDocuments(...)");
        ConcurrentList injectedDocuments = concurrentList;
        if (injectedDocuments.isEmpty()) {
            return;
        }
        for (DocumentWindow injectedDocument : injectedDocuments) {
            Intrinsics.checkNotNull((Object)injectedDocument);
            if (!this.containsInjection(rootElement, injectedDocument)) continue;
            this.invalidateCachesForInjectedKotlinCode(injectedDocument);
        }
    }

    private final boolean containsInjection(PsiElement $this$containsInjection, DocumentWindow injectedDocument) {
        boolean bl;
        block1: {
            Segment[] segmentArray = injectedDocument.getHostRanges();
            Intrinsics.checkNotNullExpressionValue((Object)segmentArray, (String)"getHostRanges(...)");
            Object[] $this$any$iv = segmentArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Segment it = (Segment)element$iv;
                boolean bl2 = false;
                if (!$this$containsInjection.getTextRange().intersects(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final void invalidateCachesForInjectedKotlinCode(DocumentWindow injectedDocument) {
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)this.project).getPsiFile((Document)injectedDocument);
        KtFile ktFile = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
        if (ktFile == null) {
            return;
        }
        KtFile ktFile2 = ktFile;
        KtModule ktModule2 = ProjectStructureProvider.Companion.getInstance(this.project).getModule((PsiElement)ktFile2, null);
        ((KotlinModuleOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus(this.project).syncPublisher(KotlinTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION())).onModification(ktModule2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiTreeChangeEventImpl.PsiEventType.values().length];
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILD_REPLACEMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

