/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\f\u0010\u000b\u001a\u00020\u0007*\u00020\nH\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\f"}, d2={"isLegacyNativeKlibComponent", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "checkKlibComponent", "componentFile", "requestedBuiltInsPlatform", "Lorg/jetbrains/kotlin/library/impl/BuiltInsPlatform;", "isKlibLibraryRootForPlatform", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "toBuiltInsPlatform", "kotlin.base.platforms"})
@JvmName(name="KLibUtils")
@SourceDebugExtension(value={"SMAP\nKLibUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLibUtils.kt\norg/jetbrains/kotlin/idea/base/platforms/KLibUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n12474#2,2:81\n1#3:83\n*S KotlinDebug\n*F\n+ 1 KLibUtils.kt\norg/jetbrains/kotlin/idea/base/platforms/KLibUtils\n*L\n37#1:81,2\n*E\n"})
public final class KLibUtils {
    @ApiStatus.Internal
    public static final boolean isKlibLibraryRootForPlatform(@NotNull VirtualFile $this$isKlibLibraryRootForPlatform, @NotNull TargetPlatform targetPlatform) {
        Intrinsics.checkNotNullParameter((Object)$this$isKlibLibraryRootForPlatform, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        if (Intrinsics.areEqual((Object)$this$isKlibLibraryRootForPlatform.getFileType(), (Object)ArchiveFileType.INSTANCE) && !Intrinsics.areEqual((Object)$this$isKlibLibraryRootForPlatform.getExtension(), (Object)"klib") || !$this$isKlibLibraryRootForPlatform.isDirectory()) {
            return false;
        }
        BuiltInsPlatform requestedBuiltInsPlatform = KLibUtils.toBuiltInsPlatform(targetPlatform);
        if (requestedBuiltInsPlatform == BuiltInsPlatform.NATIVE && KLibUtils.checkKlibComponent($this$isKlibLibraryRootForPlatform, requestedBuiltInsPlatform)) {
            return true;
        }
        try {
            boolean bl;
            VirtualFile[] virtualFileArray = $this$isKlibLibraryRootForPlatform.getChildren();
            if (virtualFileArray != null) {
                boolean bl2;
                block7: {
                    VirtualFile[] $this$any$iv = virtualFileArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        VirtualFile element$iv;
                        VirtualFile it = element$iv = $this$any$iv[j];
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!KLibUtils.checkKlibComponent(it, requestedBuiltInsPlatform)) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }
        catch (InvalidVirtualFileAccessException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean checkKlibComponent(VirtualFile componentFile, BuiltInsPlatform requestedBuiltInsPlatform) {
        Closeable closeable;
        Object object;
        Object object2;
        block20: {
            block19: {
                object2 = componentFile.findChild("manifest");
                if (object2 == null) break block19;
                VirtualFile it = object = object2;
                boolean bl = false;
                object2 = !it.isDirectory() ? object : null;
                if (object2 != null) break block20;
            }
            return false;
        }
        VirtualFile manifestFile = object2;
        try {
            closeable = manifestFile.getInputStream();
            Throwable throwable = null;
            try {
                Properties properties2;
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                Properties $this$checkKlibComponent_u24lambda_u243_u24lambda_u242 = properties2 = new Properties();
                boolean bl2 = false;
                $this$checkKlibComponent_u24lambda_u243_u24lambda_u242.load(it);
                object = properties2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = object;
        }
        catch (IOException iOException) {
            return false;
        }
        Closeable manifestProperties = closeable;
        if (!((Properties)((Object)manifestProperties)).containsKey("unique_name")) {
            return false;
        }
        String iOException = ((Properties)((Object)manifestProperties)).getProperty("builtins_platform");
        if (iOException == null) {
            return switch (WhenMappings.$EnumSwitchMapping$0[requestedBuiltInsPlatform.ordinal()]) {
                case 1 -> KLibUtils.isLegacyNativeKlibComponent(componentFile);
                case 2 -> {
                    if (!KLibUtils.isLegacyNativeKlibComponent(componentFile)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        String builtInsPlatformProperty = iOException;
        BuiltInsPlatform builtInsPlatform = BuiltInsPlatform.Companion.parseFromString(builtInsPlatformProperty);
        if (builtInsPlatform == null) {
            return false;
        }
        BuiltInsPlatform builtInsPlatform2 = builtInsPlatform;
        return builtInsPlatform2 == requestedBuiltInsPlatform;
    }

    private static final BuiltInsPlatform toBuiltInsPlatform(TargetPlatform $this$toBuiltInsPlatform) {
        BuiltInsPlatform builtInsPlatform;
        if (TargetPlatformKt.isCommon((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.COMMON;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.NATIVE;
        } else if (JvmPlatformKt.isJvm((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JVM;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.JS;
        } else if (WasmPlatformKt.isWasm((TargetPlatform)$this$toBuiltInsPlatform)) {
            builtInsPlatform = BuiltInsPlatform.WASM;
        } else {
            throw new IllegalArgumentException("Unknown platform " + $this$toBuiltInsPlatform);
        }
        return builtInsPlatform;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isLegacyNativeKlibComponent(VirtualFile $this$isLegacyNativeKlibComponent) {
        VirtualFile irFolder = $this$isLegacyNativeKlibComponent.findChild("ir");
        if (irFolder == null) return false;
        VirtualFile[] virtualFileArray = irFolder.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        if (((Object[])virtualFileArray).length != 0) return true;
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuiltInsPlatform.values().length];
            try {
                nArray[BuiltInsPlatform.NATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuiltInsPlatform.COMMON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

