/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.platforms;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinLibraryKindKt;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH&J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0015H\u0004R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "", "()V", "supportedLibraryKind", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "getSupportedLibraryKind", "()Lorg/jetbrains/kotlin/idea/base/platforms/KotlinLibraryKind;", "getStdlibJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "roots", "", "getStdlibVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "isStdlib", "", "ignoreKind", "isSupported", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinJavaScriptStdlibDetectorFacility;", "Lorg/jetbrains/kotlin/idea/base/platforms/KotlinJvmStdlibDetectorFacility;", "kotlin.base.platforms"})
public abstract class StdlibDetectorFacility {
    private StdlibDetectorFacility() {
    }

    @Nullable
    public abstract VirtualFile getStdlibJar(@NotNull List<? extends VirtualFile> var1);

    @Nullable
    protected abstract KotlinLibraryKind getSupportedLibraryKind();

    public final boolean isStdlib(@NotNull Project project2, @NotNull Library library2, boolean ignoreKind) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        if (!(library2 instanceof LibraryEx) || ((LibraryEx)library2).isDisposed()) {
            return false;
        }
        if (!ignoreKind && !this.isSupported(project2, (LibraryEx)library2)) {
            return false;
        }
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        List classes2 = CollectionsKt.listOf((Object[])Arrays.copyOf(virtualFileArray2, virtualFileArray2.length));
        return this.getStdlibJar(classes2) != null;
    }

    public static /* synthetic */ boolean isStdlib$default(StdlibDetectorFacility stdlibDetectorFacility, Project project2, Library library2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isStdlib");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return stdlibDetectorFacility.isStdlib(project2, library2, bl);
    }

    @Nullable
    public final IdeKotlinVersion getStdlibVersion(@NotNull List<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        VirtualFile virtualFile2 = this.getStdlibJar(roots2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile stdlibJar = virtualFile2;
        return IdeKotlinVersion.Companion.fromManifest(stdlibJar);
    }

    @Nullable
    public final IdeKotlinVersion getStdlibVersion(@NotNull Project project2, @NotNull Library library2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        if (!(library2 instanceof LibraryEx) || ((LibraryEx)library2).isDisposed() || !this.isSupported(project2, (LibraryEx)library2)) {
            return null;
        }
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        return this.getStdlibVersion(ArraysKt.asList((Object[])virtualFileArray));
    }

    protected final boolean isSupported(@NotNull Project project2, @NotNull LibraryEx library2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
        return Intrinsics.areEqual(KotlinLibraryKindKt.detectLibraryKind((Library)library2, project2), (Object)this.getSupportedLibraryKind());
    }

    public /* synthetic */ StdlibDetectorFacility(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

