/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.plugin;

import com.intellij.diagnostic.VMOptions;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/base/plugin/KotlinPluginKindSwitcher;", "", "()V", "USE_K2_VM_OPTION_NAME", "", "USE_K2_VM_OPTION_PREFIX", "canPluginBeSwitchedByVmOptions", "", "getPluginKindByVmOptions", "Lorg/jetbrains/kotlin/idea/base/plugin/KotlinPluginKind;", "setPluginKindByVmOptions", "", "newPluginKind", "kotlin.base.plugin"})
public final class KotlinPluginKindSwitcher {
    @NotNull
    public static final KotlinPluginKindSwitcher INSTANCE = new KotlinPluginKindSwitcher();
    @NotNull
    private static final String USE_K2_VM_OPTION_NAME = "idea.kotlin.plugin.use.k2";
    @NotNull
    private static final String USE_K2_VM_OPTION_PREFIX = "-Didea.kotlin.plugin.use.k2=";

    private KotlinPluginKindSwitcher() {
    }

    @JvmStatic
    public static final boolean canPluginBeSwitchedByVmOptions() {
        return VMOptions.canWriteOptions();
    }

    @JvmStatic
    @NotNull
    public static final KotlinPluginKind getPluginKindByVmOptions() {
        boolean isK2Enabled = Boolean.parseBoolean(VMOptions.readOption((String)USE_K2_VM_OPTION_PREFIX, (boolean)false));
        return isK2Enabled ? KotlinPluginKind.FIR_PLUGIN : KotlinPluginKind.FE10_PLUGIN;
    }

    @JvmStatic
    public static final void setPluginKindByVmOptions(@NotNull KotlinPluginKind newPluginKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)newPluginKind), (String)"newPluginKind");
        boolean isK2Enabled = newPluginKind == KotlinPluginKind.FIR_PLUGIN;
        VMOptions.setOption((String)USE_K2_VM_OPTION_PREFIX, (String)String.valueOf(isK2Enabled));
    }
}

