/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.hints;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.HorizontalConstraints;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.HintType;
import org.jetbrains.kotlin.idea.codeInsight.hints.InlayInfoDetails;
import org.jetbrains.kotlin.idea.codeInsight.hints.KotlinAbstractHintsProviderKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000201B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J/\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000eH\u0016J\u001f\u0010'\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010!\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010*J\u0010\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020)H\u0016J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinAbstractHintsProvider;", "T", "", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "()V", "hintsArePlacedAtTheEndOfLine", "", "getHintsArePlacedAtTheEndOfLine", "()Z", "hintsPriority", "", "getHintsPriority", "()I", "previewText", "", "getPreviewText", "()Ljava/lang/String;", "createFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "document", "Lcom/intellij/openapi/editor/Document;", "getCaseDescription", "case", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable$Case;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;Ljava/lang/Object;Lcom/intellij/codeInsight/hints/InlayHintsSink;)Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "getProperty", "key", "isElementSupported", "resolved", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "(Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;Ljava/lang/Object;)Z", "isHintSupported", "hintType", "isLanguageSupported", "language", "Lcom/intellij/lang/Language;", "HintsSettings", "PresentationAndSettings", "kotlin.idea"})
public abstract class KotlinAbstractHintsProvider<T>
implements InlayHintsProvider<T> {
    @Nullable
    private final String previewText;
    private final boolean hintsArePlacedAtTheEndOfLine;
    private final int hintsPriority;

    public KotlinAbstractHintsProvider() {
        this.previewText = "";
        this.hintsPriority = 100;
    }

    @Nullable
    public String getPreviewText() {
        return this.previewText;
    }

    public boolean getHintsArePlacedAtTheEndOfLine() {
        return this.hintsArePlacedAtTheEndOfLine;
    }

    public int getHintsPriority() {
        return this.hintsPriority;
    }

    public abstract boolean isElementSupported(@Nullable HintType var1, @NotNull T var2);

    public boolean isHintSupported(@NotNull HintType hintType) {
        Intrinsics.checkNotNullParameter((Object)((Object)hintType), (String)"hintType");
        return false;
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE);
    }

    @NotNull
    public String getProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = KotlinBundle.INSTANCE.getMessage(key, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessage(...)");
        return string;
    }

    @Nullable
    public String getCaseDescription(@NotNull ImmediateConfigurable.Case case_) {
        Intrinsics.checkNotNullParameter((Object)case_, (String)"case");
        return case_.getExtendedDescription();
    }

    @NotNull
    public PsiFile createFile(@NotNull Project project2, @NotNull FileType fileType, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return (PsiFile)KotlinAbstractHintsProviderKt.createKtFile(project2, document, fileType);
    }

    @Nullable
    public InlayHintsCollector getCollectorFor(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull T settings2, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return (InlayHintsCollector)new FactoryInlayHintsCollector(editor2, this, settings2){
            final /* synthetic */ KotlinAbstractHintsProvider<T> this$0;
            final /* synthetic */ T $settings;
            {
                this.this$0 = $receiver;
                this.$settings = $settings;
                super($editor);
            }

            /*
             * WARNING - void declaration
             */
            public boolean collect(@NotNull PsiElement element3, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                Project project2 = editor2.getProject();
                if (project2 == null) {
                    project2 = element3.getProject();
                }
                Project project3 = project2;
                Intrinsics.checkNotNull((Object)project3);
                Project project4 = project3;
                if (DumbService.Companion.isDumb(project4)) {
                    return true;
                }
                Collection collection = HintType.Companion.resolve(element3);
                if (collection.isEmpty()) {
                    boolean bl = false;
                    return true;
                }
                List resolved = (List)collection;
                PresentationFactory f2 = this.getFactory();
                Iterable bl = resolved;
                KotlinAbstractHintsProvider<T> kotlinAbstractHintsProvider = this.this$0;
                T t = this.$settings;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    HintType hintType = (HintType)((Object)element$iv);
                    boolean bl2 = false;
                    if (!kotlinAbstractHintsProvider.isElementSupported(hintType, t)) continue;
                    Iterable $this$forEach$iv2 = hintType.provideHintDetails(element3);
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        InlayInfoDetails details = (InlayInfoDetails)element$iv2;
                        boolean bl3 = false;
                        PresentationAndSettings p = new PresentationAndSettings(KotlinAbstractHintsProviderKt.getInlayPresentationForInlayInfoDetails(element3, hintType, details, f2, project4, (InlayHintsProvider)kotlinAbstractHintsProvider), details.getInlayInfo().getOffset(), details.getInlayInfo().getRelatesToPrecedingText());
                        HorizontalConstraints horizontalConstraints = new HorizontalConstraints(kotlinAbstractHintsProvider.getHintsPriority(), p.getRelatesToPrecedingText(), kotlinAbstractHintsProvider.getHintsArePlacedAtTheEndOfLine());
                        sink.addInlineElement(p.getOffset(), (RootInlayPresentation)new RecursivelyUpdatingRootPresentation(p.getPresentation()), horizontalConstraints);
                    }
                }
                return true;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinAbstractHintsProvider$HintsSettings;", "", "()V", "enable", "", "hintType", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/HintType;", "", "isEnabled", "kotlin.idea"})
    public static abstract class HintsSettings {
        public abstract boolean isEnabled(@NotNull HintType var1);

        public abstract void enable(@NotNull HintType var1, boolean var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/hints/KotlinAbstractHintsProvider$PresentationAndSettings;", "", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "offset", "", "relatesToPrecedingText", "", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;IZ)V", "getOffset", "()I", "getPresentation", "()Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "getRelatesToPrecedingText", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "kotlin.idea"})
    public static final class PresentationAndSettings {
        @NotNull
        private final InlayPresentation presentation;
        private final int offset;
        private final boolean relatesToPrecedingText;

        public PresentationAndSettings(@NotNull InlayPresentation presentation2, int offset2, boolean relatesToPrecedingText) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            this.presentation = presentation2;
            this.offset = offset2;
            this.relatesToPrecedingText = relatesToPrecedingText;
        }

        @NotNull
        public final InlayPresentation getPresentation() {
            return this.presentation;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final boolean getRelatesToPrecedingText() {
            return this.relatesToPrecedingText;
        }

        @NotNull
        public final InlayPresentation component1() {
            return this.presentation;
        }

        public final int component2() {
            return this.offset;
        }

        public final boolean component3() {
            return this.relatesToPrecedingText;
        }

        @NotNull
        public final PresentationAndSettings copy(@NotNull InlayPresentation presentation2, int offset2, boolean relatesToPrecedingText) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            return new PresentationAndSettings(presentation2, offset2, relatesToPrecedingText);
        }

        public static /* synthetic */ PresentationAndSettings copy$default(PresentationAndSettings presentationAndSettings, InlayPresentation inlayPresentation, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                inlayPresentation = presentationAndSettings.presentation;
            }
            if ((n2 & 2) != 0) {
                n = presentationAndSettings.offset;
            }
            if ((n2 & 4) != 0) {
                bl = presentationAndSettings.relatesToPrecedingText;
            }
            return presentationAndSettings.copy(inlayPresentation, n, bl);
        }

        @NotNull
        public String toString() {
            return "PresentationAndSettings(presentation=" + this.presentation + ", offset=" + this.offset + ", relatesToPrecedingText=" + this.relatesToPrecedingText + ")";
        }

        public int hashCode() {
            int result2 = this.presentation.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.offset);
            int n = this.relatesToPrecedingText ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            if (!(other2 instanceof PresentationAndSettings)) {
                return false;
            }
            PresentationAndSettings presentationAndSettings = (PresentationAndSettings)other2;
            if (!Intrinsics.areEqual((Object)this.presentation, (Object)presentationAndSettings.presentation)) {
                return false;
            }
            if (this.offset != presentationAndSettings.offset) {
                return false;
            }
            return this.relatesToPrecedingText == presentationAndSettings.relatesToPrecedingText;
        }
    }
}

