/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.SortModifiersInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@IntellijInternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0002H\u0002J\f\u0010\u0018\u001a\u00020\u0014*\u00020\u0002H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SortModifiersInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "modifierKeywordTokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "modifiersBeforeAnnotations", "kotlin.code-insight.inspections-shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSortModifiersInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SortModifiersInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SortModifiersInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n288#2,2:78\n533#2,6:80\n766#2:86\n857#2,2:87\n1855#2,2:89\n3190#2,10:91\n1855#2,2:102\n1#3:101\n*S KotlinDebug\n*F\n+ 1 SortModifiersInspection.kt\norg/jetbrains/kotlin/idea/codeInsight/inspections/shared/SortModifiersInspection\n*L\n37#1:78,2\n38#1:80,6\n50#1:86\n50#1:87,2\n51#1:89,2\n55#1:91,10\n57#1:102,2\n*E\n"})
public final class SortModifiersInspection
extends AbstractApplicabilityBasedInspection<KtModifierList>
implements CleanupLocalInspectionTool {
    public SortModifiersInspection() {
        super(KtModifierList.class);
    }

    @Override
    public boolean isApplicable(@NotNull KtModifierList element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        List<KtModifierKeywordToken> modifiers2 = this.modifierKeywordTokens(element3);
        if (modifiers2.isEmpty()) {
            return false;
        }
        List sortedModifiers = AddRemoveModifierKt.sortModifiers(modifiers2);
        return !Intrinsics.areEqual(modifiers2, (Object)sortedModifiers) || this.modifiersBeforeAnnotations(element3);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtModifierList element3) {
        Object v2;
        PsiElement startElement2;
        block5: {
            Object v0;
            List modifierElements;
            block4: {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                modifierElements = SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)element3))));
                Iterable $this$firstOrNull$iv = modifierElements;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(it.getNode().getElementType() instanceof KtModifierKeywordToken)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            PsiElement psiElement2 = v0;
            if (psiElement2 == null) {
                return null;
            }
            startElement2 = psiElement2;
            List $this$lastOrNull$iv = modifierElements;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it.getNode().getElementType() instanceof KtModifierKeywordToken)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        PsiElement psiElement3 = v2;
        if (psiElement3 == null) {
            return null;
        }
        PsiElement endElement2 = psiElement3;
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)startElement2), PsiUtilsKt.getEndOffset((PsiElement)endElement2)).shiftLeft(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element3)));
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtModifierList element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return this.modifiersBeforeAnnotations(element3) ? KotlinBundle.message("modifiers.should.follow.annotations", new Object[0]) : KotlinBundle.message("non.canonical.modifiers.order", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("sort.modifiers", new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtModifierList element3, @NotNull Project project2, @Nullable Editor editor2) {
        Iterable $this$partition$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PsiElement psiElement2 = element3.getParent();
        KtModifierListOwner ktModifierListOwner = psiElement2 instanceof KtModifierListOwner ? (KtModifierListOwner)psiElement2 : null;
        if (ktModifierListOwner == null) {
            return;
        }
        KtModifierListOwner owner = ktModifierListOwner;
        List sortedModifiers = AddRemoveModifierKt.sortModifiers(this.modifierKeywordTokens(element3));
        Iterable $this$filter$iv = sortedModifiers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
            boolean bl = false;
            if (!owner.hasModifier(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingModifiers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = existingModifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModifierKeywordToken it2 = (KtModifierKeywordToken)element$iv;
            boolean bl = false;
            owner.removeModifier(it2);
        }
        $this$forEach$iv = existingModifiers;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv;
            boolean bl = false;
            if (KtTokens.VISIBILITY_MODIFIERS.contains((IElementType)it) || KtTokens.MODALITY_MODIFIERS.contains((IElementType)it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair it = new Pair(first$iv, second$iv);
        boolean bl = false;
        $this$partition$iv = CollectionsKt.plus((Collection)((Collection)it.getSecond()), (Iterable)((Iterable)it.getFirst()));
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtModifierKeywordToken it2 = (KtModifierKeywordToken)element$iv;
            boolean bl2 = false;
            owner.addModifier(it2);
        }
    }

    private final List<KtModifierKeywordToken> modifierKeywordTokens(KtModifierList $this$modifierKeywordTokens) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$modifierKeywordTokens))), (Function1)modifierKeywordTokens.1.INSTANCE));
    }

    private final boolean modifiersBeforeAnnotations(KtModifierList $this$modifiersBeforeAnnotations) {
        List modifierElements = SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$modifiersBeforeAnnotations))));
        boolean modifiersBeforeAnnotations = false;
        boolean seenModifiers = false;
        for (PsiElement modifierElement : modifierElements) {
            if (modifierElement.getNode().getElementType() instanceof KtModifierKeywordToken) {
                seenModifiers = true;
                continue;
            }
            if (!seenModifiers || !(modifierElement instanceof KtAnnotationEntry) && !(modifierElement instanceof KtAnnotation)) continue;
            modifiersBeforeAnnotations = true;
        }
        return modifiersBeforeAnnotations;
    }
}

