/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import java.io.File;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducer;
import org.jetbrains.kotlin.idea.base.plugin.artifacts.AbstractLazyFileOutputProducerKt;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00182\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0014\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002J)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0011\u001a\u00020\u0004H\u0014\u00a2\u0006\u0002\u0010\u0012J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyDistDirLayoutProducer;", "Lorg/jetbrains/kotlin/idea/base/plugin/artifacts/AbstractLazyFileOutputProducer;", "", "Ljava/io/File;", "", "version", "", "unpackedDistDestination", "(Ljava/lang/String;Ljava/io/File;)V", "kotlinVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getDistJarNameFromMavenJar", "jarInMavenRepo", "lazyProduceDist", "jars", "produceOutput", "input", "computationContext", "(Ljava/util/List;Lkotlin/Unit;)Ljava/util/List;", "updateMessageDigestWithInput", "messageDigest", "Ljava/security/MessageDigest;", "buffer", "", "Companion", "kotlin.base.plugin"})
@SourceDebugExtension(value={"SMAP\nLazyKotlincDistDownloaderAndUnpacker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyKotlincDistDownloaderAndUnpacker.kt\norg/jetbrains/kotlin/idea/compiler/configuration/LazyDistDirLayoutProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1#2:161\n1747#3,3:162\n1747#3,3:165\n*S KotlinDebug\n*F\n+ 1 LazyKotlincDistDownloaderAndUnpacker.kt\norg/jetbrains/kotlin/idea/compiler/configuration/LazyDistDirLayoutProducer\n*L\n128#1:162,3\n145#1:165,3\n*E\n"})
final class LazyDistDirLayoutProducer
extends AbstractLazyFileOutputProducer<List<? extends File>, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File unpackedDistDestination;
    @NotNull
    private final IdeKotlinVersion kotlinVersion;
    private static final int ALGORITHM_VERSION = 1;

    public LazyDistDirLayoutProducer(@NotNull String version2, @NotNull File unpackedDistDestination) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)unpackedDistDestination, (String)"unpackedDistDestination");
        super(LazyDistDirLayoutProducer.class.getName() + "-" + version2);
        this.unpackedDistDestination = unpackedDistDestination;
        Object object = IdeKotlinVersion.Companion.parse-IoAF18A(version2);
        ResultKt.throwOnFailure((Object)object);
        this.kotlinVersion = (IdeKotlinVersion)object;
    }

    @Override
    @NotNull
    protected List<File> produceOutput(@NotNull List<? extends File> input, @NotNull Unit computationContext) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)computationContext, (String)"computationContext");
        if (!FilesKt.deleteRecursively((File)this.unpackedDistDestination)) {
            boolean $i$a$-check-LazyDistDirLayoutProducer$produceOutput$32 = false;
            String $i$a$-check-LazyDistDirLayoutProducer$produceOutput$32 = "Can't delete " + this.unpackedDistDestination;
            throw new IllegalStateException($i$a$-check-LazyDistDirLayoutProducer$produceOutput$32.toString());
        }
        File lib = FilesKt.resolve((File)this.unpackedDistDestination, (String)"lib");
        if (!lib.mkdirs()) {
            boolean $i$a$-check-LazyDistDirLayoutProducer$produceOutput$42 = false;
            String $i$a$-check-LazyDistDirLayoutProducer$produceOutput$42 = "Can't create " + lib + " directory";
            throw new IllegalStateException($i$a$-check-LazyDistDirLayoutProducer$produceOutput$42.toString());
        }
        Iterator<? extends File> $i$a$-check-LazyDistDirLayoutProducer$produceOutput$32 = input.iterator();
        while ($i$a$-check-LazyDistDirLayoutProducer$produceOutput$32.hasNext()) {
            File jarInMavenRepo;
            String string = this.getDistJarNameFromMavenJar(jarInMavenRepo);
            if (string == null) continue;
            jarInMavenRepo = $i$a$-check-LazyDistDirLayoutProducer$produceOutput$32.next();
            FilesKt.copyTo$default((File)jarInMavenRepo, (File)FilesKt.resolve((File)lib, (String)string), (boolean)false, (int)0, (int)6, null);
        }
        File jsEngines2 = KotlinPluginLayout.INSTANCE.getJsEngines();
        String string = jsEngines2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        FilesKt.copyTo$default((File)jsEngines2, (File)FilesKt.resolve((File)lib, (String)string), (boolean)false, (int)0, (int)6, null);
        return CollectionsKt.listOf((Object)this.unpackedDistDestination);
    }

    @Override
    protected void updateMessageDigestWithInput(@NotNull MessageDigest messageDigest, @NotNull List<? extends File> input, @NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)messageDigest, (String)"messageDigest");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        BigInteger bigInteger = BigInteger.valueOf(1L);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        messageDigest.update(bigInteger.toByteArray());
        AbstractLazyFileOutputProducerKt.update(messageDigest, input, buffer);
    }

    @NotNull
    public final File lazyProduceDist(@NotNull List<? extends File> jars) {
        Intrinsics.checkNotNullParameter(jars, (String)"jars");
        File file2 = (File)CollectionsKt.singleOrNull(this.lazyProduceOutput(jars, Unit.INSTANCE));
        if (file2 == null) {
            throw new IllegalStateException("produceOutput returns single element".toString());
        }
        return file2;
    }

    private final String getDistJarNameFromMavenJar(File jarInMavenRepo) {
        String version2 = jarInMavenRepo.getParentFile().getName();
        String nameWithoutExtension = FilesKt.getNameWithoutExtension((File)jarInMavenRepo);
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"jline", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"jansi", (boolean)false, (int)2, null)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)jarInMavenRepo.getName(), (Object)"annotations-13.0.jar")) {
            return jarInMavenRepo.getName();
        }
        Object object = IdeKotlinVersion.Companion.parse-IoAF18A("1.8.255");
        ResultKt.throwOnFailure((Object)object);
        if (this.kotlinVersion.compareTo((IdeKotlinVersion)object) <= 0) {
            if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-serialization", (boolean)false, (int)2, null)) {
                return "kotlinx-serialization-compiler-plugin.jar";
            }
            if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-sam-with-receiver", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-allopen", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-lombok", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-noarg", (boolean)false, (int)2, null)) {
                return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)nameWithoutExtension, (CharSequence)"kotlin-maven-"), (CharSequence)("-" + version2)) + "-compiler-plugin.jar";
            }
        } else {
            boolean bl;
            block18: {
                boolean bl2;
                block17: {
                    Object[] objectArray = new String[]{"kotlin-maven-allopen", "kotlin-maven-lombok", "kotlin-maven-noarg", "kotlin-maven-sam-with-receiver"};
                    List compatMavenPlugins = CollectionsKt.listOf((Object[])objectArray);
                    Iterable $this$any$iv = compatMavenPlugins;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.startsWith$default((String)nameWithoutExtension, (String)it, (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block17;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return null;
                }
                if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-maven-serialization", (boolean)false, (int)2, null)) {
                    return "kotlinx-serialization-compiler-plugin.jar";
                }
                Object[] $i$f$any = new String[]{"kotlin-sam-with-receiver-compiler-plugin", "kotlin-allopen-compiler-plugin", "kotlin-lombok-compiler-plugin", "kotlin-noarg-compiler-plugin", "kotlin-assignment-compiler-plugin"};
                List compilerPluginNames = CollectionsKt.listOf((Object[])$i$f$any);
                Iterable $this$any$iv = compilerPluginNames;
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (!StringsKt.startsWith$default((String)nameWithoutExtension, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)nameWithoutExtension, (CharSequence)"kotlin-"), (CharSequence)("-" + version2)) + ".jar";
            }
        }
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-android-extensions-runtime", (boolean)false, (int)2, null)) {
            return "android-extensions-runtime.jar";
        }
        if (StringsKt.startsWith$default((String)nameWithoutExtension, (String)"kotlin-android-extensions", (boolean)false, (int)2, null)) {
            return "android-extensions-compiler.jar";
        }
        return StringsKt.removeSuffix((String)nameWithoutExtension, (CharSequence)("-" + version2)) + ".jar";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/LazyDistDirLayoutProducer$Companion;", "", "()V", "ALGORITHM_VERSION", "", "kotlin.base.plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

