/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jdi.LocalVariableImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.calls.KtCallInfo;
import org.jetbrains.kotlin.analysis.api.calls.KtCallKt;
import org.jetbrains.kotlin.analysis.api.calls.KtFunctionCall;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.session.KtAnalysisSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KtCallableSignature;
import org.jetbrains.kotlin.analysis.api.signatures.KtVariableLikeSignature;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtUsualClassType;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u000e\u001a\u00020\u0006*\u00020\tH\u0002\u001a\u0014\u0010\u000f\u001a\u00020\r*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\r*\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\r*\u00020\u0015H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\r*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"findTargetClasses", "", "Lcom/sun/jdi/ReferenceType;", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "", "getClassName", "", "Lcom/sun/jdi/Location;", "getContainingMethod", "Lcom/intellij/psi/PsiElement;", "excludingElement", "", "getZeroBasedLineNumber", "hasVisibleInlineLambdasOnLines", "lines", "Lkotlin/ranges/IntRange;", "isGeneratedErasedLambdaMethod", "Lcom/sun/jdi/Method;", "isSamLambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isVisible", "Lcom/jetbrains/jdi/LocalVariableImpl;", "location", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinPositionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KtAnalysisSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KtAnalysisSessionProvider\n*L\n1#1,812:1\n1726#2,3:813\n1247#3,2:816\n27#4,2:818\n55#5:820\n69#5,8:821\n*S KotlinDebug\n*F\n+ 1 KotlinPositionManager.kt\norg/jetbrains/kotlin/idea/debugger/KotlinPositionManagerKt\n*L\n696#1:813,3\n717#1:816,2\n787#1:818,2\n787#1:820\n787#1:821,8\n*E\n"})
public final class KotlinPositionManagerKt {
    @Nullable
    public static final PsiElement getContainingMethod(@NotNull PsiElement $this$getContainingMethod, boolean excludingElement) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingMethod, (String)"<this>");
        Class[] classArray = new Class[]{KtFunction.class, KtClassInitializer.class, KtPropertyAccessor.class, KtScript.class};
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getContainingMethod, (boolean)excludingElement, (Class[])classArray);
    }

    public static /* synthetic */ PsiElement getContainingMethod$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return KotlinPositionManagerKt.getContainingMethod(psiElement2, bl);
    }

    public static final boolean isGeneratedErasedLambdaMethod(@NotNull Method $this$isGeneratedErasedLambdaMethod) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedErasedLambdaMethod, (String)"<this>");
        String string = $this$isGeneratedErasedLambdaMethod.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        if (DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(string) && $this$isGeneratedErasedLambdaMethod.isPrivate() && $this$isGeneratedErasedLambdaMethod.isStatic()) {
            List<String> args = $this$isGeneratedErasedLambdaMethod.argumentTypeNames();
            String kotlinFunctionPrefix = "kotlin.jvm.functions.Function";
            if (args.size() >= 2) {
                String string2 = args.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                if (StringsKt.startsWith$default((String)string2, (String)kotlinFunctionPrefix, (boolean)false, (int)2, null)) {
                    String string3 = args.get(0);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
                    Integer parameterCount = StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)string3, (CharSequence)kotlinFunctionPrefix));
                    if (parameterCount != null && args.size() == parameterCount + 1) {
                        boolean bl;
                        block8: {
                            Intrinsics.checkNotNull(args);
                            Iterable $this$all$iv = CollectionsKt.drop((Iterable)args, (int)1);
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    String it = (String)element$iv;
                                    boolean bl2 = false;
                                    if (Intrinsics.areEqual((Object)it, (Object)"java.lang.Object")) continue;
                                    bl = false;
                                    break block8;
                                }
                                bl = true;
                            }
                        }
                        if (bl) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static final int getZeroBasedLineNumber(Location $this$getZeroBasedLineNumber) {
        return DebuggerUtilsEx.getLineNumber((Location)$this$getZeroBasedLineNumber, (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasVisibleInlineLambdasOnLines(Location $this$hasVisibleInlineLambdasOnLines, IntRange lines) {
        boolean bl;
        Method method = SafeUtilKt.safeMethod($this$hasVisibleInlineLambdasOnLines);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        Sequence $this$any$iv = SequencesKt.filter((Sequence)MapsKt.asSequence(DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method2)), (Function1)((Function1)new Function1<Map.Entry<? extends LocalVariable, ? extends ClosedRange<Location>>, Boolean>($this$hasVisibleInlineLambdasOnLines){
            final /* synthetic */ Location $this_hasVisibleInlineLambdasOnLines;
            {
                this.$this_hasVisibleInlineLambdasOnLines = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<? extends LocalVariable, ? extends ClosedRange<Location>> entry) {
                boolean bl;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                LocalVariable variable2 = entry.getKey();
                if (variable2 instanceof LocalVariableImpl && KotlinPositionManagerKt.access$isVisible((LocalVariableImpl)variable2, this.$this_hasVisibleInlineLambdasOnLines)) {
                    String string = variable2.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"$i$a$", (boolean)false, (int)2, null)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            ClosedRange borders = (ClosedRange)entry.getValue();
            int n = lines.getFirst();
            int n2 = lines.getLast();
            int n3 = KotlinPositionManagerKt.getZeroBasedLineNumber((Location)borders.getStart());
            boolean bl3 = n <= n3 ? n3 <= n2 : false;
            if (bl3) {
                boolean bl4;
                n = lines.getFirst();
                n2 = lines.getLast();
                n3 = KotlinPositionManagerKt.getZeroBasedLineNumber((Location)borders.getEndInclusive());
                if (n <= n3) {
                    if (n3 <= n2) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean isVisible(LocalVariableImpl $this$isVisible, Location location2) {
        return $this$isVisible.getScopeStart().compareTo(location2) <= 0 && $this$isVisible.getScopeEnd().compareTo(location2) >= 0;
    }

    @Nullable
    public static final String getClassName(@NotNull Location $this$getClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassName, (String)"<this>");
        String string = $this$getClassName.declaringType().name();
        if (string == null) {
            return null;
        }
        String currentLocationFqName = string;
        String string2 = JvmClassName.byFqNameWithoutInnerClasses((FqName)new FqName(currentLocationFqName)).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        return StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
    }

    private static final List<ReferenceType> findTargetClasses(DebugProcess $this$findTargetClasses, ReferenceType outerClass, int lineAt) {
        VirtualMachineProxy vmProxy = $this$findTargetClasses.getVirtualMachineProxy();
        try {
            if (!outerClass.isPrepared()) {
                return CollectionsKt.emptyList();
            }
        }
        catch (ObjectCollectedException e) {
            return CollectionsKt.emptyList();
        }
        ArrayList targetClasses = new ArrayList(1);
        try {
            for (Location location2 : SafeUtilKt.safeAllLineLocations(outerClass)) {
                Method method;
                int locationLine = location2.lineNumber() - 1;
                if (locationLine < 0 || lineAt != locationLine || (method = location2.method()) == null || com.intellij.debugger.engine.DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                ((Collection)targetClasses).add(outerClass);
                break;
            }
            List nestedTypes = vmProxy.nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                Collection collection = targetClasses;
                Intrinsics.checkNotNull((Object)nested);
                CollectionsKt.addAll((Collection)collection, (Iterable)KotlinPositionManagerKt.findTargetClasses($this$findTargetClasses, nested, lineAt));
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return targetClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean isSamLambda(KtFunction $this$isSamLambda) {
        void this_$iv$iv$iv;
        if (!($this$isSamLambda instanceof KtFunctionLiteral) && !($this$isSamLambda instanceof KtNamedFunction)) {
            return false;
        }
        boolean $i$f$analyze = false;
        Project project2 = ((KtElement)$this$isSamLambda).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KtAnalysisSessionProvider this_$iv$iv = KtAnalysisSessionProvider.Companion.getInstance(project2);
        boolean $i$f$analyse = false;
        KtAnalysisSessionProvider ktAnalysisSessionProvider = this_$iv$iv;
        KtAnalysisSession analysisSession$iv$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)$this$isSamLambda);
        boolean $i$f$analyse2 = false;
        this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().beforeEnteringAnalysisContext();
        this_$iv$iv$iv.getTokenFactory().beforeEnteringAnalysisContext(analysisSession$iv$iv$iv.getToken());
        try {
            KtValueArgument ktValueArgument;
            KtCallExpression ktCallExpression;
            KtAnalysisSession $this$isSamLambda_u24lambda_u242 = analysisSession$iv$iv$iv;
            boolean bl = false;
            KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)$this$isSamLambda));
            if ((ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null) == null) {
                boolean bl2 = false;
                return bl2;
            }
            KtCallExpression parentCall2 = ktCallExpression;
            KtLifetimeOwner ktLifetimeOwner = $this$isSamLambda_u24lambda_u242.resolveCall((KtElement)parentCall2);
            if (ktLifetimeOwner == null || (ktLifetimeOwner = KtCallKt.successfulFunctionCallOrNull((KtCallInfo)ktLifetimeOwner)) == null) {
                boolean bl3 = false;
                return bl3;
            }
            KtLifetimeOwner call = ktLifetimeOwner;
            if (KotlinPsiUtils.getContainingValueArgument(parentCall2, (KtExpression)$this$isSamLambda) == null) {
                boolean bl4 = false;
                return bl4;
            }
            KtValueArgument valueArgument = ktValueArgument;
            KtLifetimeOwner ktLifetimeOwner2 = (KtVariableLikeSignature)((Map)((KtFunctionCall)call).getArgumentMapping()).get(valueArgument.getArgumentExpression());
            if (ktLifetimeOwner2 == null || (ktLifetimeOwner2 = (KtValueParameterSymbol)((KtCallableSignature)ktLifetimeOwner2).getSymbol()) == null) {
                boolean bl5 = false;
                return bl5;
            }
            KtLifetimeOwner argument2 = ktLifetimeOwner2;
            boolean bl6 = ((KtCallableSymbol)argument2).getReturnType() instanceof KtUsualClassType;
            return bl6;
        }
        finally {
            this_$iv$iv$iv.getTokenFactory().afterLeavingAnalysisContext(analysisSession$iv$iv$iv.getToken());
            this_$iv$iv$iv.getNoWriteActionInAnalyseCallChecker().afterLeavingAnalysisContext();
        }
    }

    public static final /* synthetic */ boolean access$isSamLambda(KtFunction $receiver) {
        return KotlinPositionManagerKt.isSamLambda($receiver);
    }

    public static final /* synthetic */ List access$findTargetClasses(DebugProcess $receiver, ReferenceType outerClass, int lineAt) {
        return KotlinPositionManagerKt.findTargetClasses($receiver, outerClass, lineAt);
    }

    public static final /* synthetic */ boolean access$isVisible(LocalVariableImpl $receiver, Location location2) {
        return KotlinPositionManagerKt.isVisible($receiver, location2);
    }
}

