/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stackFrame;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.InlineStackTraceCalculatorKt;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.KotlinStackFrameInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stackFrame/InlineStackTraceCalculator;", "", "()V", "calculateInlineStackTrace", "", "Lcom/intellij/xdebugger/frame/XStackFrame;", "descriptor", "Lcom/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl;", "calculateVisibleVariables", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nInlineStackTraceCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/InlineStackTraceCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,390:1\n1549#2:391\n1620#2,3:392\n*S KotlinDebug\n*F\n+ 1 InlineStackTraceCalculator.kt\norg/jetbrains/kotlin/idea/debugger/core/stackFrame/InlineStackTraceCalculator\n*L\n22#1:391\n22#1:392,3\n*E\n"})
public final class InlineStackTraceCalculator {
    @NotNull
    public static final InlineStackTraceCalculator INSTANCE = new InlineStackTraceCalculator();

    private InlineStackTraceCalculator() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<XStackFrame> calculateInlineStackTrace(@NotNull StackFrameDescriptorImpl descriptor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        StackFrame stackFrame = descriptor2.getFrameProxy().getStackFrame();
        Intrinsics.checkNotNullExpressionValue((Object)stackFrame, (String)"getStackFrame(...)");
        Iterable $this$map$iv = InlineStackTraceCalculatorKt.computeKotlinStackFrameInfos(stackFrame);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinStackFrameInfo kotlinStackFrameInfo = (KotlinStackFrameInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toXStackFrame(descriptor2));
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final List<LocalVariableProxyImpl> calculateVisibleVariables(@NotNull StackFrameProxyImpl frameProxy) {
        List<LocalVariableProxyImpl> list2;
        Intrinsics.checkNotNullParameter((Object)frameProxy, (String)"frameProxy");
        Location location2 = frameProxy.location();
        Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"location(...)");
        if (DebuggerUtil.isInKotlinSources(location2)) {
            StackFrame stackFrame = frameProxy.getStackFrame();
            Intrinsics.checkNotNullExpressionValue((Object)stackFrame, (String)"getStackFrame(...)");
            list2 = ((KotlinStackFrameInfo)CollectionsKt.last(InlineStackTraceCalculatorKt.computeKotlinStackFrameInfos(stackFrame))).visibleVariableProxies(frameProxy);
        } else {
            List<LocalVariableProxyImpl> list3 = frameProxy.visibleVariables();
            Intrinsics.checkNotNull((Object)list3);
            list2 = list3;
        }
        return list2;
    }
}

