/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItemsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u001d\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0001\u0004\u0018\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "Lcom/intellij/debugger/memory/utils/StackFrameItem;", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "(Lcom/sun/jdi/Location;Ljava/util/List;)V", "getLocation", "()Lcom/sun/jdi/Location;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getSpilledVariables", "()Ljava/util/List;", "createFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "uniqueId", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/DefaultCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendCoroutineStackFrameItem;", "kotlin.jvm-debugger.coroutines"})
public abstract class CoroutineStackFrameItem
extends StackFrameItem {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Location location;
    @NotNull
    private final List<JavaValue> spilledVariables;
    @NotNull
    private final ReadOnlyProperty log$delegate;

    private CoroutineStackFrameItem(Location location2, List<? extends JavaValue> spilledVariables) {
        super(location2, spilledVariables);
        this.location = location2;
        this.spilledVariables = spilledVariables;
        this.log$delegate = ProvidersKt.getLogger();
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final List<JavaValue> getSpilledVariables() {
        return this.spilledVariables;
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Nullable
    public XStackFrame createFrame(@NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return (XStackFrame)DebuggerUtil.invokeInManagerThread(debugProcess, (Function1)new Function1<DebuggerContextImpl, CoroutineStackFrame>(debugProcess, this){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ CoroutineStackFrameItem this$0;
            {
                this.$debugProcess = $debugProcess;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final CoroutineStackFrame invoke(@NotNull DebuggerContextImpl it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                StackFrameProxyImpl stackFrameProxyImpl = CoroutineStackFrameItemsKt.findFirstFrame(this.$debugProcess);
                if (stackFrameProxyImpl == null) {
                    return null;
                }
                StackFrameProxyImpl frame = stackFrameProxyImpl;
                XSourcePosition position = CoroutineUtilsKt.findPosition(this.this$0.getLocation(), this.$debugProcess);
                return new CoroutineStackFrame(frame, position, this.this$0.getSpilledVariables(), false, this.this$0.getLocation());
            }
        });
    }

    @NotNull
    public final String uniqueId() {
        return SafeUtilKt.safeSourceName(this.location) + ":" + SafeUtilKt.safeMethod(this.location) + ":" + SafeUtilKt.safeLineNumber(this.location) + ":" + SafeUtilKt.safeKotlinPreferredLineNumber(this.location);
    }

    public /* synthetic */ CoroutineStackFrameItem(Location location2, List spilledVariables, DefaultConstructorMarker $constructor_marker) {
        this(location2, spilledVariables);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CoroutineStackFrameItem.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

