/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.stackFrame.ThisLabelUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DebuggerFieldPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzer;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.K1CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OnceUsedChecker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ContextReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0017J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020#H\u0002J\u0012\u0010*\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020(H\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u0016H\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00172\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\u00172\u0006\u0010,\u001a\u00020\u0016H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u000206H\u0002J$\u00107\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020(2\u0006\u00101\u001a\u0002022\b\u00108\u001a\u0004\u0018\u00010&H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020(H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00172\u0006\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010\u00172\u0006\u0010,\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020@H\u0002J\u0015\u0010A\u001a\u00020\"*\u00020#2\u0006\u0010B\u001a\u00020#H\u0082\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "containingPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "getContainingPrimaryConstructor", "()Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "containingPrimaryConstructor$delegate", "Lkotlin/Lazy;", "crossingBounds", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "onceUsedChecker", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/OnceUsedChecker;", "parameters", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Smart;", "Lkotlin/collections/LinkedHashMap;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/K1CodeFragmentParameterInfo;", "checkBounds", "", "descriptor", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "parameter", "doesCrossInlineBounds", "", "Lcom/intellij/psi/PsiElement;", "declaration", "getLabel", "", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isAssignmentLValue", "isCodeFragmentDeclaration", "isContainingPrimaryConstructorParameter", "target", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isFakeFunctionForJavaContext", "isPrimaryConstructorParameter", "processContextReceiver", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "processCoroutineContextCall", "processDebugLabel", "processDispatchReceiver", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "processExtensionReceiver", "label", "processFakeJavaCodeReceiver", "processReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "processSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "processSyntheticFieldVariable", "Lorg/jetbrains/kotlin/descriptors/impl/SyntheticFieldDescriptor;", "isInside", "parent", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentParameterAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentParameterAnalyzer.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,468:1\n372#2,7:469\n372#2,7:476\n372#2,7:484\n372#2,7:491\n372#2,7:498\n372#2,7:505\n372#2,7:512\n372#2,7:519\n372#2,7:526\n1#3:483\n125#4:533\n125#4:534\n*S KotlinDebug\n*F\n+ 1 CodeFragmentParameterAnalyzer.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer\n*L\n239#1:469,7\n254#1:476,7\n283#1:484,7\n298#1:491,7\n307#1:498,7\n326#1:505,7\n334#1:512,7\n372#1:519,7\n385#1:526,7\n408#1:533\n409#1:534\n*E\n"})
public final class CodeFragmentParameterAnalyzer {
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final LinkedHashMap<DeclarationDescriptor, CodeFragmentParameter.Smart> parameters;
    @NotNull
    private final Set<CodeFragmentParameter.Dumb> crossingBounds;
    @NotNull
    private final OnceUsedChecker onceUsedChecker;
    @NotNull
    private final Lazy containingPrimaryConstructor$delegate;

    public CodeFragmentParameterAnalyzer(@NotNull ExecutionContext context2, @NotNull KtCodeFragment codeFragment, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        this.context = context2;
        this.codeFragment = codeFragment;
        this.bindingContext = bindingContext2;
        this.parameters = new LinkedHashMap();
        this.crossingBounds = new LinkedHashSet();
        this.onceUsedChecker = new OnceUsedChecker(CodeFragmentParameterAnalyzer.class);
        this.containingPrimaryConstructor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConstructorDescriptor>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ConstructorDescriptor invoke() {
                PsiElement psiElement2;
                block7: {
                    block6: {
                        void $this$getParentOfType$iv;
                        Comparable<Location> comparable;
                        block5: {
                            block4: {
                                Comparable<Location> comparable2 = SafeUtilKt.safeLocation((StackFrameProxy)CodeFragmentParameterAnalyzer.access$getContext$p(this.this$0).getFrameProxy());
                                if (comparable2 == null || (comparable2 = SafeUtilKt.safeMethod((Location)comparable2)) == null) break block4;
                                Comparable<Location> it = comparable = comparable2;
                                boolean bl = false;
                                comparable2 = it.isConstructor() ? comparable : null;
                                if (comparable2 != null) break block5;
                            }
                            return null;
                        }
                        psiElement2 = CodeFragmentParameterAnalyzer.access$getCodeFragment$p(this.this$0).getContext();
                        if (psiElement2 == null) break block6;
                        comparable = psiElement2;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        psiElement2 = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrimaryConstructor.class, (boolean)strict$iv);
                        if (psiElement2 != null) break block7;
                    }
                    return null;
                }
                PsiElement constructor2 = psiElement2;
                return (ConstructorDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.CONSTRUCTOR, (Object)constructor2);
            }
        }));
    }

    private final ConstructorDescriptor getContainingPrimaryConstructor() {
        Lazy lazy = this.containingPrimaryConstructor$delegate;
        return (ConstructorDescriptor)lazy.getValue();
    }

    @NotNull
    public final K1CodeFragmentParameterInfo analyze() {
        this.onceUsedChecker.trigger();
        this.codeFragment.accept((KtVisitor)new KtTreeVisitor<Unit>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public Void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Unit data2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall2 == null) {
                    return null;
                }
                ResolvedCall resolvedCall3 = resolvedCall2;
                this.processResolvedCall(resolvedCall3, expression2);
                return null;
            }

            private final void processResolvedCall(ResolvedCall<?> resolvedCall2, KtSimpleNameExpression expression2) {
                CodeFragmentParameter.Smart parameter2;
                ReceiverParameterDescriptor extensionParameter;
                if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall2).getFunctionCall(), expression2);
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall2).getVariableCall(), expression2);
                    return;
                }
                CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
                analyze.1 var4_4 = this;
                CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this.this$0;
                analyze.1 $this$processResolvedCall_u24lambda_u240 = var4_4;
                boolean bl = false;
                CallableDescriptor callableDescriptor = descriptor2;
                DeclarationDescriptor declarationDescriptor = callableDescriptor != null ? callableDescriptor.getContainingDeclaration() : null;
                ClassDescriptor containingClass = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                CallableDescriptor callableDescriptor2 = descriptor2;
                Object object = extensionParameter = callableDescriptor2 != null ? callableDescriptor2.getExtensionReceiverParameter() : null;
                if (descriptor2 != null && !(descriptor2 instanceof DebuggerFieldPropertyDescriptor) && extensionParameter != null && containingClass != null && containingClass.getKind() != ClassKind.OBJECT) {
                    CodeFragmentParameter.Smart parameter3 = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(codeFragmentParameterAnalyzer, containingClass);
                    codeFragmentParameterAnalyzer.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression2, parameter3);
                }
                if (((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(expression2){
                    final /* synthetic */ KtSimpleNameExpression $expression;
                    {
                        this.$expression = $expression;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return KtPsiUtilKt.isDotSelector((KtExpression)((KtExpression)this.$expression));
                    }
                }))).booleanValue()) {
                    CallableDescriptor callableDescriptor3 = resolvedCall2.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor3, (String)"getResultingDescriptor(...)");
                    CodeFragmentParameter.Smart parameter4 = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, (DeclarationDescriptor)callableDescriptor3);
                    if (parameter4 != null) {
                        this.this$0.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression2, parameter4);
                    }
                }
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, (DeclarationDescriptor)descriptor2)) {
                    return;
                }
                Ref.BooleanRef processed = new Ref.BooleanRef();
                codeFragmentParameterAnalyzer = this.this$0;
                ResolvedCall<?> $this$processResolvedCall_u24lambda_u241 = resolvedCall2;
                boolean bl2 = false;
                analyze.1.processResolvedCall$processImplicitReceiver(codeFragmentParameterAnalyzer, descriptor2, expression2, processed, $this$processResolvedCall_u24lambda_u241.getDispatchReceiver());
                analyze.1.processResolvedCall$processImplicitReceiver(codeFragmentParameterAnalyzer, descriptor2, expression2, processed, $this$processResolvedCall_u24lambda_u241.getExtensionReceiver());
                List list2 = $this$processResolvedCall_u24lambda_u241.getContextReceivers();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContextReceivers(...)");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ReceiverValue p0 = (ReceiverValue)element$iv;
                    boolean bl3 = false;
                    analyze.1.processResolvedCall$processImplicitReceiver(codeFragmentParameterAnalyzer, descriptor2, expression2, processed, p0);
                }
                if (!processed.element && descriptor2 instanceof SyntheticFieldDescriptor) {
                    parameter2 = CodeFragmentParameterAnalyzer.access$processSyntheticFieldVariable(this.this$0, (SyntheticFieldDescriptor)descriptor2);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression2, parameter2);
                    processed.element = true;
                }
                if (!processed.element) {
                    Intrinsics.checkNotNull((Object)descriptor2);
                    parameter2 = this.processDescriptor((DeclarationDescriptor)descriptor2, expression2);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression2, parameter2);
                }
            }

            private final CodeFragmentParameter.Smart processDescriptor(DeclarationDescriptor descriptor2, KtSimpleNameExpression expression2) {
                CodeFragmentParameter.Smart smart = CodeFragmentParameterAnalyzer.access$processDebugLabel(this.this$0, descriptor2);
                if (smart == null && (smart = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, descriptor2)) == null) {
                    smart = CodeFragmentParameterAnalyzer.access$processSimpleNameExpression(this.this$0, descriptor2, expression2);
                }
                return smart;
            }

            @Nullable
            public Void visitThisExpression(@NotNull KtThisExpression expression2, @Nullable Unit data2) {
                CodeFragmentParameter.Smart smart;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<KtReferenceExpression>(expression2){
                    final /* synthetic */ KtThisExpression $expression;
                    {
                        this.$expression = $expression;
                        super(0);
                    }

                    @NotNull
                    public final KtReferenceExpression invoke() {
                        return this.$expression.getInstanceReference();
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                KtReferenceExpression instanceReference2 = (KtReferenceExpression)object;
                DeclarationDescriptor target2 = (DeclarationDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)instanceReference2);
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, target2)) {
                    return null;
                }
                DeclarationDescriptor declarationDescriptor = target2;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    smart = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(this.this$0, (ClassDescriptor)target2);
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression2);
                    if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getType()) == null) {
                        return null;
                    }
                    KotlinTypeInfo type2 = kotlinTypeInfo;
                    smart = CodeFragmentParameterAnalyzer.access$processContextReceiver(this.this$0, (CallableDescriptor)target2, (KotlinType)type2);
                    if (smart == null) {
                        smart = CodeFragmentParameterAnalyzer.access$processExtensionReceiver(this.this$0, (CallableDescriptor)target2, (KotlinType)type2, expression2.getLabelName());
                    }
                } else {
                    smart = null;
                }
                CodeFragmentParameter.Smart parameter2 = smart;
                this.this$0.checkBounds(target2, (KtExpression)expression2, parameter2);
                return null;
            }

            @Nullable
            public Void visitSuperExpression(@NotNull KtSuperExpression expression2, @Nullable Unit data2) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    KotlinType kotlinType = (KotlinType)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, (Object)expression2);
                    if (kotlinType == null) {
                        return null;
                    }
                    KotlinType type2 = kotlinType;
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        return null;
                    }
                    ClassDescriptor descriptor2 = classDescriptor;
                    Map $this$getOrPut$iv = CodeFragmentParameterAnalyzer.access$getParameters$p(this.this$0);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(descriptor2);
                    if (value$iv != null) break block2;
                    boolean bl = false;
                    String string = descriptor2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    String name2 = string;
                    CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "super@" + name2), type2, (DeclarationDescriptor)descriptor2, false, 8, null);
                    $this$getOrPut$iv.put(descriptor2, answer$iv);
                }
                return null;
            }

            @Nullable
            public Void visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Unit data2) {
                CallableDescriptor descriptor2;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression2), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall2 != null && (descriptor2 = resolvedCall2.getResultingDescriptor()) instanceof ConstructorDescriptor && KotlinBuiltIns.isNothing((KotlinType)((ConstructorDescriptor)descriptor2).getReturnType())) {
                    EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.nothing.initialization", new Object[0]));
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
                    throw (Throwable)evaluateException;
                }
                return (Void)super.visitCallExpression(expression2, (Object)data2);
            }

            private static final void processResolvedCall$processImplicitReceiver(CodeFragmentParameterAnalyzer this$0, CallableDescriptor descriptor2, KtSimpleNameExpression $expression, Ref.BooleanRef processed, ReceiverValue receiver2) {
                if (receiver2 instanceof ImplicitReceiver) {
                    CodeFragmentParameter.Smart parameter2;
                    Intrinsics.checkNotNull((Object)descriptor2);
                    if (!CodeFragmentParameterAnalyzer.access$isPrimaryConstructorParameter(this$0, (DeclarationDescriptor)descriptor2) && (parameter2 = CodeFragmentParameterAnalyzer.access$processReceiver(this$0, (ImplicitReceiver)receiver2)) != null) {
                        this$0.checkBounds(((ImplicitReceiver)receiver2).getDeclarationDescriptor(), (KtExpression)$expression, parameter2);
                        processed.element = true;
                    }
                }
            }
        }, (Object)Unit.INSTANCE);
        Collection<CodeFragmentParameter.Smart> collection = this.parameters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return new K1CodeFragmentParameterInfo(CollectionsKt.toList((Iterable)collection), this.crossingBounds);
    }

    private final CodeFragmentParameter.Smart processReceiver(ImplicitReceiver receiver2) {
        CodeFragmentParameter.Smart smart;
        if (this.isCodeFragmentDeclaration(receiver2.getDeclarationDescriptor())) {
            return null;
        }
        ImplicitReceiver implicitReceiver = receiver2;
        if (implicitReceiver instanceof ImplicitClassReceiver) {
            smart = this.processDispatchReceiver(((ImplicitClassReceiver)receiver2).getClassDescriptor());
        } else if (implicitReceiver instanceof ExtensionReceiver) {
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver2).getDeclarationDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"<get-declarationDescriptor>(...)");
            KotlinType kotlinType = ((ExtensionReceiver)receiver2).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            smart = this.processExtensionReceiver(callableDescriptor, kotlinType, null);
        } else if (implicitReceiver instanceof ContextReceiver) {
            CallableDescriptor callableDescriptor = ((ContextReceiver)receiver2).getDeclarationDescriptor();
            KotlinType kotlinType = ((ContextReceiver)receiver2).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            smart = this.processContextReceiver(callableDescriptor, kotlinType);
        } else {
            smart = implicitReceiver instanceof ContextClassReceiver ? this.processDispatchReceiver(((ContextClassReceiver)receiver2).getClassDescriptor()) : null;
        }
        return smart;
    }

    private final CodeFragmentParameter.Smart processDispatchReceiver(ClassDescriptor descriptor2) {
        Object object;
        if (descriptor2.getKind() == ClassKind.OBJECT) {
            return null;
        }
        SimpleType simpleType = descriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        SimpleType type2 = simpleType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            Name name2 = descriptor2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            Name name3 = name2;
            String debugLabel = name3.isSpecial() ? "" : "@" + name3.asString();
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "this" + debugLabel), (KotlinType)type2, (DeclarationDescriptor)descriptor2, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processExtensionReceiver(CallableDescriptor descriptor2, KotlinType receiverType2, String label2) {
        Object object;
        if (this.isFakeFunctionForJavaContext(descriptor2)) {
            return this.processFakeJavaCodeReceiver(descriptor2);
        }
        String string = label2;
        if (string == null) {
            string = this.getLabel(descriptor2);
        }
        String actualLabel = string;
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.EXTENSION_RECEIVER, actualLabel, "this@" + actualLabel), receiverType2, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final String getLabel(CallableDescriptor callableDescriptor) {
        Object object;
        SourceElement sourceElement = callableDescriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement source = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        if (source instanceof KtFunctionLiteral && (object = CodegenUtilKt.getCallLabelForLambdaArgument((KtFunctionLiteral)((KtFunctionLiteral)source), (BindingContext)this.bindingContext)) != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        Name it = object = callableDescriptor.getName();
        boolean bl = false;
        return String.valueOf(!it.isSpecial() ? object : null);
    }

    private final boolean isFakeFunctionForJavaContext(CallableDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"_java_locals_debug_fun_") && this.codeFragment.getCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE()) != null;
    }

    private final CodeFragmentParameter.Smart processContextReceiver(CallableDescriptor descriptor2, KotlinType receiverType2) {
        Object object;
        Object v1;
        block4: {
            List list2 = descriptor2.getContextReceiverParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContextReceiverParameters(...)");
            Iterable iterable = list2;
            for (Object t : iterable) {
                ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)receiverType2)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = v1;
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(receiverParameter);
        if (value$iv == null) {
            boolean bl = false;
            String string = receiverParameter.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String name2 = string;
            FqName fqName2 = FqNameUtilKt.getFqName(receiverType2);
            String label2 = ThisLabelUtilsKt.getThisName(String.valueOf(fqName2 != null ? fqName2.shortName() : null));
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.CONTEXT_RECEIVER, name2, label2), receiverType2, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(receiverParameter, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processFakeJavaCodeReceiver(CallableDescriptor descriptor2) {
        Object object;
        CallableDescriptor callableDescriptor;
        CallableDescriptor callableDescriptor2;
        CallableDescriptor it = callableDescriptor2 = descriptor2;
        boolean bl = false;
        Object object2 = callableDescriptor = descriptor2 instanceof FunctionDescriptor ? callableDescriptor2 : null;
        if (callableDescriptor == null || (callableDescriptor2 = callableDescriptor.getExtensionReceiverParameter()) == null) {
            return null;
        }
        CallableDescriptor receiverParameter = callableDescriptor2;
        String label2 = "_java_locals_debug_fun_";
        KotlinType kotlinType = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType type2 = kotlinType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl2 = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS, label2, "this"), type2, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSyntheticFieldVariable(SyntheticFieldDescriptor descriptor2) {
        Object object;
        PropertyDescriptor propertyDescriptor = descriptor2.getPropertyDescriptor();
        String string = propertyDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fieldName = string;
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType type2 = kotlinType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FIELD_VAR, fieldName, "field"), type2, (DeclarationDescriptor)descriptor2, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSimpleNameExpression(DeclarationDescriptor target2, KtSimpleNameExpression expression2) {
        CodeFragmentParameter.Smart smart;
        if (target2 instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)target2).isCrossinline()) {
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.crossinline.lambda.evaluation", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
            throw (Throwable)evaluateException;
        }
        if (!this.isPrimaryConstructorParameter(target2)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = target2;
        if (declarationDescriptor instanceof SimpleFunctionDescriptor) {
            Object object;
            KotlinType kotlinType = FunctionsTypingVisitorKt.createFunctionType$default((SimpleFunctionDescriptor)((SimpleFunctionDescriptor)target2), (KotlinBuiltIns)DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)target2), (boolean)((SimpleFunctionDescriptor)target2).isSuspend(), (boolean)false, (int)4, null);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target2);
            if (value$iv == null) {
                boolean bl = false;
                String string = ((SimpleFunctionDescriptor)target2).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.LOCAL_FUNCTION, string, null, 4, null);
                SimpleFunctionDescriptor simpleFunctionDescriptor = ((SimpleFunctionDescriptor)target2).getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"getOriginal(...)");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, type2, (DeclarationDescriptor)simpleFunctionDescriptor, false, 8, null);
                $this$getOrPut$iv.put(target2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else if (declarationDescriptor instanceof ValueDescriptor) {
            Object object;
            boolean bl;
            KtExpression unwrappedExpression;
            KtExpression ktExpression = unwrappedExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)expression2));
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl2 = false;
                bl = this.isAssignmentLValue((PsiElement)it);
            } else {
                bl = false;
            }
            boolean isLValue = bl;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target2);
            if (value$iv == null) {
                boolean bl3 = false;
                CodeFragmentParameter.Kind kind2 = target2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)target2).isDelegated() ? CodeFragmentParameter.Kind.DELEGATED : CodeFragmentParameter.Kind.ORDINARY;
                String string = ((ValueDescriptor)target2).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(kind2, string, null, 4, null);
                KotlinType kotlinType = ((ValueDescriptor)target2).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, kotlinType, target2, isLValue);
                $this$getOrPut$iv.put(target2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else {
            smart = null;
        }
        return smart;
    }

    private final boolean isPrimaryConstructorParameter(DeclarationDescriptor target2) {
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = target2 instanceof DeclarationDescriptorWithVisibility ? (DeclarationDescriptorWithVisibility)target2 : null;
        boolean isLocalTarget = Intrinsics.areEqual((Object)(declarationDescriptorWithVisibility != null ? declarationDescriptorWithVisibility.getVisibility() : null), (Object)DescriptorVisibilities.LOCAL);
        boolean isPrimaryConstructorParameter = !isLocalTarget && target2 instanceof PropertyDescriptor && this.isContainingPrimaryConstructorParameter((PropertyDescriptor)target2);
        return isLocalTarget || isPrimaryConstructorParameter;
    }

    private final boolean isAssignmentLValue(PsiElement expression2) {
        Object object;
        block3: {
            block2: {
                KtBinaryExpression ktBinaryExpression;
                PsiElement psiElement2 = expression2.getParent();
                object = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
                if (object == null) break block2;
                KtBinaryExpression it = ktBinaryExpression = object;
                boolean bl = false;
                object = KtPsiUtil.isAssignment((PsiElement)((PsiElement)it)) ? ktBinaryExpression : null;
                if (object != null) break block3;
            }
            return false;
        }
        KtBinaryExpression assignmentExpression2 = object;
        return Intrinsics.areEqual((Object)assignmentExpression2.getLeft(), (Object)expression2);
    }

    private final boolean isContainingPrimaryConstructorParameter(PropertyDescriptor target2) {
        ConstructorDescriptor constructorDescriptor = this.getContainingPrimaryConstructor();
        if (constructorDescriptor == null) {
            return false;
        }
        ConstructorDescriptor primaryConstructor = constructorDescriptor;
        for (ValueParameterDescriptor parameter2 : primaryConstructor.getValueParameters()) {
            PropertyDescriptor property2 = (PropertyDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.VALUE_PARAMETER_AS_PROPERTY, (Object)parameter2);
            if (!Intrinsics.areEqual((Object)target2, (Object)property2)) continue;
            return true;
        }
        return false;
    }

    private final CodeFragmentParameter.Smart processCoroutineContextCall(DeclarationDescriptor target2) {
        if (target2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)target2), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_FQ_NAME())) {
            Object object;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target2);
            if (value$iv == null) {
                boolean bl = false;
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.COROUTINE_CONTEXT, "", null, 4, null);
                KotlinType kotlinType = ((PropertyDescriptor)target2).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, kotlinType, target2, false, 8, null);
                $this$getOrPut$iv.put(target2, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (CodeFragmentParameter.Smart)object;
        }
        return null;
    }

    private final CodeFragmentParameter.Smart processDebugLabel(DeclarationDescriptor target2) {
        Object object;
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor = target2 instanceof DebugLabelPropertyDescriptor ? (DebugLabelPropertyDescriptor)target2 : null;
        if (debugLabelPropertyDescriptor == null) {
            return null;
        }
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor2 = debugLabelPropertyDescriptor;
        String labelName2 = debugLabelPropertyDescriptor2.getLabelName();
        String string = debugLabelPropertyDescriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String debugString = string;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(target2);
        if (value$iv == null) {
            boolean bl = false;
            KotlinType kotlinType = debugLabelPropertyDescriptor2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType type2 = kotlinType;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DEBUG_LABEL, labelName2, debugString), type2, (DeclarationDescriptor)debugLabelPropertyDescriptor2, false, 8, null);
            $this$getOrPut$iv.put(target2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    public final void checkBounds(@Nullable DeclarationDescriptor descriptor2, @NotNull KtExpression expression2, @Nullable CodeFragmentParameter.Smart parameter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (parameter2 == null || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement targetPsi = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        if (targetPsi != null && this.doesCrossInlineBounds((PsiElement)expression2, targetPsi)) {
            ((Collection)this.crossingBounds).add(parameter2.getDumb());
        }
    }

    private final boolean doesCrossInlineBounds(PsiElement expression2, PsiElement declaration2) {
        Object object;
        PsiElement declarationCommonParent;
        block7: {
            block6: {
                PsiElement psiElement2;
                PsiElement psiElement3 = CodeFragmentParameterAnalyzer.doesCrossInlineBounds$findCommonParent(declaration2);
                if (psiElement3 == null) {
                    return false;
                }
                declarationCommonParent = psiElement3;
                object = expression2.getParent();
                if (object == null) break block6;
                PsiElement it = psiElement2 = object;
                boolean bl = false;
                object = this.isInside(it, declarationCommonParent) ? psiElement2 : null;
                if (object != null) break block7;
            }
            return false;
        }
        PsiElement currentParent = object;
        while (currentParent != null && !Intrinsics.areEqual((Object)currentParent, (Object)declarationCommonParent)) {
            SimpleFunctionDescriptor functionDescriptor2;
            if (currentParent instanceof KtFunction && (functionDescriptor2 = (SimpleFunctionDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)currentParent)) != null && !functionDescriptor2.isInline()) {
                return true;
            }
            currentParent = currentParent instanceof KtCodeFragment ? ((KtCodeFragment)currentParent).getContext() : currentParent.getParent();
        }
        return false;
    }

    private final boolean isCodeFragmentDeclaration(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ValueParameterDescriptor && this.isCodeFragmentDeclaration((DeclarationDescriptor)((ValueParameterDescriptor)descriptor2).getContainingDeclaration())) {
            return true;
        }
        if (!(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return false;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement2 = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        return (psiElement2 != null ? psiElement2.getContainingFile() : null) instanceof KtCodeFragment;
    }

    private final boolean isInside(PsiElement $this$isInside, PsiElement parent2) {
        while (!PsiUtilsKt.isAncestor$default((PsiElement)parent2, (PsiElement)$this$isInside, (boolean)false, (int)2, null)) {
            PsiFile psiFile2 = $this$isInside.getContainingFile();
            KtCodeFragment ktCodeFragment = psiFile2 instanceof KtCodeFragment ? (KtCodeFragment)psiFile2 : null;
            if (ktCodeFragment == null || (ktCodeFragment = ktCodeFragment.getContext()) == null) {
                return false;
            }
            KtCodeFragment context2 = ktCodeFragment;
            CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this_;
            psiFile2 = parent2;
            CodeFragmentParameterAnalyzer this_ = codeFragmentParameterAnalyzer;
            $this$isInside = context2;
            parent2 = psiFile2;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiElement doesCrossInlineBounds$findCommonParent(PsiElement declaration2) {
        PsiElement psiElement2;
        PsiElement declarationParent = declaration2.getParent();
        if (declarationParent instanceof KtDestructuringDeclaration) {
            void $this$getParentOfType$iv;
            PsiElement psiElement3 = declarationParent;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtBlockExpression.class, (boolean)strict$iv);
        } else if (declarationParent instanceof KtParameterList && ((KtParameterList)declarationParent).getParent() instanceof KtPrimaryConstructor) {
            PsiElement $this$getParentOfType$iv = declaration2;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
        } else {
            psiElement2 = declarationParent instanceof KtParameterList && ((KtParameterList)declarationParent).getParent() instanceof KtFunction ? ((KtParameterList)declarationParent).getParent() : declarationParent;
        }
        return psiElement2;
    }

    public static final /* synthetic */ BindingContext access$getBindingContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.bindingContext;
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processCoroutineContextCall(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target2) {
        return $this.processCoroutineContextCall(target2);
    }

    public static final /* synthetic */ boolean access$isCodeFragmentDeclaration(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor descriptor2) {
        return $this.isCodeFragmentDeclaration(descriptor2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSyntheticFieldVariable(CodeFragmentParameterAnalyzer $this, SyntheticFieldDescriptor descriptor2) {
        return $this.processSyntheticFieldVariable(descriptor2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDebugLabel(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target2) {
        return $this.processDebugLabel(target2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSimpleNameExpression(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target2, KtSimpleNameExpression expression2) {
        return $this.processSimpleNameExpression(target2, expression2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDispatchReceiver(CodeFragmentParameterAnalyzer $this, ClassDescriptor descriptor2) {
        return $this.processDispatchReceiver(descriptor2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processContextReceiver(CodeFragmentParameterAnalyzer $this, CallableDescriptor descriptor2, KotlinType receiverType2) {
        return $this.processContextReceiver(descriptor2, receiverType2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processExtensionReceiver(CodeFragmentParameterAnalyzer $this, CallableDescriptor descriptor2, KotlinType receiverType2, String label2) {
        return $this.processExtensionReceiver(descriptor2, receiverType2, label2);
    }

    public static final /* synthetic */ LinkedHashMap access$getParameters$p(CodeFragmentParameterAnalyzer $this) {
        return $this.parameters;
    }

    public static final /* synthetic */ boolean access$isPrimaryConstructorParameter(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target2) {
        return $this.isPrimaryConstructorParameter(target2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processReceiver(CodeFragmentParameterAnalyzer $this, ImplicitReceiver receiver2) {
        return $this.processReceiver(receiver2);
    }

    public static final /* synthetic */ ExecutionContext access$getContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.context;
    }

    public static final /* synthetic */ KtCodeFragment access$getCodeFragment$p(CodeFragmentParameterAnalyzer $this) {
        return $this.codeFragment;
    }
}

