/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.similarity;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.usages.similarity.bag.Bag;
import com.intellij.usages.similarity.features.UsageSimilarityFeaturesRecorder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\rH\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u00020\r2\u0006\u0010'\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0010\u0010.\u001a\u00020\r2\u0006\u0010'\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\r2\u0006\u0010'\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u00106\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u00107\u001a\u00020\r2\u0006\u0010'\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\r2\u0006\u0010'\u001a\u00020=H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/similarity/KotlinSimilarityFeaturesExtractor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "element", "Lcom/intellij/psi/PsiElement;", "context", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "usageSimilarityFeaturesRecorder", "Lcom/intellij/usages/similarity/features/UsageSimilarityFeaturesRecorder;", "variableNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "collectDestructuringDeclarationNames", "", "destructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "collectForExpressionParameterName", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "collectFunctionParametersNames", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "collectParameterNames", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "collectPropertyName", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "collectVariableNames", "collectVariableNamesFromBlock", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "untilOffset", "", "collectWhenExpressionParameterName", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "fieldOrMethodReference", "", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "getFeatures", "Lcom/intellij/usages/similarity/bag/Bag;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBlockExpression", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitProperty", "visitReferenceExpression", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitTypeReference", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinSimilarityFeaturesExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSimilarityFeaturesExtractor.kt\norg/jetbrains/kotlin/idea/findUsages/similarity/KotlinSimilarityFeaturesExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class KotlinSimilarityFeaturesExtractor
extends KtTreeVisitorVoid {
    @NotNull
    private final PsiElement context;
    @NotNull
    private final UsageSimilarityFeaturesRecorder usageSimilarityFeaturesRecorder;
    @NotNull
    private final HashSet<String> variableNames;

    public KotlinSimilarityFeaturesExtractor(@NotNull PsiElement element3, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.usageSimilarityFeaturesRecorder = new UsageSimilarityFeaturesRecorder(this.context, element3);
        this.variableNames = new HashSet();
    }

    @NotNull
    public final Bag getFeatures() {
        this.collectVariableNames();
        this.context.accept((PsiElementVisitor)this);
        Bag bag = this.usageSimilarityFeaturesRecorder.getFeatures();
        Intrinsics.checkNotNullExpressionValue((Object)bag, (String)"getFeatures(...)");
        return bag;
    }

    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, "literal: string");
        super.visitStringTemplateExpression(expression2);
    }

    public void visitProperty(@NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)property2, "PROPERTY: ");
        super.visitProperty(property2);
    }

    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression calleeExpression2 = expression2.getCalleeExpression();
        if (calleeExpression2 instanceof KtNameReferenceExpression) {
            this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, "{CALL: " + ((KtNameReferenceExpression)calleeExpression2).getReferencedName() + "}");
        }
        super.visitCallExpression(expression2);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, expression2.getOperationToken().toString());
        super.visitBinaryExpression(expression2);
    }

    public void visitIsExpression(@NotNull KtIsExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, "instanceof");
        super.visitIsExpression(expression2);
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression2) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpression2, (String)"lambdaExpression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)lambdaExpression2, "lambda");
        super.visitLambdaExpression(lambdaExpression2);
    }

    public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, expression2.getOperationToken().toString());
        super.visitUnaryExpression(expression2);
    }

    public void visitTypeReference(@NotNull KtTypeReference typeReference2) {
        Intrinsics.checkNotNullParameter((Object)typeReference2, (String)"typeReference");
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)typeReference2, "TYPE: " + typeReference2.nameForReceiverLabel());
        super.visitTypeReference(typeReference2);
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        PsiElement parent2 = expression2.getParent();
        String feature = (this.fieldOrMethodReference(expression2) || parent2 instanceof KtUserType) && expression2 instanceof KtNameReferenceExpression ? "{REFERENCE: " + ((KtNameReferenceExpression)expression2).getReferencedName() + "}" : "REFERENCE: ";
        this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, feature);
        super.visitReferenceExpression(expression2);
    }

    public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getParent() instanceof KtContainerNodeForControlStructureBody && expression2.getStatements().size() > 1) {
            this.usageSimilarityFeaturesRecorder.addAllFeatures((PsiElement)expression2, "COMPLEX_BODY");
        } else {
            super.visitBlockExpression(expression2);
        }
    }

    private final boolean fieldOrMethodReference(KtReferenceExpression expression2) {
        return expression2 instanceof KtNameReferenceExpression && !this.variableNames.contains(((KtNameReferenceExpression)expression2).getReferencedName());
    }

    private final void collectVariableNames() {
        PsiElement currentElement = this.context;
        while (!(currentElement instanceof PsiFile) && currentElement.getParent() != null) {
            PsiElement parent2;
            int startOffsetInParent = currentElement.getStartOffsetInParent();
            PsiElement psiElement2 = parent2;
            if (psiElement2 instanceof KtBlockExpression) {
                this.collectVariableNamesFromBlock((KtBlockExpression)parent2, startOffsetInParent);
            } else if (psiElement2 instanceof KtFunction) {
                this.collectFunctionParametersNames((KtFunction)parent2);
            } else if (psiElement2 instanceof KtWhenExpression) {
                this.collectWhenExpressionParameterName((KtWhenExpression)parent2);
            } else if (psiElement2 instanceof KtForExpression) {
                this.collectForExpressionParameterName((KtForExpression)parent2);
            }
            currentElement = parent2;
        }
    }

    private final void collectForExpressionParameterName(KtForExpression forExpression) {
        block0: {
            KtParameter ktParameter = forExpression.getLoopParameter();
            if (ktParameter == null) break block0;
            KtParameter p0 = ktParameter;
            boolean bl = false;
            this.collectParameterNames(p0);
        }
    }

    private final void collectWhenExpressionParameterName(KtWhenExpression whenExpression2) {
        KtExpression ktExpression = whenExpression2.getSubjectExpression();
        KtProperty ktProperty = ktExpression instanceof KtProperty ? (KtProperty)ktExpression : null;
        if (ktProperty == null) {
            return;
        }
        KtProperty property2 = ktProperty;
        this.collectPropertyName(property2);
    }

    private final void collectVariableNamesFromBlock(KtBlockExpression blockExpression2, int untilOffset) {
        KtExpression statement2;
        Iterator iterator2 = blockExpression2.getStatements().iterator();
        while (iterator2.hasNext() && (statement2 = (KtExpression)iterator2.next()).getStartOffsetInParent() < untilOffset) {
            KtExpression ktExpression = statement2;
            if (ktExpression instanceof KtProperty) {
                Intrinsics.checkNotNull((Object)statement2);
                this.collectPropertyName((KtProperty)statement2);
                continue;
            }
            if (!(ktExpression instanceof KtDestructuringDeclaration)) continue;
            Intrinsics.checkNotNull((Object)statement2);
            this.collectDestructuringDeclarationNames((KtDestructuringDeclaration)statement2);
        }
    }

    private final void collectDestructuringDeclarationNames(KtDestructuringDeclaration destructuringDeclaration) {
        for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
            String string;
            if (entry.getName() == null) continue;
            HashSet<String> hashSet = this.variableNames;
            String p0 = string;
            boolean bl = false;
            hashSet.add(p0);
        }
    }

    private final void collectFunctionParametersNames(KtFunction function2) {
        if (function2 instanceof KtFunctionLiteral) {
            ((Collection)this.variableNames).add(StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier());
        }
        for (KtParameter valueParameter2 : function2.getValueParameters()) {
            Intrinsics.checkNotNull((Object)valueParameter2);
            this.collectParameterNames(valueParameter2);
        }
    }

    private final void collectParameterNames(KtParameter parameter2) {
        block1: {
            String string = parameter2.getName();
            if (string != null) {
                String string2 = string;
                HashSet<String> hashSet = this.variableNames;
                String p0 = string2;
                boolean bl = false;
                hashSet.add(p0);
            }
            KtDestructuringDeclaration ktDestructuringDeclaration = parameter2.getDestructuringDeclaration();
            if (ktDestructuringDeclaration == null) break block1;
            KtDestructuringDeclaration p0 = ktDestructuringDeclaration;
            boolean bl = false;
            this.collectDestructuringDeclarationNames(p0);
        }
    }

    private final void collectPropertyName(KtProperty property2) {
        block0: {
            String string = property2.getName();
            if (string == null) break block0;
            String string2 = string;
            HashSet<String> hashSet = this.variableNames;
            String p0 = string2;
            boolean bl = false;
            hashSet.add(p0);
        }
    }
}

