/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.utils.DebugInfoUtil;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinHighlightingUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.highlighter.AbstractBindingContextAwareHighlightingPassBase;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass;", "Lorg/jetbrains/kotlin/idea/highlighter/AbstractBindingContextAwareHighlightingPassBase;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "Factory", "Registrar", "kotlin.highlighting.k1"})
@SourceDebugExtension(value={"SMAP\nDebugInfoHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugInfoHighlightingPass.kt\norg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class DebugInfoHighlightingPass
extends AbstractBindingContextAwareHighlightingPassBase {
    public DebugInfoHighlightingPass(@NotNull KtFile file2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(file2, document);
    }

    @Override
    public void annotate(@NotNull PsiElement element3, @NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element3 instanceof KtFile && !(element3 instanceof KtCodeFragment)) {
            try {
                DebugInfoUtil.INSTANCE.markDebugAnnotations(element3, this.bindingContext(), new DebugInfoUtil.DebugInfoReporter(holder){
                    final /* synthetic */ HighlightInfoHolder $holder;
                    {
                        this.$holder = $holder;
                    }

                    public void reportElementWithErrorType(@NotNull KtReferenceExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        DebugInfoHighlightingPass.access$annotate$errorAnnotation(this.$holder, (PsiElement)expression2, "Resolved to error element", KotlinHighlightingColors.RESOLVED_TO_ERROR);
                    }

                    public void reportMissingUnresolved(@NotNull KtReferenceExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        DebugInfoHighlightingPass.annotate$errorAnnotation$default(this.$holder, (PsiElement)expression2, "Reference is not resolved to anything, but is not marked unresolved", null, 8, null);
                    }

                    public void reportUnresolvedWithTarget(@NotNull KtReferenceExpression expression2, @NotNull String target2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
                        DebugInfoHighlightingPass.annotate$errorAnnotation$default(this.$holder, (PsiElement)expression2, "Reference marked as unresolved is actually resolved to " + target2, null, 8, null);
                    }
                });
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                DebugInfoHighlightingPass.annotate$errorAnnotation(holder, element3, e.getClass().getCanonicalName() + ": " + e.getMessage(), null);
                e.printStackTrace();
            }
        }
    }

    private static final void annotate$errorAnnotation(HighlightInfoHolder $holder, PsiElement expression2, String message2, TextAttributesKey textAttributes) {
        HighlightInfo.Builder builder2;
        HighlightInfo.Builder it = builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip("[DEBUG] " + message2).range(expression2.getTextRange());
        boolean bl = false;
        TextAttributesKey textAttributesKey = textAttributes;
        if (textAttributesKey != null) {
            TextAttributesKey ta = textAttributesKey;
            boolean bl2 = false;
            it.textAttributes(ta);
        }
        HighlightInfo info2 = builder2.create();
        $holder.add(info2);
    }

    static /* synthetic */ void annotate$errorAnnotation$default(HighlightInfoHolder highlightInfoHolder, PsiElement psiElement2, String string, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 8) != 0) {
            textAttributesKey = KotlinHighlightingColors.DEBUG_INFO;
        }
        DebugInfoHighlightingPass.annotate$errorAnnotation(highlightInfoHolder, psiElement2, string, textAttributesKey);
    }

    public static final /* synthetic */ void access$annotate$errorAnnotation(HighlightInfoHolder $holder, PsiElement expression2, String message2, TextAttributesKey textAttributes) {
        DebugInfoHighlightingPass.annotate$errorAnnotation($holder, expression2, message2, textAttributes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Factory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.highlighting.k1"})
    @SourceDebugExtension(value={"SMAP\nDebugInfoHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugInfoHighlightingPass.kt\norg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Factory\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,103:1\n77#2,9:104\n*S KotlinDebug\n*F\n+ 1 DebugInfoHighlightingPass.kt\norg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Factory\n*L\n84#1:104,9\n*E\n"})
    public static final class Factory
    implements TextEditorHighlightingPassFactory {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (!(file2 instanceof KtFile)) return null;
            if (((KtFile)file2).isCompiled()) return null;
            if (!KotlinHighlightingUtils.shouldHighlightErrors((KtFile)file2)) return null;
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                boolean $i$f$isApplicationInternalMode = false;
                if (!ApplicationManager.getApplication().isInternal()) return null;
                if (!KotlinIdePlugin.INSTANCE.isSnapshot()) {
                    if (!KotlinIdePlugin.INSTANCE.isDev()) return null;
                }
            }
            if (!SourceKindFilterUtils.matches(RootKindFilter.projectAndLibrarySources, (PsiElement)file2)) return null;
            boolean bl = true;
            boolean useDebugInfoPass = bl;
            if (!useDebugInfoPass) return null;
            KtFile ktFile = (KtFile)file2;
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            TextEditorHighlightingPass textEditorHighlightingPass = new DebugInfoHighlightingPass(ktFile, document);
            return textEditorHighlightingPass;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/DebugInfoHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.highlighting.k1"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            int[] nArray = new int[]{4};
            registrar2.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new Factory(), nArray, null, false, -1);
        }
    }
}

