/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.util.OperatorChecks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddOperatorModifierInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "kotlin.idea"})
public final class AddOperatorModifierInspection
extends AbstractApplicabilityBasedInspection<KtNamedFunction> {
    public AddOperatorModifierInspection() {
        super(KtNamedFunction.class);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtNamedFunction element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return ExpressionExtKt.nameIdentifierTextRangeInThis((KtNamedDeclaration)element3);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtNamedFunction element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("function.should.have.operator.modifier", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("add.operator.modifier", new Object[0]);
    }

    @Override
    public boolean isApplicable(@NotNull KtNamedFunction element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (element3.getNameIdentifier() == null || element3.hasModifier(KtTokens.OPERATOR_KEYWORD)) {
            return false;
        }
        FunctionDescriptor functionDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        return !functionDescriptor3.isOperator() && OperatorChecks.INSTANCE.check(functionDescriptor3).isSuccess();
    }

    @Override
    public void applyTo(@NotNull KtNamedFunction element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List<KtDeclaration> declarations2 = ExpectActualUtilKt.withExpectedActuals((KtDeclaration)element3);
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(declarations2){
            final /* synthetic */ List<KtDeclaration> $declarations;
            {
                this.$declarations = $declarations;
                super(0);
            }

            public final void invoke() {
                for (KtDeclaration declaration2 : this.$declarations) {
                    declaration2.addModifier(KtTokens.OPERATOR_KEYWORD);
                }
            }
        }));
    }
}

