/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a+\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\u0007\u001a \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"fixesWithWholeProject", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "isOnTheFly", "", "fix", "wholeProjectFix", "(ZLcom/intellij/codeInspection/LocalQuickFix;Lcom/intellij/codeInspection/LocalQuickFix;)[Lcom/intellij/codeInspection/LocalQuickFix;", "isTopLevelCallForReplace", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "oldFqName", "", "newFqName", "kotlin.idea"})
public final class ObsoleteExperimentalCoroutinesInspectionKt {
    private static final boolean isTopLevelCallForReplace(KtSimpleNameExpression simpleNameExpression, String oldFqName, String newFqName) {
        if (!(simpleNameExpression.getParent() instanceof KtCallExpression)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)simpleNameExpression));
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        CallableDescriptor callableDescriptor = descriptor2 instanceof CallableDescriptor ? (CallableDescriptor)descriptor2 : null;
        if (callableDescriptor == null) {
            return false;
        }
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        Object object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor2));
        if (object == null || (object = object.asString()) == null) {
            return false;
        }
        Object resolvedToFqName = object;
        if (!Intrinsics.areEqual((Object)resolvedToFqName, (Object)oldFqName)) {
            return false;
        }
        Project project2 = simpleNameExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project3);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        boolean isInIndex = KotlinTopLevelFunctionFqnNameIndex.Helper.get(newFqName, project3, globalSearchScope).isEmpty();
        return !isInIndex;
    }

    @NotNull
    public static final LocalQuickFix[] fixesWithWholeProject(boolean isOnTheFly, @NotNull LocalQuickFix fix3, @NotNull LocalQuickFix wholeProjectFix) {
        Intrinsics.checkNotNullParameter((Object)fix3, (String)"fix");
        Intrinsics.checkNotNullParameter((Object)wholeProjectFix, (String)"wholeProjectFix");
        if (!isOnTheFly) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix3};
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix3, wholeProjectFix};
        return localQuickFixArray;
    }

    public static final /* synthetic */ boolean access$isTopLevelCallForReplace(KtSimpleNameExpression simpleNameExpression, String oldFqName, String newFqName) {
        return ObsoleteExperimentalCoroutinesInspectionKt.isTopLevelCallForReplace(simpleNameExpression, oldFqName, newFqName);
    }
}

