/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.processor;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.lifetime.KtReadActionConfinementLifetimeToken;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUsageUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J*\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0014\u0010\u001d\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0010H\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2MoveFilesHandler;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFileHandler;", "()V", "requiresPackageUpdate", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "getRequiresPackageUpdate", "(Lorg/jetbrains/kotlin/psi/KtFile;)Z", "canProcessElement", "element", "Lcom/intellij/psi/PsiFile;", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "psiFile", "newParent", "Lcom/intellij/psi/PsiDirectory;", "searchInComments", "searchInNonJavaFiles", "prepareMovedFile", "", "file", "moveDestination", "oldToNewMap", "", "Lcom/intellij/psi/PsiElement;", "retargetUsages", "usageInfos", "updateMovedFile", "updatePackageDirective", "destination", "kotlin.refactorings.move.k2"})
@SourceDebugExtension(value={"SMAP\nK2MoveFilesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveFilesHandler.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2MoveFilesHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtReadActionConfinementLifetimeToken.kt\norg/jetbrains/kotlin/analysis/api/lifetime/KtReadActionConfinementLifetimeTokenKt\n*L\n1#1,63:1\n1#2:64\n1855#3,2:65\n101#4,6:67\n*S KotlinDebug\n*F\n+ 1 K2MoveFilesHandler.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/K2MoveFilesHandler\n*L\n38#1:65,2\n60#1:67,6\n*E\n"})
public final class K2MoveFilesHandler
extends MoveFileHandler {
    public boolean canProcessElement(@NotNull PsiFile element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return element3 instanceof KtFile;
    }

    @NotNull
    public List<UsageInfo> findUsages(@NotNull PsiFile psiFile2, @NotNull PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        List<UsageInfo> list2;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)newParent, (String)"newParent");
        if (!(psiFile2 instanceof KtFile)) {
            boolean bl = false;
            String string = "Can only find usages from Kotlin files";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getRequiresPackageUpdate((KtFile)psiFile2)) {
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(newParent);
            if (psiPackage == null || (psiPackage = JavaPsiUtils.getKotlinFqName((PsiElement)psiPackage)) == null) {
                return CollectionsKt.emptyList();
            }
            PsiPackage newPkgName = psiPackage;
            list2 = MoveUsageUtilKt.findUsages((KtDeclarationContainer)psiFile2, searchInComments, searchInNonJavaFiles, (FqName)newPkgName);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public void prepareMovedFile(@NotNull PsiFile file2, @NotNull PsiDirectory moveDestination, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)moveDestination, (String)"moveDestination");
        Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
        if (!(file2 instanceof KtFile)) {
            boolean $i$a$-require-K2MoveFilesHandler$prepareMovedFile$22 = false;
            String $i$a$-require-K2MoveFilesHandler$prepareMovedFile$22 = "Can only prepare Kotlin files";
            throw new IllegalArgumentException($i$a$-require-K2MoveFilesHandler$prepareMovedFile$22.toString());
        }
        if (this.getRequiresPackageUpdate((KtFile)file2)) {
            this.updatePackageDirective((KtFile)file2, moveDestination);
        }
        List<KtNamedDeclaration> declarations2 = MoveUsageUtilKt.getAllDeclarationsToUpdate((KtDeclarationContainer)file2);
        Iterable $this$forEach$iv = declarations2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl = false;
            oldToNewMap.put((PsiElement)it, (PsiElement)it);
        }
    }

    private final boolean getRequiresPackageUpdate(KtFile $this$requiresPackageUpdate) {
        PsiPackage directoryPkg;
        PsiDirectory psiDirectory = $this$requiresPackageUpdate.getContainingDirectory();
        if (psiDirectory == null) {
            return true;
        }
        PsiDirectory containingDirectory = psiDirectory;
        PsiPackage psiPackage = directoryPkg = JavaDirectoryService.getInstance().getPackage(containingDirectory);
        return Intrinsics.areEqual((Object)(psiPackage != null ? JavaPsiUtils.getKotlinFqName((PsiElement)psiPackage) : null), (Object)$this$requiresPackageUpdate.getPackageFqName());
    }

    private final void updatePackageDirective(KtFile $this$updatePackageDirective, PsiDirectory destination) {
        block2: {
            PsiPackage newPackageName;
            block1: {
                PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(destination);
                if (psiPackage == null || (psiPackage = JavaPsiUtils.getKotlinFqName((PsiElement)psiPackage)) == null) {
                    return;
                }
                newPackageName = psiPackage;
                if (!newPackageName.isRoot()) break block1;
                KtPackageDirective ktPackageDirective = $this$updatePackageDirective.getPackageDirective();
                if (ktPackageDirective == null) break block2;
                ktPackageDirective.delete();
                break block2;
            }
            Project project2 = $this$updatePackageDirective.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KtPackageDirective newPackageDirective = new KtPsiFactory(project2, false, 2, null).createPackageDirective((FqName)newPackageName);
            KtPackageDirective ktPackageDirective = $this$updatePackageDirective.getPackageDirective();
            if (ktPackageDirective == null) break block2;
            ktPackageDirective.replace((PsiElement)newPackageDirective);
        }
    }

    public void updateMovedFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retargetUsages(@NotNull List<? extends UsageInfo> usageInfos, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        Intrinsics.checkNotNullParameter(usageInfos, (String)"usageInfos");
        Intrinsics.checkNotNullParameter(oldToNewMap, (String)"oldToNewMap");
        boolean $i$f$allowAnalysisOnEdt = false;
        Boolean bl = KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            boolean bl2 = false;
            MoveUsageUtilKt.retargetUsagesAfterMove(usageInfos, oldToNewMap);
        } else {
            KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().set(true);
            try {
                boolean bl3 = false;
                MoveUsageUtilKt.retargetUsagesAfterMove(usageInfos, oldToNewMap);
                Unit unit2 = Unit.INSTANCE;
            }
            finally {
                KtReadActionConfinementLifetimeToken.Companion.getAllowOnEdt().set(false);
            }
        }
    }
}

