/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.AddAnnotationTargetFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.TypedArrayValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0094\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "Companion", "kotlin.idea"})
public final class AddAnnotationTargetFix
extends KotlinQuickFixAction<KtAnnotationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AddAnnotationTargetFix(@NotNull KtAnnotationEntry annotationEntry2) {
        Intrinsics.checkNotNullParameter((Object)annotationEntry2, (String)"annotationEntry");
        super((PsiElement)annotationEntry2);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("fix.add.annotation.target", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        ClassDescriptor annotationClassDescriptor;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)this.getElement();
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        Pair pair = AddAnnotationTargetFix.Companion.toAnnotationClass(annotationEntry2);
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        KtClass annotationClass2 = (KtClass)pair2.component1();
        List requiredAnnotationTargets = AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(annotationEntry2, annotationClass2, annotationClassDescriptor = (ClassDescriptor)pair2.component2(), project2);
        if (requiredAnnotationTargets.isEmpty()) {
            return;
        }
        ExpectActualUtilKt.runOnExpectAndAllActuals$default((KtDeclaration)annotationClass2, false, true, (Function1)new Function1<KtDeclaration, Unit>(project2, (List<? extends KotlinTarget>)requiredAnnotationTargets){
            final /* synthetic */ Project $project;
            final /* synthetic */ List<KotlinTarget> $requiredAnnotationTargets;
            {
                this.$project = $project;
                this.$requiredAnnotationTargets = $requiredAnnotationTargets;
                super(1);
            }

            public final void invoke(@NotNull KtDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KtDeclaration $this$safeAs$iv = it;
                boolean $i$f$safeAs = false;
                KtDeclaration ktDeclaration2 = $this$safeAs$iv;
                if (!(ktDeclaration2 instanceof KtClass)) {
                    ktDeclaration2 = null;
                }
                KtClass ktClass2 = (KtClass)ktDeclaration2;
                if (ktClass2 == null) {
                    return;
                }
                KtClass ktClass3 = ktClass2;
                ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$project, ktClass3, this.$requiredAnnotationTargets){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ KtClass $ktClass;
                    final /* synthetic */ List<KotlinTarget> $requiredAnnotationTargets;
                    {
                        this.$project = $project;
                        this.$ktClass = $ktClass;
                        this.$requiredAnnotationTargets = $requiredAnnotationTargets;
                        super(0);
                    }

                    public final void invoke() {
                        KtPsiFactory psiFactory = new KtPsiFactory(this.$project, false, 2, null);
                        AddAnnotationTargetFixKt.access$addAnnotationTargets(this.$ktClass, this.$requiredAnnotationTargets, psiFactory);
                    }
                }));
            }
        }, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e*\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getExistingAnnotationTargets", "", "", "annotationClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "toAnnotationClass", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtClass;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nAddAnnotationTargetFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddAnnotationTargetFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n288#2,2:231\n1603#2,9:234\n1855#2:243\n1856#2:246\n1612#2:247\n118#3:233\n118#3:244\n1#4:245\n*S KotlinDebug\n*F\n+ 1 AddAnnotationTargetFix.kt\norg/jetbrains/kotlin/idea/quickfix/AddAnnotationTargetFix$Companion\n*L\n76#1:231,2\n80#1:234,9\n80#1:243\n80#1:246\n80#1:247\n78#1:233\n80#1:244\n80#1:245\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        private final Pair<KtClass, ClassDescriptor> toAnnotationClass(KtAnnotationEntry $this$toAnnotationClass) {
            Object object;
            ClassDescriptor annotationTypeDescriptor;
            block6: {
                block5: {
                    KtClass ktClass2;
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$toAnnotationClass, BodyResolveMode.PARTIAL);
                    AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)context2.get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)$this$toAnnotationClass);
                    if (annotationDescriptor == null) {
                        return null;
                    }
                    AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                    ClassifierDescriptor classifierDescriptor = annotationDescriptor2.getType().getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        return null;
                    }
                    annotationTypeDescriptor = classDescriptor;
                    PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)annotationTypeDescriptor));
                    object = psiElement2 instanceof KtClass ? (KtClass)psiElement2 : null;
                    if (object == null) break block5;
                    KtClass it = ktClass2 = object;
                    boolean bl = false;
                    object = it.isAnnotation() && it.isWritable() ? ktClass2 : null;
                    if (object != null) break block6;
                }
                return null;
            }
            KtClass annotationClass2 = object;
            return TuplesKt.to((Object)annotationClass2, (Object)annotationTypeDescriptor);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> getExistingAnnotationTargets(@NotNull ClassDescriptor annotationClassDescriptor) {
            Set set2;
            Set set3;
            TypedArrayValue typedArrayValue;
            Object v0;
            block7: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)annotationClassDescriptor, (String)"annotationClassDescriptor");
                Iterable iterable = (Iterable)annotationClassDescriptor.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFqName(), (Object)StandardNames.FqNames.target)) continue;
                    v0 = element$iv;
                    break block7;
                }
                v0 = null;
            }
            Object object = v0;
            ConstantValue $this$safeAs$iv = object != null ? DescriptorUtilsKt.firstArgument((AnnotationDescriptor)object) : null;
            boolean $i$f$safeAs = false;
            ConstantValue constantValue = $this$safeAs$iv;
            if (!(constantValue instanceof TypedArrayValue)) {
                constantValue = null;
            }
            if ((typedArrayValue = (TypedArrayValue)constantValue) != null && (object = (List)typedArrayValue.getValue()) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Object element$iv;
                Iterable $i$f$firstOrNull = (Iterable)object;
                boolean $i$f$mapNotNull = false;
                element$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    EnumValue enumValue;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ConstantValue it = (ConstantValue)element$iv$iv;
                    boolean bl2 = false;
                    ConstantValue $this$safeAs$iv2 = it;
                    boolean $i$f$safeAs2 = false;
                    ConstantValue constantValue2 = $this$safeAs$iv2;
                    if (!(constantValue2 instanceof EnumValue)) {
                        constantValue2 = null;
                    }
                    if (((enumValue = (EnumValue)constantValue2) != null && (enumValue = enumValue.getEnumEntryName()) != null ? enumValue.asString() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                set3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            } else {
                set3 = set2 = null;
            }
            if (set3 == null) {
                set2 = SetsKt.emptySet();
            }
            return set2;
        }

        @Override
        @Nullable
        protected KotlinQuickFixAction<KtAnnotationEntry> createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            if (!Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET) && !Intrinsics.areEqual((Object)diagnostic.getFactory(), (Object)Errors.WRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET)) {
                return null;
            }
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtAnnotationEntry ktAnnotationEntry = psiElement2 instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement2 : null;
            if (ktAnnotationEntry == null) {
                return null;
            }
            KtAnnotationEntry entry = ktAnnotationEntry;
            Pair<KtClass, ClassDescriptor> pair = this.toAnnotationClass(entry);
            if (pair == null) {
                return null;
            }
            Pair<KtClass, ClassDescriptor> pair2 = pair;
            KtClass annotationClass2 = (KtClass)pair2.component1();
            ClassDescriptor annotationClassDescriptor = (ClassDescriptor)pair2.component2();
            Project project2 = entry.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (AddAnnotationTargetFixKt.access$getRequiredAnnotationTargets(entry, annotationClass2, annotationClassDescriptor, project2).isEmpty()) {
                return null;
            }
            return new AddAnnotationTargetFix(entry);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

