/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000f\u0010\t\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\nH\u0016J\u000f\u0010\u000b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\fH\u0016J\u000f\u0010\r\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u000eH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/AutomaticFileRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "newFileName", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;)V", "allowChangeSuggestedName", "", "entityName", "Lcom/intellij/openapi/util/NlsContexts$ColumnName;", "getDialogDescription", "Lcom/intellij/openapi/util/NlsContexts$Button;", "getDialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "isSelectedByDefault", "kotlin.refactorings.common"})
public final class AutomaticFileRenamer
extends AutomaticRenamer {
    public AutomaticFileRenamer(@NotNull KtFile file2, @NotNull String newFileName) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newFileName, (String)"newFileName");
        this.myElements.add(file2);
        String string = file2.getName();
        String string2 = file2.getVirtualFile().getExtension();
        if (string2 == null) {
            string2 = "kt";
        }
        this.suggestAllNames(string, newFileName + "." + string2);
    }

    public boolean allowChangeSuggestedName() {
        return false;
    }

    @Nullable
    public String getDialogTitle() {
        return KotlinBundle.message("title.rename.file", new Object[0]);
    }

    @Nullable
    public String getDialogDescription() {
        return KotlinBundle.message("title.rename.file.to", new Object[0]);
    }

    @Nullable
    public String entityName() {
        return KotlinBundle.message("file.entity", new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }
}

