/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.KtDestructuringDeclarationReference;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0016\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinRequestResultProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "unwrappedElement", "Lcom/intellij/psi/PsiElement;", "originalElement", "filter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiReference;", "", "options", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;)V", "referenceService", "Lcom/intellij/psi/PsiReferenceService;", "kotlin.jvm.PlatformType", "processTextOccurrence", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "containsOffsetInElement", "isReferenceToTarget", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nKotlinRequestResultProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRequestResultProcessor.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinRequestResultProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1360#2:75\n1446#2,5:76\n1726#2,3:81\n*S KotlinDebug\n*F\n+ 1 KotlinRequestResultProcessor.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinRequestResultProcessor\n*L\n32#1:75\n32#1:76,5\n35#1:81,3\n*E\n"})
public final class KotlinRequestResultProcessor
extends RequestResultProcessor {
    @NotNull
    private final PsiElement unwrappedElement;
    @NotNull
    private final PsiElement originalElement;
    @NotNull
    private final Function1<PsiReference, Boolean> filter;
    @NotNull
    private final KotlinReferencesSearchOptions options;
    private final PsiReferenceService referenceService;

    public KotlinRequestResultProcessor(@NotNull PsiElement unwrappedElement, @NotNull PsiElement originalElement, @NotNull Function1<? super PsiReference, Boolean> filter2, @NotNull KotlinReferencesSearchOptions options2) {
        Intrinsics.checkNotNullParameter((Object)unwrappedElement, (String)"unwrappedElement");
        Intrinsics.checkNotNullParameter((Object)originalElement, (String)"originalElement");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Object[] objectArray = new Object[]{unwrappedElement, originalElement, filter2, options2};
        super(objectArray);
        this.unwrappedElement = unwrappedElement;
        this.originalElement = originalElement;
        this.filter = filter2;
        this.options = options2;
        this.referenceService = PsiReferenceService.getService();
    }

    public /* synthetic */ KotlinRequestResultProcessor(PsiElement psiElement2, PsiElement psiElement3, Function1 function1, KotlinReferencesSearchOptions kotlinReferencesSearchOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            psiElement3 = psiElement2;
        }
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            kotlinReferencesSearchOptions = KotlinReferencesSearchOptions.Companion.getEmpty();
        }
        this(psiElement2, psiElement3, (Function1<? super PsiReference, Boolean>)function1, kotlinReferencesSearchOptions);
    }

    /*
     * WARNING - void declaration
     */
    public boolean processTextOccurrence(@NotNull PsiElement element3, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        boolean bl;
        block6: {
            List list2;
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            if (element3 instanceof KtDestructuringDeclaration) {
                void $this$flatMapTo$iv$iv;
                List list3 = ((KtDestructuringDeclaration)element3).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEntries(...)");
                Iterable $this$flatMap$iv = list3;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv$iv;
                    boolean bl2 = false;
                    List list4 = this.referenceService.getReferences((PsiElement)it, PsiReferenceService.Hints.NO_HINTS);
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getReferences(...)");
                    Iterable list$iv$iv = list4;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                List list5 = this.referenceService.getReferences(element3, PsiReferenceService.Hints.NO_HINTS);
                list2 = list5;
                Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getReferences(...)");
            }
            List references2 = list2;
            Iterable $this$all$iv = references2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiReference ref = (PsiReference)element$iv;
                    boolean bl3 = false;
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNull((Object)ref);
                    if (((Boolean)this.filter.invoke((Object)ref)).booleanValue() && this.containsOffsetInElement(ref, offsetInElement) && this.isReferenceToTarget(ref, this.unwrappedElement) ? consumer.process((Object)ref) : true) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean containsOffsetInElement(PsiReference $this$containsOffsetInElement, int offsetInElement) {
        if ($this$containsOffsetInElement instanceof KtDestructuringDeclarationReference) {
            return true;
        }
        return ReferenceRange.containsOffsetInElement((PsiReference)$this$containsOffsetInElement, (int)offsetInElement);
    }

    private final boolean isReferenceToTarget(PsiReference $this$isReferenceToTarget, PsiElement element3) {
        if ($this$isReferenceToTarget.isReferenceTo(element3)) {
            return true;
        }
        PsiElement psiElement2 = $this$isReferenceToTarget.resolve();
        if (Intrinsics.areEqual((Object)(psiElement2 != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiElement2) : null), (Object)element3.getOriginalElement())) {
            return true;
        }
        if (this.originalElement instanceof KtNamedDeclaration) {
            if (KotlinSearchUsagesSupport.SearchUtils.INSTANCE.isInvokeOfCompanionObject($this$isReferenceToTarget, (KtNamedDeclaration)this.originalElement)) {
                return true;
            }
            if (this.options.getAcceptCallableOverrides() && KotlinSearchUsagesSupport.SearchUtils.INSTANCE.isCallableOverrideUsage($this$isReferenceToTarget, (KtNamedDeclaration)this.originalElement)) {
                return true;
            }
            if (this.options.getAcceptOverloads() && this.originalElement instanceof KtFunction && KotlinSearchUsagesSupport.SearchUtils.INSTANCE.isUsageInContainingDeclaration($this$isReferenceToTarget, (KtNamedDeclaration)this.originalElement)) {
                return true;
            }
            if (this.options.getAcceptExtensionsOfDeclarationClass() && KotlinSearchUsagesSupport.SearchUtils.INSTANCE.isExtensionOfDeclarationClassUsage($this$isReferenceToTarget, (KtNamedDeclaration)this.originalElement)) {
                return true;
            }
        }
        return false;
    }
}

