/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.nj2k.ExpressionsKt;
import org.jetbrains.kotlin.nj2k.JKSymbolProvider;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.RecursiveApplicableConversionBase;
import org.jetbrains.kotlin.nj2k.tree.FormattingKt;
import org.jetbrains.kotlin.nj2k.tree.JKArgumentList;
import org.jetbrains.kotlin.nj2k.tree.JKCallExpressionImpl;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKExpressionStatement;
import org.jetbrains.kotlin.nj2k.tree.JKFormattingOwner;
import org.jetbrains.kotlin.nj2k.tree.JKJavaNewArray;
import org.jetbrains.kotlin.nj2k.tree.JKJavaNewEmptyArray;
import org.jetbrains.kotlin.nj2k.tree.JKLambdaExpression;
import org.jetbrains.kotlin.nj2k.tree.JKNewExpression;
import org.jetbrains.kotlin.nj2k.tree.JKStubExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.nj2k.tree.JKTypeArgumentList;
import org.jetbrains.kotlin.nj2k.tree.JKTypeElement;
import org.jetbrains.kotlin.nj2k.tree.TreeUtilsKt;
import org.jetbrains.kotlin.nj2k.types.JKClassType;
import org.jetbrains.kotlin.nj2k.types.JKJavaArrayType;
import org.jetbrains.kotlin.nj2k.types.JKJavaPrimitiveType;
import org.jetbrains.kotlin.nj2k.types.JKType;
import org.jetbrains.kotlin.nj2k.types.TypesUtilsKt;
import org.jetbrains.kotlin.resolve.ArrayFqNames;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/ArrayInitializerConversion;", "Lorg/jetbrains/kotlin/nj2k/RecursiveApplicableConversionBase;", "context", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "(Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;)V", "applyToElement", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "element", "buildArrayInitializer", "Lorg/jetbrains/kotlin/nj2k/tree/JKExpression;", "dimensions", "", "type", "Lorg/jetbrains/kotlin/nj2k/types/JKType;", "kotlin.j2k.new"})
@SourceDebugExtension(value={"SMAP\nArrayInitializerConversion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayInitializerConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/ArrayInitializerConversion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1#2:90\n1789#3,3:91\n*S KotlinDebug\n*F\n+ 1 ArrayInitializerConversion.kt\norg/jetbrains/kotlin/nj2k/conversions/ArrayInitializerConversion\n*L\n60#1:91,3\n*E\n"})
public final class ArrayInitializerConversion
extends RecursiveApplicableConversionBase {
    public ArrayInitializerConversion(@NotNull NewJ2kConverterContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    @Override
    @NotNull
    public JKTreeElement applyToElement(@NotNull JKTreeElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        JKTreeElement newElement2 = element3;
        if (element3 instanceof JKJavaNewArray) {
            JKTypeArgumentList jKTypeArgumentList;
            List<JKExpression> list2;
            String string;
            JKJavaPrimitiveType primitiveArrayType;
            JKType jKType = ((JKJavaNewArray)element3).getType().getType();
            JKJavaPrimitiveType jKJavaPrimitiveType = primitiveArrayType = jKType instanceof JKJavaPrimitiveType ? (JKJavaPrimitiveType)jKType : null;
            if (primitiveArrayType != null) {
                Object v = ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().get(PrimitiveType.valueOf((String)primitiveArrayType.getJvmPrimitiveType().name()));
                Intrinsics.checkNotNull(v);
                string = ((Name)v).asString();
            } else {
                string = ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION().asString();
            }
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            String arrayConstructorName = string2;
            List<JKExpression> it = list2 = ((JKJavaNewArray)element3).getInitializer();
            boolean bl = false;
            ((JKJavaNewArray)element3).setInitializer(CollectionsKt.emptyList());
            JKArgumentList arguments2 = ExpressionsKt.toArgumentList(list2);
            arguments2.setHasTrailingComma(((JKJavaNewArray)element3).getHasTrailingComma());
            if (primitiveArrayType == null) {
                JKTypeElement[] jKTypeElementArray = new JKTypeElement[]{TreeUtilsKt.detached((KProperty0)new PropertyReference0Impl(element3){

                    @Nullable
                    public Object get() {
                        return ((JKJavaNewArray)this.receiver).getType();
                    }
                })};
                JKTypeArgumentList jKTypeArgumentList2 = new JKTypeArgumentList(jKTypeElementArray);
                jKTypeArgumentList = jKTypeArgumentList2;
            } else {
                jKTypeArgumentList = new JKTypeArgumentList(null, 1, null);
            }
            JKTypeArgumentList typeArguments2 = jKTypeArgumentList;
            newElement2 = new JKCallExpressionImpl(this.getSymbolProvider().provideMethodSymbol("kotlin." + arrayConstructorName), arguments2, typeArguments2, null, 8, null);
        } else if (element3 instanceof JKJavaNewEmptyArray) {
            List<JKExpression> list3;
            List<JKExpression> arrayConstructorName = list3 = ((JKJavaNewEmptyArray)element3).getInitializer();
            ArrayInitializerConversion arrayInitializerConversion = this;
            boolean bl = false;
            ((JKJavaNewEmptyArray)element3).setInitializer(CollectionsKt.emptyList());
            newElement2 = arrayInitializerConversion.buildArrayInitializer(list3, ((JKJavaNewEmptyArray)element3).getType().getType());
        }
        return this.recurse((JKTreeElement)FormattingKt.withFormattingFrom((JKFormattingOwner)newElement2, (JKFormattingOwner)element3));
    }

    private final JKExpression buildArrayInitializer(List<? extends JKExpression> dimensions, JKType type2) {
        if (dimensions.size() == 1) {
            JKExpression jKExpression;
            if (!(type2 instanceof JKJavaPrimitiveType)) {
                Object[] objectArray = new JKExpression[]{dimensions.get(0)};
                JKArgumentList jKArgumentList = new JKArgumentList((JKExpression[])objectArray);
                objectArray = new JKType[]{type2};
                jKExpression = new JKCallExpressionImpl(this.getSymbolProvider().provideMethodSymbol("kotlin.arrayOfNulls"), jKArgumentList, new JKTypeArgumentList((JKType[])objectArray), null, 8, null);
            } else {
                JKExpression[] jKExpressionArray = new JKExpression[]{dimensions.get(0)};
                jKExpression = new JKNewExpression(this.getSymbolProvider().provideClassSymbol(TypesUtilsKt.arrayFqName(type2)), new JKArgumentList(jKExpressionArray), null, null, false, null, 60, null);
            }
            return jKExpression;
        }
        if (!(dimensions.get(1) instanceof JKStubExpression)) {
            Object[] $this$fold$iv = (JKExpression[])CollectionsKt.drop((Iterable)dimensions, (int)1);
            boolean $i$f$fold = false;
            JKType accumulator$iv = type2;
            for (Object t : $this$fold$iv) {
                JKExpression cfr_ignored_0 = (JKExpression)t;
                JKType currentType = accumulator$iv;
                boolean bl = false;
                accumulator$iv = new JKJavaArrayType(currentType, null, 2, null);
            }
            JKType arrayType = accumulator$iv;
            $this$fold$iv = new JKExpression[]{dimensions.get(0), new JKLambdaExpression(new JKExpressionStatement(this.buildArrayInitializer(dimensions.subList(1, dimensions.size()), type2)), null, null, null, null, 30, null)};
            JKArgumentList jKArgumentList = new JKArgumentList((JKExpression[])$this$fold$iv);
            $this$fold$iv = new JKType[]{arrayType};
            return new JKNewExpression(this.getSymbolProvider().provideClassSymbol("kotlin.Array"), jKArgumentList, new JKTypeArgumentList((JKType[])$this$fold$iv), null, false, null, 56, null);
        }
        JKClassType resultType = new JKClassType(this.getSymbolProvider().provideClassSymbol(TypesUtilsKt.arrayFqName(type2)), type2 instanceof JKJavaPrimitiveType ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)type2), null, 4, null);
        int n = dimensions.size() - 2;
        for (int i2 = 0; i2 < n; ++i2) {
            JKSymbolProvider jKSymbolProvider = this.getSymbolProvider();
            FqName fqName2 = StandardNames.FqNames.array.toSafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
            resultType = new JKClassType(jKSymbolProvider.provideClassSymbol(fqName2), CollectionsKt.listOf((Object)resultType), null, 4, null);
        }
        Object[] objectArray = new JKExpression[]{dimensions.get(0)};
        JKArgumentList jKArgumentList = new JKArgumentList((JKExpression[])objectArray);
        objectArray = new JKType[]{resultType};
        return new JKCallExpressionImpl(this.getSymbolProvider().provideMethodSymbol("kotlin.arrayOfNulls"), jKArgumentList, new JKTypeArgumentList((JKType[])objectArray), null, 8, null);
    }
}

