/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.lifetime;

import com.jetbrains.rd.util.BitHacksKt;
import com.jetbrains.rd.util.BitSlice;
import com.jetbrains.rd.util.BitSliceKt;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.LifetimeStatus;
import com.jetbrains.rd.util.lifetime.LifetimeTerminationTimeoutKind;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rd.util.threading.coroutines.RdCoroutineScope;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 T2\u00020\u0001:\u0003STUB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0006H\u0016J5\u0010/\u001a\u0004\u0018\u0001H0\"\b\b\u0000\u00100*\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u0002H0022\f\u00103\u001a\b\u0012\u0004\u0012\u00020,02H\u0016\u00a2\u0006\u0002\u00104J;\u00105\u001a\u0004\u0018\u0001H0\"\b\b\u0000\u00100*\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u0002H0022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u00020,06H\u0016\u00a2\u0006\u0002\u00107J3\u00108\u001a\u0002H0\"\b\b\u0000\u00100*\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u0002H0022\f\u00103\u001a\b\u0012\u0004\u0012\u00020,02H\u0016\u00a2\u0006\u0002\u00104J9\u00109\u001a\u0002H0\"\b\b\u0000\u00100*\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u0002H0022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u00020,06H\u0016\u00a2\u0006\u0002\u00107J\u0010\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020\u0006H\u0002J'\u0010<\u001a\u0004\u0018\u0001H0\"\b\b\u0000\u00100*\u00020\u00102\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H002H\u0016\u00a2\u0006\u0002\u0010>J%\u0010?\u001a\u0002H0\"\b\b\u0000\u00100*\u00020\u00102\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H002H\u0016\u00a2\u0006\u0002\u0010>J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010A\u001a\u00020,H\u0002J\u0016\u0010B\u001a\u00020,2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020,02H\u0016J\u0014\u0010B\u001a\u00020,2\n\u0010C\u001a\u00060Dj\u0002`EH\u0016J\u0016\u0010F\u001a\u00020\u00062\f\u0010=\u001a\b\u0012\u0004\u0012\u00020,02H\u0016J\u0014\u0010F\u001a\u00020\u00062\n\u0010C\u001a\u00060Dj\u0002`EH\u0016J\u0010\u0010G\u001a\u00020,2\u0006\u0010H\u001a\u00020\u0010H\u0002J\u0010\u0010I\u001a\u00020\u00062\b\b\u0002\u0010J\u001a\u00020\u0006J\b\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0010H\u0002J\n\u0010N\u001a\u0004\u0018\u00010OH\u0002J\n\u0010P\u001a\u0004\u0018\u00010OH\u0002J,\u0010Q\u001a\u0004\u0018\u0001H0\"\u0004\b\u0000\u001002\u0006\u0010!\u001a\u00020\"2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H002H\u0082\b\u00a2\u0006\u0002\u0010RR$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0012\u0010\u001e\u001a\u00060\u001fj\u0002` X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u0010&\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020%8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006V"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "parent", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "()V", "value", "", "allowTerminationUnderExecution", "getAllowTerminationUnderExecution", "()Z", "setAllowTerminationUnderExecution", "(Z)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "", "id", "getId", "()Ljava/lang/Object;", "setId", "(Ljava/lang/Object;)V", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "resCount", "", "resources", "", "[Ljava/lang/Object;", "state", "Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/jetbrains/rd/util/AtomicInteger;", "status", "Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "getStatus", "()Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;", "terminationTimeoutKind", "getTerminationTimeoutKind", "()Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;", "setTerminationTimeoutKind", "(Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;)V", "attach", "", "child", "inheritTimeoutKind", "bracketIfAlive", "T", "opening", "Lkotlin/Function0;", "terminationAction", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "bracketIfAliveEx", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "bracketOrThrow", "bracketOrThrowEx", "destruct", "supportsRecursion", "executeIfAlive", "action", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeOrThrow", "incrementStatusIfEqualTo", "markCancelingRecursively", "onTermination", "closeable", "Ljava/io/Closeable;", "Lcom/jetbrains/rd/util/Closeable;", "onTerminationIfAlive", "onTerminationImpl", "resource", "terminate", "supportsTerminationUnderExecuting", "toString", "", "tryAdd", "tryGetAdditionalFields", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition$AdditionalFields;", "tryGetOrCreateAdditionalFields", "underMutexIfLessOrEqual", "(Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "AdditionalFields", "Companion", "EternalAdditionalFields", "rd-core"})
@SourceDebugExtension(value={"SMAP\nRLifetime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/LifetimeDefinition\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 PlatformDependent.kt\ncom/jetbrains/rd/util/PlatformDependentKt\n+ 5 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 6 BitSlice.kt\ncom/jetbrains/rd/util/BitSlice$Companion\n*L\n1#1,663:1\n314#1,16:680\n332#1,6:697\n107#2:664\n98#2,4:665\n107#2:669\n98#2,10:670\n106#2:723\n98#2,4:724\n107#2:738\n98#2,4:739\n107#2:743\n98#2,4:744\n1#3:696\n1#3:750\n1#3:754\n82#4:703\n82#4:704\n85#4:705\n84#4:728\n82#4:736\n82#4:737\n22#5,17:706\n14#5,7:729\n41#6,2:748\n43#6:751\n41#6,2:752\n43#6:755\n*S KotlinDebug\n*F\n+ 1 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/LifetimeDefinition\n*L\n367#1:680,16\n367#1:697,6\n271#1:664\n271#1:665,4\n302#1:669\n302#1:670,10\n463#1:723\n463#1:724,4\n509#1:738\n509#1:739,4\n539#1:743\n539#1:744,4\n216#1:750\n219#1:754\n413#1:703\n430#1:704\n462#1:705\n478#1:728\n488#1:736\n489#1:737\n462#1:706,17\n478#1:729,7\n216#1:748,2\n216#1:751\n219#1:752,2\n219#1:755\n*E\n"})
public final class LifetimeDefinition
extends Lifetime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AtomicInteger state;
    @Nullable
    private Object[] resources;
    private int resCount;
    @Nullable
    private Object id;
    @NotNull
    private static final Lazy<Logger> log$delegate = LazyKt.lazy((Function0)Companion.log.2.INSTANCE);
    @NotNull
    private static final BitSlice.TypedBitSlice<Integer> executingSlice = BitSlice.Companion.int$default(BitSlice.Companion, 20, null, 2, null);
    @NotNull
    private static final BitSlice.TypedBitSlice<LifetimeStatus> statusSlice;
    @NotNull
    private static final BitSlice.TypedBitSlice<Boolean> mutexSlice;
    @NotNull
    private static final BitSlice.TypedBitSlice<Boolean> logErrorAfterExecution;
    @NotNull
    private static final BitSlice.TypedBitSlice<LifetimeTerminationTimeoutKind> terminationTimeoutKindSlice;
    @NotNull
    private static final BitSlice.TypedBitSlice<Boolean> allowTerminationUnderExecutionSlice;
    @NotNull
    private static final LifetimeDefinition Terminated;
    @NotNull
    private static final LifetimeDefinition eternal;
    @NotNull
    public static final String anonymousLifetimeId = "Anonymous";

    public LifetimeDefinition() {
        super(null);
        this.state = new AtomicInteger();
        this.resources = new Object[1];
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this;
    }

    public LifetimeDefinition(@NotNull Lifetime parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this();
        parent.attach(this, true);
    }

    @Override
    @NotNull
    public LifetimeStatus getStatus() {
        return BitSliceKt.get(statusSlice, this.state);
    }

    @Override
    @NotNull
    public LifetimeTerminationTimeoutKind getTerminationTimeoutKind() {
        return BitSliceKt.get(terminationTimeoutKindSlice, this.state);
    }

    public void setTerminationTimeoutKind(@NotNull LifetimeTerminationTimeoutKind value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        terminationTimeoutKindSlice.atomicUpdate(this.state, value2);
    }

    @Override
    public boolean getAllowTerminationUnderExecution() {
        return BitSliceKt.get(allowTerminationUnderExecutionSlice, this.state);
    }

    public void setAllowTerminationUnderExecution(boolean value2) {
        allowTerminationUnderExecutionSlice.atomicUpdate(this.state, value2);
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope() {
        AdditionalFields additionalFields = this.tryGetOrCreateAdditionalFields();
        if (additionalFields == null || (additionalFields = additionalFields.getScope()) == null) {
            additionalFields = RdCoroutineScope.Companion.getCurrent().getCancelledScope();
        }
        return additionalFields;
    }

    @Nullable
    public final Object getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public final void setId(@Nullable Object value2) {
        if (value2 instanceof Lifetime) {
            void $this$log$iv$iv;
            Logger $this$error$iv = Logger.Companion.getRoot();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var8_8 = $this$log$iv$iv;
                boolean bl = false;
                String string2 = "Set lifetime as id for another lifetime is not allowed";
                var8_8.log(logLevel, string2, null);
            }
            return;
        }
        this.id = value2;
        if (this.getStatus() == LifetimeStatus.Terminated) {
            this.id = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T> T executeIfAlive(@NotNull Function0<? extends T> action) {
        Object object;
        int s;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        do {
            if (statusSlice.get(s = this.state.get()) == LifetimeStatus.Alive) continue;
            return null;
        } while (!this.state.compareAndSet(s, s + 1));
        Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, 1);
        try {
            object = action.invoke();
            Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, -1);
        }
        catch (Throwable throwable) {
            Lifetime.Companion.getThreadLocalExecuting$rd_core().add(this, -1);
            this.state.decrementAndGet();
            if (BitSliceKt.get(logErrorAfterExecution, this.state).booleanValue()) {
                long terminationTimeoutMs = Lifetime.Companion.getTerminationTimeoutMs(this.getTerminationTimeoutKind());
                Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
                boolean $i$f$error = false;
                Logger $this$log$iv$iv = $this$error$iv;
                LogLevel level$iv$iv = LogLevel.Error;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    Logger logger = $this$log$iv$iv;
                    boolean bl = false;
                    String string2 = "executeIfAlive after termination of " + this + " took too much time (>" + terminationTimeoutMs + "ms)";
                    logger.log(logLevel, string2, null);
                }
            }
            throw throwable;
        }
        this.state.decrementAndGet();
        if (BitSliceKt.get(logErrorAfterExecution, this.state).booleanValue()) {
            void $this$log$iv$iv;
            long terminationTimeoutMs = Lifetime.Companion.getTerminationTimeoutMs(this.getTerminationTimeoutKind());
            Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
            boolean $i$f$error = false;
            Logger logger = $this$error$iv;
            LogLevel level$iv$iv = LogLevel.Error;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var11_19 = $this$log$iv$iv;
                boolean bl = false;
                String string3 = "executeIfAlive after termination of " + this + " took too much time (>" + terminationTimeoutMs + "ms)";
                var11_19.log(logLevel, string3, null);
            }
        }
        return (T)object;
    }

    @Override
    @NotNull
    public <T> T executeOrThrow(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        T t = this.executeIfAlive(action);
        if (t == null) {
            throw new CancellationException();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T underMutexIfLessOrEqual(LifetimeStatus status, Function0<? extends T> action) {
        int s;
        boolean $i$f$underMutexIfLessOrEqual = false;
        do {
            if (statusSlice.get(s = this.state.get()).compareTo((Enum)status) <= 0) continue;
            return null;
        } while (mutexSlice.get(s).booleanValue() || !this.state.compareAndSet(s, mutexSlice.updated(s, true)));
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            int s2;
            InlineMarker.finallyStart((int)1);
            do {
                s2 = this.state.get();
                PlatformDependentKt.assert(mutexSlice.get(s2));
            } while (!this.state.compareAndSet(s2, mutexSlice.updated(s2, false)));
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final AdditionalFields tryGetAdditionalFields() {
        if (this.getLifetime() == eternal) {
            return EternalAdditionalFields.INSTANCE;
        }
        if (this.resources == null) {
            return null;
        }
        Object[] resources = this.resources;
        Object object = resources[0];
        return object instanceof AdditionalFields ? (AdditionalFields)object : null;
    }

    private final AdditionalFields tryGetOrCreateAdditionalFields() {
        AdditionalFields additionalFields = this.tryGetAdditionalFields();
        if (additionalFields == null) {
            LifetimeDefinition $this$tryGetOrCreateAdditionalFields_u24lambda_u242 = this;
            boolean bl = false;
            AdditionalFields additionalFields2 = new AdditionalFields($this$tryGetOrCreateAdditionalFields_u24lambda_u242.getId());
            if ($this$tryGetOrCreateAdditionalFields_u24lambda_u242.tryAdd(additionalFields2)) {
                additionalFields = additionalFields2;
            } else {
                additionalFields2.cancel();
                additionalFields = $this$tryGetOrCreateAdditionalFields_u24lambda_u242.tryGetAdditionalFields();
            }
        }
        return additionalFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean tryAdd(Object action) {
        Boolean bl;
        block16: {
            int s$iv;
            Boolean bl2;
            void this_$iv;
            int s$iv2;
            if (this.getLifetime() == eternal) {
                return true;
            }
            LifetimeDefinition lifetimeDefinition = this;
            LifetimeStatus status$iv = LifetimeStatus.Canceling;
            boolean $i$f$underMutexIfLessOrEqual = false;
            do {
                if (statusSlice.get(s$iv2 = this_$iv.state.get()).compareTo((Enum)status$iv) <= 0) continue;
                bl = null;
                break block16;
            } while (mutexSlice.get(s$iv2).booleanValue() || !this_$iv.state.compareAndSet(s$iv2, mutexSlice.updated(s$iv2, true)));
            try {
                boolean bl3;
                boolean bl4 = false;
                Object[] localResources = this.resources;
                if (!(localResources != null)) {
                    boolean $i$a$-require-LifetimeDefinition$tryAdd$1$22 = false;
                    String $i$a$-require-LifetimeDefinition$tryAdd$1$22 = this + ": `resources` can't be null under mutex while status < Terminating";
                    throw new IllegalArgumentException($i$a$-require-LifetimeDefinition$tryAdd$1$22.toString());
                }
                if (this.resCount == localResources.length) {
                    int countAfterCleaning = 0;
                    int n = this.resCount;
                    for (int i = 0; i < n; ++i) {
                        Object resource = localResources[i];
                        if (resource instanceof LifetimeDefinition && ((LifetimeDefinition)resource).getStatus().compareTo((Enum)LifetimeStatus.Terminating) >= 0) {
                            localResources[i] = null;
                            continue;
                        }
                        localResources[countAfterCleaning++] = resource;
                    }
                    this.resCount = countAfterCleaning;
                    if (countAfterCleaning * 2 > localResources.length) {
                        Object[] newArray = new Object[countAfterCleaning * 2];
                        ArraysKt.copyInto((Object[])localResources, (Object[])newArray, (int)0, (int)0, (int)countAfterCleaning);
                        this.resources = newArray;
                    }
                }
                Intrinsics.checkNotNull((Object)this.resources);
                localResources = this.resources;
                if (action instanceof AdditionalFields) {
                    if (localResources[0] instanceof AdditionalFields) {
                        bl3 = false;
                    } else {
                        var9_14 = this.resCount;
                        this.resCount = var9_14 + 1;
                        System.arraycopy(localResources, 0, localResources, 1, var9_14);
                        localResources[0] = action;
                        if (RLifetimeKt.isNotAlive(this)) {
                            ((AdditionalFields)action).cancel();
                        }
                        bl3 = true;
                    }
                } else {
                    var9_14 = this.resCount;
                    this.resCount = var9_14 + 1;
                    localResources[var9_14] = action;
                    bl3 = true;
                }
                bl2 = bl3;
            }
            catch (Throwable throwable) {
                int s$iv3;
                do {
                    s$iv3 = this_$iv.state.get();
                    PlatformDependentKt.assert(mutexSlice.get(s$iv3));
                } while (!this_$iv.state.compareAndSet(s$iv3, mutexSlice.updated(s$iv3, false)));
                throw throwable;
            }
            do {
                s$iv = this_$iv.state.get();
                PlatformDependentKt.assert(mutexSlice.get(s$iv));
            } while (!this_$iv.state.compareAndSet(s$iv, mutexSlice.updated(s$iv, false)));
            bl = bl2;
        }
        return bl != null ? bl : false;
    }

    private final boolean incrementStatusIfEqualTo(LifetimeStatus status) {
        LifetimeStatus nextStatus;
        int newS;
        int s;
        boolean value$iv = this != eternal;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string2 = this + ": Trying to change eternal lifetime";
            throw new AssertionError((Object)string2);
        }
        do {
            if (statusSlice.get(s = this.state.get()) == status) continue;
            return false;
        } while (!this.state.compareAndSet(s, newS = statusSlice.updated(s, nextStatus = LifetimeStatus.values()[statusSlice.get(s).ordinal() + 1])));
        return true;
    }

    private final void markCancelingRecursively() {
        boolean value$iv = this != eternal;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string2 = this + ": Trying to terminate eternal lifetime";
            throw new AssertionError((Object)string2);
        }
        if (!this.incrementStatusIfEqualTo(LifetimeStatus.Alive)) {
            return;
        }
        if (this.resources == null) {
            return;
        }
        Object[] localResources = this.resources;
        Object object = localResources[0];
        AdditionalFields additionalFields = object instanceof AdditionalFields ? (AdditionalFields)object : null;
        if (additionalFields != null) {
            additionalFields.cancel();
        }
        for (int i = Math.min(this.resCount, localResources.length) - 1; -1 < i; --i) {
            Object object2 = localResources[i];
            LifetimeDefinition lifetimeDefinition = object2 instanceof LifetimeDefinition ? (LifetimeDefinition)object2 : null;
            if (lifetimeDefinition == null) continue;
            lifetimeDefinition.markCancelingRecursively();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean terminate(boolean supportsTerminationUnderExecuting) {
        boolean bl;
        boolean $i$f$spinUntil5;
        SpinWait.Companion this_$iv$iv;
        boolean $i$f$spinUntil2;
        long terminationTimeoutMs;
        block10: {
            void this_$iv$iv$iv;
            if (RLifetimeKt.isEternal(this) || this.getStatus().compareTo((Enum)LifetimeStatus.Canceling) > 0) {
                return false;
            }
            if (((Number)Lifetime.Companion.getThreadLocalExecuting$rd_core().get((Object)this)).intValue() > 0 && !supportsTerminationUnderExecuting && !this.getAllowTerminationUnderExecution()) {
                throw new IllegalStateException((this + ": Can't terminate lifetime under `executeIfAlive` because termination doesn't support this. Use `terminate(true)`").toString());
            }
            this.markCancelingRecursively();
            terminationTimeoutMs = Lifetime.Companion.getTerminationTimeoutMs(this.getTerminationTimeoutKind());
            $i$f$spinUntil2 = false;
            this_$iv$iv = SpinWait.Companion;
            $i$f$spinUntil5 = false;
            SpinWait.Companion companion = this_$iv$iv;
            Lifetime lifetime$iv$iv$iv = Lifetime.Companion.getEternal();
            boolean $i$f$spinUntil3 = false;
            void var10_14 = this_$iv$iv$iv;
            Duration duration = Duration.ofMillis(terminationTimeoutMs);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(timeoutMs)");
            Duration duration$iv$iv$iv$iv = duration;
            boolean $i$f$spinUntil4 = false;
            long start$iv$iv$iv$iv = System.nanoTime();
            long spins$iv$iv$iv$iv = 0L;
            while (true) {
                boolean bl2 = false;
                if (((Number)BitSliceKt.get(executingSlice, this.state)).intValue() <= ((Number)Lifetime.Companion.getThreadLocalExecuting$rd_core().get((Object)this)).intValue()) break;
                if (!RLifetimeKt.isAlive(lifetime$iv$iv$iv) || System.nanoTime() - start$iv$iv$iv$iv > duration$iv$iv$iv$iv.toNanos()) {
                    bl = false;
                    break block10;
                }
                long l = spins$iv$iv$iv$iv;
                spins$iv$iv$iv$iv = l + 1L;
                if (l < 100L) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(spins$iv$iv$iv$iv / (long)100);
            }
            bl = true;
        }
        if (!bl) {
            void $this$log$iv$iv;
            Logger $this$warn$iv = LifetimeDefinition.Companion.getLog();
            boolean $i$f$warn = false;
            Logger $i$f$spinUntil5 = $this$warn$iv;
            LogLevel level$iv$iv = LogLevel.Warn;
            boolean $i$f$log = false;
            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                LogLevel logLevel = level$iv$iv;
                void var20_23 = $this$log$iv$iv;
                boolean bl3 = false;
                String string2 = this + ": can't wait for `executeIfAlive` completed on other thread in " + terminationTimeoutMs + " ms. Keep termination." + System.lineSeparator() + "This may happen either because of the executeIfAlive failed to complete in a timely manner. In the case there will be following error messages." + System.lineSeparator() + "This is also possible if the thread waiting for the termination wasn't able to receive execution time during the wait in SpinWait.SpinUntil, so it has missed the fact that the lifetime was terminated in time.";
                var20_23.log(logLevel, string2, null);
            }
            logErrorAfterExecution.atomicUpdate(this.state, true);
        }
        if (!this.incrementStatusIfEqualTo(LifetimeStatus.Canceling)) {
            return false;
        }
        $i$f$spinUntil2 = false;
        this_$iv$iv = SpinWait.Companion;
        $i$f$spinUntil5 = false;
        long spins$iv$iv = 0L;
        while (true) {
            boolean bl4 = false;
            if (BitSliceKt.get(mutexSlice, this.state) == false) break;
            long l = spins$iv$iv;
            spins$iv$iv = l + 1L;
            if (l < 100L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv$iv / (long)100);
        }
        this.destruct(supportsTerminationUnderExecuting);
        return true;
    }

    public static /* synthetic */ boolean terminate$default(LifetimeDefinition lifetimeDefinition, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return lifetimeDefinition.terminate(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void destruct(boolean supportsRecursion) {
        boolean value$iv = this.getStatus() == LifetimeStatus.Terminating;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string2 = "Bad status for destructuring start: " + this;
            throw new AssertionError((Object)string2);
        }
        value$iv = BitSliceKt.get(mutexSlice, this.state) == false;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !value$iv) {
            boolean bl = false;
            String string3 = this + ": mutex must be released in this point";
            throw new AssertionError((Object)string3);
        }
        Object[] localResources = this.resources;
        if (!(localResources != null)) {
            boolean $i$a$-require-LifetimeDefinition$destruct$42 = false;
            String $i$a$-require-LifetimeDefinition$destruct$42 = this + ": `resources` can't be null on destructuring stage";
            throw new IllegalArgumentException($i$a$-require-LifetimeDefinition$destruct$42.toString());
        }
        Object $i$a$-require-LifetimeDefinition$destruct$42 = localResources[0];
        AdditionalFields additionalFields = $i$a$-require-LifetimeDefinition$destruct$42 instanceof AdditionalFields ? (AdditionalFields)$i$a$-require-LifetimeDefinition$destruct$42 : null;
        if (additionalFields != null) {
            additionalFields.cancel();
        }
        for (int i = this.resCount - 1; -1 < i; --i) {
            Object resource = localResources[i];
            try {
                void $this$log$iv$iv;
                Object object;
                Object object2 = TypeIntrinsics.isFunctionOfArity((Object)resource, (int)0) ? (Function0)resource : null;
                if (object2 != null) {
                    Function0 action = object2;
                    boolean bl = false;
                    Object object3 = action.invoke();
                    object2 = object3;
                    if (object3 != null) continue;
                }
                if ((object = resource) instanceof Closeable) {
                    ((Closeable)resource).close();
                    object2 = Unit.INSTANCE;
                    continue;
                }
                if (object instanceof LifetimeDefinition) {
                    object2 = ((LifetimeDefinition)resource).terminate(supportsRecursion);
                    continue;
                }
                if (object instanceof AdditionalFields) {
                    ((AdditionalFields)resource).cancel();
                    object2 = Unit.INSTANCE;
                    continue;
                }
                Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
                boolean $i$f$error = false;
                Logger logger = $this$error$iv;
                LogLevel level$iv$iv = LogLevel.Error;
                boolean $i$f$log = false;
                if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var13_22 = $this$log$iv$iv;
                    boolean bl = false;
                    String string4 = this + ": Unknown termination resource: " + resource;
                    var13_22.log(logLevel, string4, null);
                }
                object2 = Unit.INSTANCE;
                continue;
            }
            catch (Throwable e) {
                LoggerKt.error(LifetimeDefinition.Companion.getLog(), this + ": exception on termination of resource: " + resource, e);
            }
        }
        this.resources = null;
        this.resCount = 0;
        if (!this.incrementStatusIfEqualTo(LifetimeStatus.Terminating)) {
            boolean bl = false;
            String string5 = "Bad status for destructuring finish: " + this;
            throw new IllegalArgumentException(string5.toString());
        }
        this.setId(null);
    }

    @Override
    public boolean onTerminationIfAlive(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return this.tryAdd(action);
    }

    @Override
    public boolean onTerminationIfAlive(@NotNull Closeable closeable) {
        Intrinsics.checkNotNullParameter((Object)closeable, (String)"closeable");
        return this.tryAdd(closeable);
    }

    @Override
    public void onTermination(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.onTerminationImpl(action);
    }

    @Override
    public void onTermination(@NotNull Closeable closeable) {
        Intrinsics.checkNotNullParameter((Object)closeable, (String)"closeable");
        this.onTerminationImpl(closeable);
    }

    /*
     * WARNING - void declaration
     */
    private final void onTerminationImpl(Object resource) {
        block8: {
            if (this.tryAdd(resource)) {
                return;
            }
            try {
                Object object = TypeIntrinsics.isFunctionOfArity((Object)resource, (int)0) ? (Function0)resource : null;
                if (object != null) {
                    Function0 action = object;
                    boolean bl = false;
                    Object object2 = action.invoke();
                    object = object2;
                    if (object2 != null) break block8;
                }
                if (resource instanceof Closeable) {
                    ((Closeable)resource).close();
                } else {
                    void $this$log$iv$iv;
                    Logger $this$error$iv = LifetimeDefinition.Companion.getLog();
                    boolean $i$f$error = false;
                    Logger logger = $this$error$iv;
                    LogLevel level$iv$iv = LogLevel.Error;
                    boolean $i$f$log = false;
                    if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var9_8 = $this$log$iv$iv;
                        boolean bl = false;
                        String string2 = this + ": Unknown termination resource: " + resource;
                        var9_8.log(logLevel, string2, null);
                    }
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable e) {
                LoggerKt.error(LifetimeDefinition.Companion.getLog(), this + ": exception on synchronous execute of action on terminated lifetime: " + resource, e);
            }
        }
        RLifetimeKt.access$badStatusForAddActions(this);
    }

    @Override
    public void attach(@NotNull LifetimeDefinition child2, boolean inheritTimeoutKind) {
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child");
        if (!(!RLifetimeKt.isEternal(child2))) {
            boolean bl = false;
            String string2 = this + ": Can't attach eternal lifetime";
            throw new IllegalArgumentException(string2.toString());
        }
        if (RLifetimeKt.isNotAlive(child2)) {
            return;
        }
        if (inheritTimeoutKind) {
            child2.setTerminationTimeoutKind(this.getTerminationTimeoutKind());
        }
        if (!this.tryAdd(child2)) {
            LifetimeDefinition.terminate$default(child2, false, 1, null);
        }
    }

    @Override
    @Nullable
    public <T> T bracketIfAlive(@NotNull Function0<? extends T> opening, @NotNull Function0<Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        return this.executeIfAlive((Function0)new Function0<T>(opening, this, terminationAction){
            final /* synthetic */ Function0<T> $opening;
            final /* synthetic */ LifetimeDefinition this$0;
            final /* synthetic */ Function0<Unit> $terminationAction;
            {
                this.$opening = $opening;
                this.this$0 = $receiver;
                this.$terminationAction = $terminationAction;
                super(0);
            }

            @NotNull
            public final T invoke() {
                Object res2 = this.$opening.invoke();
                if (!LifetimeDefinition.access$tryAdd(this.this$0, this.$terminationAction)) {
                    this.$terminationAction.invoke();
                }
                return (T)res2;
            }
        });
    }

    @Override
    @Nullable
    public <T> T bracketIfAliveEx(@NotNull Function0<? extends T> opening, @NotNull Function1<? super T, Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        return this.executeIfAlive((Function0)new Function0<T>(opening, this, terminationAction){
            final /* synthetic */ Function0<T> $opening;
            final /* synthetic */ LifetimeDefinition this$0;
            final /* synthetic */ Function1<T, Unit> $terminationAction;
            {
                this.$opening = $opening;
                this.this$0 = $receiver;
                this.$terminationAction = $terminationAction;
                super(0);
            }

            @NotNull
            public final T invoke() {
                Object res2 = this.$opening.invoke();
                if (!LifetimeDefinition.access$tryAdd(this.this$0, new Function0<Unit>(this.$terminationAction, res2){
                    final /* synthetic */ Function1<T, Unit> $terminationAction;
                    final /* synthetic */ T $res;
                    {
                        this.$terminationAction = $terminationAction;
                        this.$res = $res;
                        super(0);
                    }

                    public final void invoke() {
                        this.$terminationAction.invoke(this.$res);
                    }
                })) {
                    this.$terminationAction.invoke(res2);
                }
                return (T)res2;
            }
        });
    }

    @Override
    @NotNull
    public <T> T bracketOrThrow(@NotNull Function0<? extends T> opening, @NotNull Function0<Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        T t = this.bracketIfAlive(opening, terminationAction);
        if (t == null) {
            throw new CancellationException();
        }
        return t;
    }

    @Override
    @NotNull
    public <T> T bracketOrThrowEx(@NotNull Function0<? extends T> opening, @NotNull Function1<? super T, Unit> terminationAction) {
        Intrinsics.checkNotNullParameter(opening, (String)"opening");
        Intrinsics.checkNotNullParameter(terminationAction, (String)"terminationAction");
        T t = this.bracketIfAliveEx(opening, terminationAction);
        if (t == null) {
            throw new CancellationException();
        }
        return t;
    }

    @NotNull
    public String toString() {
        Object object = this.getId();
        if (object == null) {
            object = anonymousLifetimeId;
        }
        return "Lifetime `" + object + "` [" + this.getStatus() + ", executing=" + BitSliceKt.get(executingSlice, this.state) + ", resources=" + this.resCount + "]";
    }

    public static final /* synthetic */ boolean access$tryAdd(LifetimeDefinition $this, Object action) {
        return $this.tryAdd(action);
    }

    static {
        Object object = BitSlice.Companion;
        BitSlice prev$iv = executingSlice;
        boolean $i$f$enum = false;
        Enum[] values$iv = LifetimeStatus.values();
        if (!(values$iv.length >= 2)) {
            boolean $i$a$-require-BitSlice$Companion$enum$1$iv22 = false;
            String $i$a$-require-BitSlice$Companion$enum$1$iv22 = "Bit slice for enums with " + values$iv + " values is meaningless";
            throw new IllegalArgumentException($i$a$-require-BitSlice$Companion$enum$1$iv22.toString());
        }
        int n = BitSliceKt.nextSliceLow(prev$iv);
        int $i$a$-require-BitSlice$Companion$enum$1$iv22 = BitHacksKt.log2ceil(values$iv.length);
        statusSlice = new BitSlice.TypedBitSlice<LifetimeStatus>(values$iv, n, $i$a$-require-BitSlice$Companion$enum$1$iv22){
            final /* synthetic */ Enum[] $values;
            {
                this.$values = $values;
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            public LifetimeStatus get(int host) {
                return this.$values[this.getRaw(host)];
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int updated(int host, @NotNull Enum value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return this.updatedRaw(host, value2.ordinal());
            }
        };
        mutexSlice = BitSlice.Companion.bool(statusSlice);
        logErrorAfterExecution = BitSlice.Companion.bool(mutexSlice);
        BitSlice.Companion this_$iv = BitSlice.Companion;
        prev$iv = logErrorAfterExecution;
        $i$f$enum = false;
        values$iv = LifetimeTerminationTimeoutKind.values();
        if (!(values$iv.length >= 2)) {
            $i$a$-require-BitSlice$Companion$enum$1$iv22 = 0;
            String string2 = "Bit slice for enums with " + values$iv + " values is meaningless";
            throw new IllegalArgumentException(string2.toString());
        }
        n = BitSliceKt.nextSliceLow(prev$iv);
        int n2 = BitHacksKt.log2ceil(values$iv.length);
        terminationTimeoutKindSlice = new BitSlice.TypedBitSlice<LifetimeTerminationTimeoutKind>(values$iv, n, n2){
            final /* synthetic */ Enum[] $values;
            {
                this.$values = $values;
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            public LifetimeTerminationTimeoutKind get(int host) {
                return this.$values[this.getRaw(host)];
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int updated(int host, @NotNull Enum value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return this.updatedRaw(host, value2.ordinal());
            }
        };
        allowTerminationUnderExecutionSlice = BitSlice.Companion.bool(terminationTimeoutKindSlice);
        Object $this$Terminated_u24lambda_u2419 = object = new LifetimeDefinition();
        boolean bl = false;
        ((LifetimeDefinition)$this$Terminated_u24lambda_u2419).setId("Terminated");
        Terminated = object;
        Object $this$eternal_u24lambda_u2420 = object = new LifetimeDefinition();
        boolean bl2 = false;
        ((LifetimeDefinition)$this$eternal_u24lambda_u2420).setId("Eternal");
        eternal = object;
        LifetimeDefinition.terminate$default(Terminated, false, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition$AdditionalFields;", "", "id", "(Ljava/lang/Object;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "cancel", "", "rd-core"})
    private static class AdditionalFields {
        @NotNull
        private final CoroutineScope scope;

        public AdditionalFields(@Nullable Object id) {
            Object object = id;
            this.scope = RdCoroutineScope.Companion.getCurrent().createNestedScope$rd_core(object != null ? object.toString() : null);
        }

        @NotNull
        public CoroutineScope getScope() {
            return this.scope;
        }

        public final void cancel() {
            CoroutineScopeKt.cancel$default((CoroutineScope)this.getScope(), null, (int)1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition$Companion;", "", "()V", "Terminated", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getTerminated", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "allowTerminationUnderExecutionSlice", "Lcom/jetbrains/rd/util/BitSlice$TypedBitSlice;", "", "anonymousLifetimeId", "", "eternal", "getEternal$rd_core", "executingSlice", "", "log", "Lcom/jetbrains/rd/util/Logger;", "getLog", "()Lcom/jetbrains/rd/util/Logger;", "log$delegate", "Lkotlin/Lazy;", "logErrorAfterExecution", "mutexSlice", "statusSlice", "Lcom/jetbrains/rd/util/lifetime/LifetimeStatus;", "terminationTimeoutKindSlice", "Lcom/jetbrains/rd/util/lifetime/LifetimeTerminationTimeoutKind;", "rd-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final LifetimeDefinition getTerminated() {
            return Terminated;
        }

        @NotNull
        public final LifetimeDefinition getEternal$rd_core() {
            return eternal;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition$EternalAdditionalFields;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition$AdditionalFields;", "()V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "rd-core"})
    private static final class EternalAdditionalFields
    extends AdditionalFields {
        @NotNull
        public static final EternalAdditionalFields INSTANCE = new EternalAdditionalFields();

        private EternalAdditionalFields() {
            super(null);
        }

        @Override
        @NotNull
        public CoroutineScope getScope() {
            return RdCoroutineScope.Companion.getCurrent();
        }
    }
}

