/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceEntity;
import org.jitsi.xmpp.extensions.colibri2.Capability;
import org.jitsi.xmpp.extensions.colibri2.ForceMute;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muc.MUCRole;

public class Colibri2Endpoint
extends AbstractConferenceEntity {
    public static final String ELEMENT = "endpoint";
    public static final QName QNAME = new QName("jitsi:colibri2", "endpoint");
    public static final String STATS_ID_ATTR_NAME = "stats-id";
    public static final String MUC_ROLE_ATTR_NAME = "muc-role";

    public Colibri2Endpoint() {
        super(ELEMENT);
    }

    private Colibri2Endpoint(Builder b) {
        super(b, ELEMENT);
        if (b.statsId != null) {
            this.setAttribute(STATS_ID_ATTR_NAME, b.statsId);
        }
        if (b.mucRole != null) {
            this.setAttribute(MUC_ROLE_ATTR_NAME, b.mucRole.toString());
        }
        if (b.forceMute != null) {
            this.addChildExtension(b.forceMute);
        }
        for (Capability c : b.capabilities) {
            this.addChildExtension(c);
        }
    }

    @Nullable
    public String getStatsId() {
        return this.getAttributeAsString(STATS_ID_ATTR_NAME);
    }

    @Nullable
    public MUCRole getMucRole() {
        return MUCRole.fromString(this.getAttributeAsString(MUC_ROLE_ATTR_NAME));
    }

    @Nullable
    public ForceMute getForceMute() {
        return this.getFirstChildOfType(ForceMute.class);
    }

    public List<Capability> getCapabilities() {
        return this.getChildExtensionsOfType(Capability.class);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder getBuilder() {
        return new Builder();
    }

    public boolean hasCapability(String capabilityName) {
        return this.getCapabilities().stream().anyMatch(c -> capabilityName.equals(c.getName()));
    }

    public static class Provider
    extends AbstractConferenceEntity.Provider<Colibri2Endpoint> {
        public Provider() {
            super(Colibri2Endpoint.class);
        }

        @Override
        public Colibri2Endpoint parse(XmlPullParser parser, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
            Colibri2Endpoint ep = (Colibri2Endpoint)super.parse(parser, depth, xmlEnvironment);
            String mucRole = ep.getAttributeAsString(Colibri2Endpoint.MUC_ROLE_ATTR_NAME);
            if (mucRole != null) {
                try {
                    MUCRole.fromString(mucRole);
                }
                catch (IllegalArgumentException e) {
                    throw new SmackParsingException("muc-role:" + e.getMessage());
                }
            }
            return ep;
        }
    }

    public static class Builder
    extends AbstractConferenceEntity.Builder {
        private String statsId;
        private MUCRole mucRole;
        @Nullable
        private ForceMute forceMute = null;
        private final List<Capability> capabilities = new LinkedList<Capability>();

        private Builder() {
        }

        public Builder setStatsId(String id) {
            this.statsId = id;
            return this;
        }

        public Builder setMucRole(MUCRole mucRole) {
            this.mucRole = mucRole;
            return this;
        }

        public Builder setForceMute(@Nullable ForceMute forceMute) {
            this.forceMute = forceMute;
            return this;
        }

        public Builder setForceMute(boolean audio, boolean video) {
            this.forceMute = new ForceMute(audio, video);
            return this;
        }

        public Builder addCapability(String capabilityName) {
            this.capabilities.add(new Capability(capabilityName));
            return this;
        }

        @Override
        @Contract(value=" -> new")
        @NotNull
        public Colibri2Endpoint build() {
            return new Colibri2Endpoint(this);
        }
    }
}

