/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.converter;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlSelectGroupByExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.domain.ColumnTypeProvider;
import org.opensearch.sql.legacy.expression.core.Expression;
import org.opensearch.sql.legacy.expression.core.ExpressionFactory;
import org.opensearch.sql.legacy.query.planner.converter.SQLExprToExpressionConverter;
import org.opensearch.sql.legacy.query.planner.core.ColumnNode;

public class SQLAggregationParser {
    private final ColumnTypeProvider columnTypeProvider;
    private Context context;
    private List<ColumnNode> columnNodes = new ArrayList<ColumnNode>();

    public void parse(MySqlSelectQueryBlock queryBlock) {
        this.context = new Context(this.constructSQLExprAliasMapFromSelect(queryBlock));
        List<String> selectItemNames = this.extractSelectItemNames(queryBlock.getSelectList());
        this.rewriteFunctionNameToLowerCase(queryBlock);
        this.findAllGroupKeyExprFromGroupByAndSelect(queryBlock);
        this.findAllAggregationExprFromSelect(queryBlock);
        this.parseExprInSelectList(queryBlock, selectItemNames, new SQLExprToExpressionConverter(this.context));
    }

    public List<SQLSelectItem> selectItemList() {
        ArrayList<SQLSelectItem> sqlSelectItems = new ArrayList<SQLSelectItem>();
        this.context.getGroupKeyExprMap().entrySet().forEach(entry -> sqlSelectItems.add(new SQLSelectItem((SQLExpr)entry.getKey(), ((Context.GroupKeyExpr)entry.getValue()).getExpression().toString())));
        this.context.getAggregationExprMap().entrySet().forEach(entry -> sqlSelectItems.add(new SQLSelectItem((SQLExpr)entry.getKey(), ((Context.AggregationExpr)entry.getValue()).getExpression().toString())));
        return sqlSelectItems;
    }

    private Map<SQLExpr, String> constructSQLExprAliasMapFromSelect(MySqlSelectQueryBlock queryBlock) {
        return queryBlock.getSelectList().stream().filter(item -> !Strings.isNullOrEmpty((String)item.getAlias())).collect(Collectors.toMap(SQLSelectItem::getExpr, SQLSelectItem::getAlias));
    }

    private void findAllGroupKeyExprFromGroupByAndSelect(MySqlSelectQueryBlock queryBlock) {
        if (queryBlock.getGroupBy() == null) {
            return;
        }
        List groupByKeyExprList = queryBlock.getGroupBy().getItems().stream().map(item -> ((MySqlSelectGroupByExpr)item).getExpr()).collect(Collectors.toList());
        for (final SQLSelectItem selectItem : queryBlock.getSelectList()) {
            SQLExpr selectItemExpr = selectItem.getExpr();
            if (selectItemExpr instanceof SQLIdentifierExpr) {
                this.context.addGroupKeyExpr(selectItemExpr);
                continue;
            }
            for (SQLExpr groupByExpr : groupByKeyExprList) {
                if (this.compareSelectExprAndGroupByExpr(selectItemExpr, selectItem.getAlias(), groupByExpr)) {
                    this.context.addGroupKeyExpr(selectItemExpr);
                    continue;
                }
                if (!(groupByExpr instanceof SQLIdentifierExpr)) continue;
                final String groupByName = ((SQLIdentifierExpr)groupByExpr).getName();
                selectItemExpr.accept((SQLASTVisitor)new MySqlASTVisitorAdapter(){

                    public boolean visit(SQLAggregateExpr x) {
                        return false;
                    }

                    public boolean visit(SQLIdentifierExpr expr) {
                        if (groupByName.equalsIgnoreCase(expr.getName())) {
                            expr.setParent(selectItem.getParent());
                            SQLAggregationParser.this.context.addGroupKeyExpr((SQLExpr)expr);
                        }
                        return false;
                    }
                });
            }
        }
    }

    private boolean compareSelectExprAndGroupByExpr(SQLExpr selectItemExpr, String alias, SQLExpr groupByExpr) {
        if (groupByExpr.equals(selectItemExpr)) {
            return true;
        }
        return groupByExpr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)groupByExpr).getName().equalsIgnoreCase(alias);
    }

    private void findAllAggregationExprFromSelect(MySqlSelectQueryBlock queryBlock) {
        queryBlock.getSelectList().forEach(selectItem -> selectItem.accept((SQLASTVisitor)new MySqlASTVisitorAdapter(){

            public boolean visit(SQLAggregateExpr expr) {
                SQLAggregationParser.this.context.addAggregationExpr(expr);
                return true;
            }
        }));
    }

    private void parseExprInSelectList(MySqlSelectQueryBlock queryBlock, List<String> selectItemNames, SQLExprToExpressionConverter exprConverter) {
        List selectItems = queryBlock.getSelectList();
        for (int i = 0; i < selectItems.size(); ++i) {
            Expression expression = exprConverter.convert(((SQLSelectItem)selectItems.get(i)).getExpr());
            ColumnNode columnNode = ColumnNode.builder().name(selectItemNames.get(i)).alias(((SQLSelectItem)selectItems.get(i)).getAlias()).type(this.columnTypeProvider.get(i)).expr(expression).build();
            this.columnNodes.add(columnNode);
        }
    }

    private List<String> extractSelectItemNames(List<SQLSelectItem> selectItems) {
        ArrayList<String> selectItemNames = new ArrayList<String>();
        for (SQLSelectItem selectItem : selectItems) {
            selectItemNames.add(this.nameOfSelectItem(selectItem));
        }
        return selectItemNames;
    }

    private void rewriteFunctionNameToLowerCase(MySqlSelectQueryBlock query) {
        query.accept((SQLASTVisitor)new MySqlASTVisitorAdapter(){

            public boolean visit(SQLMethodInvokeExpr x) {
                x.setMethodName(x.getMethodName().toLowerCase());
                return true;
            }
        });
    }

    private String nameOfSelectItem(SQLSelectItem selectItem) {
        return Strings.isNullOrEmpty((String)selectItem.getAlias()) ? Context.nameOfExpr(selectItem.getExpr()) : selectItem.getAlias();
    }

    public SQLAggregationParser(ColumnTypeProvider columnTypeProvider) {
        this.columnTypeProvider = columnTypeProvider;
    }

    public List<ColumnNode> getColumnNodes() {
        return this.columnNodes;
    }

    public static class Context {
        private final AliasGenerator aliasGenerator = new AliasGenerator();
        private final Map<SQLExpr, String> selectSQLExprAliasMap;
        private final Map<SQLExpr, GroupKeyExpr> groupKeyExprMap = new LinkedHashMap<SQLExpr, GroupKeyExpr>();
        private final Map<SQLExpr, AggregationExpr> aggregationExprMap = new LinkedHashMap<SQLExpr, AggregationExpr>();

        Optional<Expression> resolve(SQLExpr expr) {
            if (this.groupKeyExprMap.containsKey(expr)) {
                return Optional.of(this.groupKeyExprMap.get(expr).getExpression());
            }
            if (this.aggregationExprMap.containsKey(expr)) {
                return Optional.of(this.aggregationExprMap.get(expr).getExpression());
            }
            return Optional.empty();
        }

        public void addGroupKeyExpr(SQLExpr groupKeyExpr) {
            if (!this.groupKeyExprMap.containsKey(groupKeyExpr)) {
                this.groupKeyExprMap.put(groupKeyExpr, new GroupKeyExpr(groupKeyExpr));
            }
        }

        public void addAggregationExpr(SQLAggregateExpr aggregationExpr) {
            if (!this.aggregationExprMap.containsKey(aggregationExpr)) {
                this.aggregationExprMap.put((SQLExpr)aggregationExpr, new AggregationExpr(aggregationExpr));
            }
        }

        public static String nameOfExpr(SQLExpr expr) {
            String exprName = expr.toString().toLowerCase();
            if (expr instanceof SQLAggregateExpr) {
                SQLAggregateExpr aggExpr = (SQLAggregateExpr)expr;
                SQLAggregateOption option = aggExpr.getOption();
                exprName = option == null ? String.format("%s(%s)", aggExpr.getMethodName(), aggExpr.getArguments().get(0)) : String.format("%s(%s %s)", aggExpr.getMethodName(), option.name(), aggExpr.getArguments().get(0));
            } else if (expr instanceof SQLMethodInvokeExpr) {
                exprName = String.format("%s(%s)", ((SQLMethodInvokeExpr)expr).getMethodName(), Context.nameOfExpr((SQLExpr)((SQLMethodInvokeExpr)expr).getParameters().get(0)));
            } else if (expr instanceof SQLIdentifierExpr) {
                exprName = ((SQLIdentifierExpr)expr).getName();
            } else if (expr instanceof SQLCastExpr) {
                exprName = String.format("CAST(%s AS %s)", ((SQLCastExpr)expr).getExpr(), ((SQLCastExpr)expr).getDataType().getName());
            }
            return exprName;
        }

        public Context(Map<SQLExpr, String> selectSQLExprAliasMap) {
            this.selectSQLExprAliasMap = selectSQLExprAliasMap;
        }

        public Map<SQLExpr, GroupKeyExpr> getGroupKeyExprMap() {
            return this.groupKeyExprMap;
        }

        public Map<SQLExpr, AggregationExpr> getAggregationExprMap() {
            return this.aggregationExprMap;
        }

        public class GroupKeyExpr {
            private final SQLExpr expr;
            private final Expression expression;

            public GroupKeyExpr(SQLExpr expr) {
                this.expr = expr;
                String exprName = Context.nameOfExpr(expr).replace(".", "#");
                if (expr instanceof SQLIdentifierExpr && Context.this.selectSQLExprAliasMap.values().contains(((SQLIdentifierExpr)expr).getName())) {
                    exprName = ((SQLIdentifierExpr)expr).getName();
                }
                this.expression = ExpressionFactory.ref(Context.this.selectSQLExprAliasMap.getOrDefault(expr, exprName));
            }

            public SQLExpr getExpr() {
                return this.expr;
            }

            public Expression getExpression() {
                return this.expression;
            }
        }

        public class AggregationExpr {
            private final SQLAggregateExpr expr;
            private final Expression expression;

            public AggregationExpr(SQLAggregateExpr expr) {
                this.expr = expr;
                this.expression = ExpressionFactory.ref(Context.this.selectSQLExprAliasMap.getOrDefault(expr, Context.this.aliasGenerator.nextAlias(expr.getMethodName())));
            }

            public SQLAggregateExpr getExpr() {
                return this.expr;
            }

            public Expression getExpression() {
                return this.expression;
            }
        }

        static class AliasGenerator {
            private int aliasSuffix = 0;

            AliasGenerator() {
            }

            private String nextAlias(String name) {
                return String.format("%s_%d", name, this.next());
            }

            private Integer next() {
                return this.aliasSuffix++;
            }
        }
    }
}

