/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.ShardPath;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.indices.cluster.IndicesClusterStateService;

public class FileCacheCleaner
implements IndexEventListener {
    private static final Logger log = LogManager.getLogger(FileCacheCleaner.class);
    private final NodeEnvironment nodeEnvironment;
    private final FileCache fileCache;

    public FileCacheCleaner(NodeEnvironment nodeEnvironment, FileCache fileCache) {
        this.nodeEnvironment = nodeEnvironment;
        this.fileCache = fileCache;
    }

    @Override
    public void beforeIndexShardDeleted(ShardId shardId, Settings settings) {
        block9: {
            try {
                if (!FileCacheCleaner.isRemoteSnapshot(settings)) break block9;
                ShardPath shardPath = ShardPath.loadFileCachePath(this.nodeEnvironment, shardId);
                Path localStorePath = shardPath.getDataPath().resolve("RemoteLocalStore");
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(localStorePath);){
                    for (Path subPath : ds) {
                        this.fileCache.remove(subPath.toRealPath(new LinkOption[0]));
                    }
                }
            }
            catch (IOException ioe) {
                log.error(() -> new ParameterizedMessage("Error removing items from cache during shard deletion {}", (Object)shardId), (Throwable)ioe);
            }
        }
    }

    @Override
    public void afterIndexShardDeleted(ShardId shardId, Settings settings) {
        if (FileCacheCleaner.isRemoteSnapshot(settings)) {
            Path path = ShardPath.loadFileCachePath(this.nodeEnvironment, shardId).getDataPath();
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    IOUtils.rm((Path[])new Path[]{path});
                }
            }
            catch (IOException e) {
                log.error(() -> new ParameterizedMessage("Failed to delete cache path for shard {}", (Object)shardId), (Throwable)e);
            }
        }
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        Path indexCachePath;
        if (FileCacheCleaner.isRemoteSnapshot(indexSettings.getSettings()) && reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED && Files.exists(indexCachePath = this.nodeEnvironment.fileCacheNodePath().fileCachePath.resolve(index.getUUID()), new LinkOption[0])) {
            try {
                IOUtils.rm((Path[])new Path[]{indexCachePath});
            }
            catch (IOException e) {
                log.error(() -> new ParameterizedMessage("Failed to delete cache path for index {}", (Object)index), (Throwable)e);
            }
        }
    }

    private static boolean isRemoteSnapshot(Settings settings) {
        return IndexModule.Type.REMOTE_SNAPSHOT.match(settings.get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey()));
    }
}

