/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationState;
import org.opensearch.indices.replication.common.ReplicationTimer;

public class RecoveryState
implements ReplicationState,
ToXContentFragment,
Writeable {
    private Stage stage;
    private final ReplicationLuceneIndex index;
    private final Translog translog;
    private final VerifyIndex verifyIndex;
    private final ReplicationTimer timer;
    private RecoverySource recoverySource;
    private ShardId shardId;
    @Nullable
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;
    private boolean primary;

    public RecoveryState(ShardRouting shardRouting, DiscoveryNode targetNode, @Nullable DiscoveryNode sourceNode) {
        this(shardRouting, targetNode, sourceNode, new ReplicationLuceneIndex());
    }

    public RecoveryState(ShardRouting shardRouting, DiscoveryNode targetNode, @Nullable DiscoveryNode sourceNode, ReplicationLuceneIndex index) {
        assert (shardRouting.initializing()) : "only allow initializing shard routing to be recovered: " + shardRouting;
        RecoverySource recoverySource = shardRouting.recoverySource();
        assert (recoverySource.getType() == RecoverySource.Type.PEER == (sourceNode != null)) : "peer recovery requires source node, recovery type: " + recoverySource.getType() + " source node: " + sourceNode;
        this.shardId = shardRouting.shardId();
        this.primary = shardRouting.primary();
        this.recoverySource = recoverySource;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.stage = Stage.INIT;
        this.index = index;
        this.translog = new Translog();
        this.verifyIndex = new VerifyIndex();
        this.timer = new ReplicationTimer();
        this.timer.start();
    }

    public RecoveryState(StreamInput in) throws IOException {
        this.timer = new ReplicationTimer(in);
        this.stage = Stage.fromId(in.readByte());
        this.shardId = new ShardId(in);
        this.recoverySource = RecoverySource.readFrom(in);
        this.targetNode = new DiscoveryNode(in);
        this.sourceNode = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
        this.index = new ReplicationLuceneIndex(in);
        this.translog = new Translog(in);
        this.verifyIndex = new VerifyIndex(in);
        this.primary = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.timer.writeTo(out);
        out.writeByte(this.stage.id());
        this.shardId.writeTo(out);
        this.recoverySource.writeTo(out);
        this.targetNode.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.sourceNode);
        this.index.writeTo(out);
        this.translog.writeTo(out);
        this.verifyIndex.writeTo(out);
        out.writeBoolean(this.primary);
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public synchronized Stage getStage() {
        return this.stage;
    }

    protected void validateAndSetStage(Stage expected, Stage next) {
        if (this.stage != expected) {
            assert (false) : "can't move recovery to stage [" + next + "]. current stage: [" + this.stage + "] (expected [" + expected + "])";
            throw new IllegalStateException("can't move recovery to stage [" + next + "]. current stage: [" + this.stage + "] (expected [" + expected + "])");
        }
        this.stage = next;
    }

    public synchronized void validateCurrentStage(Stage expected) {
        if (this.stage != expected) {
            assert (false) : "expected stage [" + expected + "]; but current stage is [" + this.stage + "]";
            throw new IllegalStateException("expected stage [" + expected + "] but current stage is [" + this.stage + "]");
        }
    }

    public synchronized RecoveryState setStage(Stage stage) {
        switch (stage) {
            case INIT: {
                this.stage = Stage.INIT;
                this.getIndex().reset();
                this.getVerifyIndex().reset();
                this.getTranslog().reset();
                break;
            }
            case INDEX: {
                this.validateAndSetStage(Stage.INIT, stage);
                this.getIndex().start();
                break;
            }
            case VERIFY_INDEX: {
                this.validateAndSetStage(Stage.INDEX, stage);
                this.getIndex().stop();
                this.getVerifyIndex().start();
                break;
            }
            case TRANSLOG: {
                this.validateAndSetStage(Stage.VERIFY_INDEX, stage);
                this.getVerifyIndex().stop();
                this.getTranslog().start();
                break;
            }
            case FINALIZE: {
                assert (this.getIndex().bytesStillToRecover() >= 0L) : "moving to stage FINALIZE without completing file details";
                this.validateAndSetStage(Stage.TRANSLOG, stage);
                this.getTranslog().stop();
                break;
            }
            case DONE: {
                this.validateAndSetStage(Stage.FINALIZE, stage);
                this.getTimer().stop();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown RecoveryState.Stage [" + stage + "]");
            }
        }
        return this;
    }

    @Override
    public ReplicationLuceneIndex getIndex() {
        return this.index;
    }

    public VerifyIndex getVerifyIndex() {
        return this.verifyIndex;
    }

    public Translog getTranslog() {
        return this.translog;
    }

    @Override
    public ReplicationTimer getTimer() {
        return this.timer;
    }

    public RecoverySource getRecoverySource() {
        return this.recoverySource;
    }

    @Nullable
    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public boolean getPrimary() {
        return this.primary;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("id", this.shardId.id());
        builder.field("type", (Object)this.recoverySource.getType());
        builder.field("stage", this.stage.toString());
        builder.field("primary", this.primary);
        builder.timeField("start_time_in_millis", "start_time", this.timer.startTime());
        if (this.timer.stopTime() > 0L) {
            builder.timeField("stop_time_in_millis", "stop_time", this.timer.stopTime());
        }
        builder.humanReadableField("total_time_in_millis", "total_time", (Object)new TimeValue(this.timer.time()));
        if (this.recoverySource.getType() == RecoverySource.Type.PEER) {
            builder.startObject("source");
            builder.field("id", this.sourceNode.getId());
            builder.field("host", this.sourceNode.getHostName());
            builder.field("transport_address", this.sourceNode.getAddress().toString());
            builder.field("ip", this.sourceNode.getHostAddress());
            builder.field("name", this.sourceNode.getName());
            builder.endObject();
        } else {
            builder.startObject("source");
            this.recoverySource.addAdditionalFields(builder, params);
            builder.endObject();
        }
        builder.startObject("target");
        builder.field("id", this.targetNode.getId());
        builder.field("host", this.targetNode.getHostName());
        builder.field("transport_address", this.targetNode.getAddress().toString());
        builder.field("ip", this.targetNode.getHostAddress());
        builder.field("name", this.targetNode.getName());
        builder.endObject();
        builder.startObject("index");
        this.index.toXContent(builder, params);
        builder.endObject();
        builder.startObject("translog");
        this.translog.toXContent(builder, params);
        builder.endObject();
        builder.startObject("verify_index");
        this.verifyIndex.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage INIT = new Stage(0);
        public static final /* enum */ Stage INDEX = new Stage(1);
        public static final /* enum */ Stage VERIFY_INDEX = new Stage(2);
        public static final /* enum */ Stage TRANSLOG = new Stage(3);
        public static final /* enum */ Stage FINALIZE = new Stage(4);
        public static final /* enum */ Stage DONE = new Stage(5);
        private static final Stage[] STAGES;
        private final byte id;
        private static final /* synthetic */ Stage[] $VALUES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String name) {
            return Enum.valueOf(Stage.class, name);
        }

        private Stage(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Stage fromId(byte id) {
            if (id < 0 || id >= STAGES.length) {
                throw new IllegalArgumentException("No mapping for id [" + id + "]");
            }
            return STAGES[id];
        }

        private static /* synthetic */ Stage[] $values() {
            return new Stage[]{INIT, INDEX, VERIFY_INDEX, TRANSLOG, FINALIZE, DONE};
        }

        static {
            $VALUES = Stage.$values();
            STAGES = new Stage[Stage.values().length];
            for (Stage stage : Stage.values()) {
                assert (stage.id() < STAGES.length && stage.id() >= 0);
                Stage.STAGES[stage.id] = stage;
            }
        }
    }

    public static class Translog
    extends ReplicationTimer
    implements ToXContentFragment,
    Writeable {
        public static final int UNKNOWN = -1;
        private int recovered;
        private int total = -1;
        private int totalOnStart = -1;
        private int totalLocal = -1;

        public Translog() {
        }

        public Translog(StreamInput in) throws IOException {
            super(in);
            this.recovered = in.readVInt();
            this.total = in.readVInt();
            this.totalOnStart = in.readVInt();
            if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_4_0)) {
                this.totalLocal = in.readVInt();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.recovered);
            out.writeVInt(this.total);
            out.writeVInt(this.totalOnStart);
            if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_4_0)) {
                out.writeVInt(this.totalLocal);
            }
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.recovered = 0;
            this.total = -1;
            this.totalOnStart = -1;
            this.totalLocal = -1;
        }

        public synchronized void incrementRecoveredOperations() {
            ++this.recovered;
            assert (this.total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + this.total + "], recovered [" + this.recovered + "]";
        }

        public synchronized void incrementRecoveredOperations(int ops) {
            this.recovered += ops;
            assert (this.total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + this.total + "], recovered [" + this.recovered + "]";
        }

        public synchronized void decrementRecoveredOperations(int ops) {
            this.recovered -= ops;
            assert (this.recovered >= 0) : "recovered operations must be non-negative. Because [" + this.recovered + "] after decrementing [" + ops + "]";
            assert (this.total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + this.total + "], recovered [" + this.recovered + "]";
        }

        public synchronized int recoveredOperations() {
            return this.recovered;
        }

        public synchronized int totalOperations() {
            return this.total;
        }

        public synchronized void totalOperations(int total) {
            int n = this.total = this.totalLocal == -1 ? total : this.totalLocal + total;
            assert (total == -1 || this.total >= this.recovered) : "total, if known, should be > recovered. total [" + total + "], recovered [" + this.recovered + "]";
        }

        public synchronized int totalOperationsOnStart() {
            return this.totalOnStart;
        }

        public synchronized void totalOperationsOnStart(int total) {
            this.totalOnStart = this.totalLocal == -1 ? total : this.totalLocal + total;
        }

        public synchronized void totalLocal(int totalLocal) {
            assert (totalLocal >= this.recovered) : totalLocal + " < " + this.recovered;
            this.totalLocal = totalLocal;
        }

        public synchronized int totalLocal() {
            return this.totalLocal;
        }

        public synchronized float recoveredPercent() {
            if (this.total == -1) {
                return -1.0f;
            }
            if (this.total == 0) {
                return 100.0f;
            }
            return (float)this.recovered * 100.0f / (float)this.total;
        }

        public synchronized XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("recovered", this.recovered);
            builder.field("total", this.total);
            builder.field("percent", String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.recoveredPercent())));
            builder.field("total_on_start", this.totalOnStart);
            builder.humanReadableField("total_time_in_millis", "total_time", (Object)new TimeValue(this.time()));
            return builder;
        }
    }

    public static class VerifyIndex
    extends ReplicationTimer
    implements ToXContentFragment,
    Writeable {
        private volatile long checkIndexTime;

        public VerifyIndex() {
        }

        public VerifyIndex(StreamInput in) throws IOException {
            super(in);
            this.checkIndexTime = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVLong(this.checkIndexTime);
        }

        @Override
        public void reset() {
            super.reset();
            this.checkIndexTime = 0L;
        }

        public long checkIndexTime() {
            return this.checkIndexTime;
        }

        public void checkIndexTime(long checkIndexTime) {
            this.checkIndexTime = checkIndexTime;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.humanReadableField("check_index_time_in_millis", "check_index_time", (Object)new TimeValue(this.checkIndexTime));
            builder.humanReadableField("total_time_in_millis", "total_time", (Object)new TimeValue(this.time()));
            return builder;
        }
    }

    static final class Fields {
        static final String ID = "id";
        static final String TYPE = "type";
        static final String STAGE = "stage";
        static final String PRIMARY = "primary";
        static final String START_TIME = "start_time";
        static final String START_TIME_IN_MILLIS = "start_time_in_millis";
        static final String STOP_TIME = "stop_time";
        static final String STOP_TIME_IN_MILLIS = "stop_time_in_millis";
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String SOURCE = "source";
        static final String HOST = "host";
        static final String TRANSPORT_ADDRESS = "transport_address";
        static final String IP = "ip";
        static final String NAME = "name";
        static final String TARGET = "target";
        static final String INDEX = "index";
        static final String TRANSLOG = "translog";
        static final String TOTAL_ON_START = "total_on_start";
        static final String VERIFY_INDEX = "verify_index";
        static final String RECOVERED = "recovered";
        static final String CHECK_INDEX_TIME = "check_index_time";
        static final String CHECK_INDEX_TIME_IN_MILLIS = "check_index_time_in_millis";
        static final String TOTAL = "total";
        static final String PERCENT = "percent";

        Fields() {
        }
    }
}

