/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.opensearch.securityanalytics.rules.condition.ConditionAND;
import org.opensearch.securityanalytics.rules.condition.ConditionFieldEqualsValueExpression;
import org.opensearch.securityanalytics.rules.condition.ConditionIdentifier;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.condition.ConditionOR;
import org.opensearch.securityanalytics.rules.condition.ConditionValueExpression;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.objects.SigmaDetectionItem;
import org.opensearch.securityanalytics.rules.objects.SigmaDetections;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class ConditionSelector {
    private int argCount = 2;
    private boolean tokenList = true;
    private Either<Class<ConditionAND>, Class<ConditionOR>> condClass;
    private String pattern;
    private Either<ConditionItem, SigmaDetectionItem> parent;
    private boolean operator;

    public ConditionSelector(String quantifier, String identifierPattern) {
        this.condClass = "1".equals(quantifier) || "any".equals(quantifier) ? Either.right(ConditionOR.class) : Either.left(ConditionAND.class);
        this.pattern = identifierPattern;
    }

    public ConditionItem postProcess(SigmaDetections detections, Object parent) throws SigmaConditionError {
        this.parent = parent instanceof ConditionItem ? Either.left((ConditionItem)parent) : Either.right((SigmaDetectionItem)parent);
        Pattern r = this.pattern.equals("them") ? Pattern.compile(".*") : Pattern.compile(this.pattern.replace("*", ".*"));
        ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> ids = new ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>>();
        for (String identifier : detections.getDetections().keySet()) {
            if (!r.matcher(identifier).matches()) continue;
            ConditionItem item = new ConditionIdentifier(List.of(Either.right(identifier))).postProcess(detections, parent);
            ids.add(Either.left(item instanceof ConditionFieldEqualsValueExpression ? AnyOneOf.middleVal((ConditionFieldEqualsValueExpression)item) : (item instanceof ConditionValueExpression ? AnyOneOf.rightVal((ConditionValueExpression)item) : AnyOneOf.leftVal(item))));
        }
        ConditionItem conditionItem = this.condClass.isLeft() ? new ConditionAND(false, ids) : new ConditionOR(false, ids);
        return conditionItem;
    }
}

