/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.connector.MLUpdateConnectorAction;
import org.opensearch.ml.common.transport.connector.MLUpdateConnectorRequest;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUpdateConnectorAction
extends BaseRestHandler {
    private static final String ML_UPDATE_CONNECTOR_ACTION = "ml_update_connector_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUpdateConnectorAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_CONNECTOR_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/connectors/{%s}", "/_plugins/_ml", "connector_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUpdateConnectorRequest mlUpdateConnectorRequest = this.getRequest(request);
        return restChannel -> client.execute((ActionType)MLUpdateConnectorAction.INSTANCE, (ActionRequest)mlUpdateConnectorRequest, (ActionListener)new RestToXContentListener(restChannel));
    }

    @VisibleForTesting
    private MLUpdateConnectorRequest getRequest(RestRequest request) throws IOException {
        if (!this.mlFeatureEnabledSetting.isRemoteInferenceEnabled()) {
            throw new IllegalStateException("Remote Inference is currently disabled. To enable it, update the setting \"plugins.ml_commons.remote_inference_enabled\" to true.");
        }
        if (!this.mlFeatureEnabledSetting.isUpdateConnectorEnabled()) {
            throw new IllegalStateException("Update connector API is currently disabled. To enable it, update the setting \"plugins.ml_commons.update_connector.enabled\" to true.");
        }
        if (!request.hasContent()) {
            throw new OpenSearchParseException("Failed to update connector: Request body is empty", new Object[0]);
        }
        String connectorId = RestActionUtils.getParameterId(request, "connector_id");
        try {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            return MLUpdateConnectorRequest.parse((XContentParser)parser, (String)connectorId);
        }
        catch (IllegalStateException illegalStateException) {
            throw new OpenSearchParseException(illegalStateException.getMessage(), new Object[0]);
        }
    }
}

